/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.PublicCandidacyHashCode;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.DegreeOfficePublicCandidacyHashCode_Base;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.exceptions.HashCodeForEmailAndProcessAlreadyBounded;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityEmailTemplate;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityEmailTemplateType;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.period.MobilityApplicationPeriod;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public class DegreeOfficePublicCandidacyHashCode
extends DegreeOfficePublicCandidacyHashCode_Base {
    private static final String APPLICATION_SUBMISSION_LINK = ".const.public.application.submission.link";
    private static final String SEND_LINK_TO_ACCESS_SUBMISSION_FORM_SUBJECT = ".message.email.subject.send.link.to.submission.form";
    private static final String SEND_LINK_TO_ACCESS_SUBMISSION_FORM_BODY = ".message.email.body.send.link.to.submission.form";
    private static final String APPLICATION_ACCESS_LINK = ".const.public.application.access.link";
    private static final String INFORM_APPLICATION_SUCCESS_SUBJECT = ".message.email.subject.application.submited";
    private static final String INFORM_APPLICATION_SUCCESS_BODY = ".message.email.body.application.submited";
    private static final String RECOVERY_APPLICATION_SUBJECT = ".message.email.subject.recovery.access";
    private static final String RECOVERY_APPLICATION_BODY = ".message.email.body.recovery.access";

    public boolean isAssociatedWithEmailAndCandidacyProcess(String email, Class<? extends IndividualCandidacyProcess> type, CandidacyProcess process2, List<Degree> degreeList) {
        if (email.equals(this.getEmail()) && this.getIndividualCandidacyProcess() != null && !this.getIndividualCandidacyProcess().isCandidacyCancelled() && ((Object)((Object)this.getIndividualCandidacyProcess())).getClass() == type && this.getIndividualCandidacyProcess().getCandidacyProcess() == process2) {
            return CollectionUtils.disjunction(this.getIndividualCandidacyProcess().getCandidacy().getAllDegrees(), degreeList).isEmpty();
        }
        return false;
    }

    public boolean hasCandidacyProcess() {
        return this.getIndividualCandidacyProcess() != null;
    }

    public boolean isFromDegreeOffice() {
        return true;
    }

    public static DegreeOfficePublicCandidacyHashCode getUnusedOrCreateNewHashCodeAndSendEmailForApplicationSubmissionToCandidate(Class<? extends IndividualCandidacyProcess> individualCandidadyProcessClass, CandidacyProcess parentProcess, String email) throws HashCodeForEmailAndProcessAlreadyBounded {
        DegreeOfficePublicCandidacyHashCode hashCode = DegreeOfficePublicCandidacyHashCode.getUnusedOrCreateNewHashCode(individualCandidadyProcessClass, parentProcess, email);
        if (parentProcess.isMobility()) {
            MobilityApplicationProcess mobilityApplicationProcess = (MobilityApplicationProcess)((Object)parentProcess);
            MobilityApplicationPeriod candidacyPeriod = mobilityApplicationProcess.getCandidacyPeriod();
            MobilityEmailTemplate emailTemplateFor = candidacyPeriod.getEmailTemplateFor(MobilityEmailTemplateType.PREREGISTRATION);
            emailTemplateFor.sendEmailFor(hashCode);
        } else {
            hashCode.sendEmailForApplicationSubmissionCandidacyForm(individualCandidadyProcessClass);
        }
        return hashCode;
    }

    private void sendEmailForApplicationSubmissionCandidacyForm(Class<? extends IndividualCandidacyProcess> individualCandidadyProcessClass) {
        String subject = BundleUtil.getString((String)"resources.CandidateResources", (String)(individualCandidadyProcessClass.getSimpleName() + SEND_LINK_TO_ACCESS_SUBMISSION_FORM_SUBJECT), (String[])new String[0]);
        String body = BundleUtil.getString((String)"resources.CandidateResources", (String)(individualCandidadyProcessClass.getSimpleName() + SEND_LINK_TO_ACCESS_SUBMISSION_FORM_BODY), (String[])new String[]{Unit.getInstitutionName().getContent()});
        String link = BundleUtil.getString((String)"resources.CandidateResources", (String)(individualCandidadyProcessClass.getSimpleName() + APPLICATION_SUBMISSION_LINK), (String[])new String[0]);
        link = String.format(link, this.getValue(), I18N.getLocale());
        body = String.format(body, link);
        this.sendEmail(subject, body);
    }

    public void sendEmailForApplicationSuccessfullySubmited() {
        CandidacyProcess parentProcess = this.getIndividualCandidacyProcess().getCandidacyProcess();
        if (parentProcess.isMobility()) {
            MobilityApplicationProcess mobilityApplicationProcess = (MobilityApplicationProcess)((Object)parentProcess);
            MobilityApplicationPeriod candidacyPeriod = mobilityApplicationProcess.getCandidacyPeriod();
            MobilityEmailTemplate emailTemplateFor = candidacyPeriod.getEmailTemplateFor(MobilityEmailTemplateType.APPLICATION_SUBMISSION);
            emailTemplateFor.sendEmailFor(this);
            return;
        }
        String subject = MessageFormat.format(BundleUtil.getString((String)"resources.CandidateResources", (String)(((Object)((Object)this.getIndividualCandidacyProcess())).getClass().getSimpleName() + INFORM_APPLICATION_SUCCESS_SUBJECT), (String[])new String[0]), Unit.getInstitutionAcronym(), Unit.getInstitutionName().getContent());
        String body = MessageFormat.format(BundleUtil.getString((String)"resources.CandidateResources", (String)(((Object)((Object)this.getIndividualCandidacyProcess())).getClass().getSimpleName() + INFORM_APPLICATION_SUCCESS_BODY), (String[])new String[0]), Unit.getInstitutionAcronym(), Unit.getInstitutionName().getContent());
        String link = this.getDefaultPublicLink();
        body = String.format(body, this.getIndividualCandidacyProcess().getProcessCode(), link, this.getIndividualCandidacyProcess().getCandidacyProcess().getCandidacyEnd().toString("dd/MM/yyyy"));
        this.sendEmail(subject, body);
    }

    public void sendEmailFoAccessLinkRecovery() {
        String subject = BundleUtil.getString((String)"resources.CandidateResources", (String)(((Object)((Object)this.getIndividualCandidacyProcess())).getClass().getSimpleName() + RECOVERY_APPLICATION_SUBJECT), (String[])new String[0]);
        String body = BundleUtil.getString((String)"resources.CandidateResources", (String)(((Object)((Object)this.getIndividualCandidacyProcess())).getClass().getSimpleName() + RECOVERY_APPLICATION_BODY), (String[])new String[0]);
        String link = this.getDefaultPublicLink();
        body = String.format(body, link, this.getIndividualCandidacyProcess().getProcessCode());
        this.sendEmail(subject, body);
    }

    public String getDefaultPublicLink() {
        return String.format(BundleUtil.getString((String)"resources.CandidateResources", (String)(((Object)((Object)this.getIndividualCandidacyProcess())).getClass().getSimpleName() + APPLICATION_ACCESS_LINK), (String[])new String[0]), this.getValue(), I18N.getLocale().getLanguage());
    }

    public static DegreeOfficePublicCandidacyHashCode getUnusedOrCreateNewHashCode(Class<? extends IndividualCandidacyProcess> individualCandidadyProcessClass, CandidacyProcess parentProcess, String email) throws HashCodeForEmailAndProcessAlreadyBounded {
        DegreeOfficePublicCandidacyHashCode publicCandidacyHashCode = DegreeOfficePublicCandidacyHashCode.getPublicCandidacyHashCodeByEmailAndCandidacyProcessTypeOrNotAssociated(email, individualCandidadyProcessClass, parentProcess);
        if (publicCandidacyHashCode == null) {
            return DegreeOfficePublicCandidacyHashCode.createNewHashCode(email);
        }
        if (!publicCandidacyHashCode.hasCandidacyProcess()) {
            return publicCandidacyHashCode;
        }
        throw new HashCodeForEmailAndProcessAlreadyBounded("error.hash.code.for.email.and.process.already.bounded", new String[0]);
    }

    private static DegreeOfficePublicCandidacyHashCode createNewHashCode(String email) {
        DegreeOfficePublicCandidacyHashCode publicCandidacyHashCode = new DegreeOfficePublicCandidacyHashCode();
        publicCandidacyHashCode.setEmail(email);
        publicCandidacyHashCode.setValue(UUID.randomUUID().toString());
        return publicCandidacyHashCode;
    }

    public static DegreeOfficePublicCandidacyHashCode getPublicCandidacyHashCodeByEmailAndCandidacyProcessType(String email, Class<? extends IndividualCandidacyProcess> processType, CandidacyProcess process2) {
        return DegreeOfficePublicCandidacyHashCode.getPublicCandidacyHashCodeByEmailAndCandidacyProcessType(email, processType, process2, new ArrayList<Degree>());
    }

    public static DegreeOfficePublicCandidacyHashCode getPublicCandidacyHashCodeByEmailAndCandidacyProcessType(String email, Class<? extends IndividualCandidacyProcess> processType, CandidacyProcess process2, List<Degree> degreeList) {
        for (PublicCandidacyHashCode hashCode : DegreeOfficePublicCandidacyHashCode.getHashCodesAssociatedWithEmail((String)email)) {
            DegreeOfficePublicCandidacyHashCode hash;
            if (!hashCode.isFromDegreeOffice() || !(hash = (DegreeOfficePublicCandidacyHashCode)((Object)hashCode)).isAssociatedWithEmailAndCandidacyProcess(email, processType, process2, degreeList)) continue;
            return hash;
        }
        return null;
    }

    public static DegreeOfficePublicCandidacyHashCode getPublicCandidacyHashCodeByEmailAndCandidacyProcessTypeOrNotAssociated(String email, Class<? extends IndividualCandidacyProcess> processType, CandidacyProcess process2) {
        DegreeOfficePublicCandidacyHashCode associatedHashCode = DegreeOfficePublicCandidacyHashCode.getPublicCandidacyHashCodeByEmailAndCandidacyProcessType(email, processType, process2);
        if (associatedHashCode != null) {
            return associatedHashCode;
        }
        for (PublicCandidacyHashCode hashCode : DegreeOfficePublicCandidacyHashCode.getHashCodesAssociatedWithEmail((String)email)) {
            if (!hashCode.isFromDegreeOffice() || hashCode.hasCandidacyProcess()) continue;
            return (DegreeOfficePublicCandidacyHashCode)((Object)hashCode);
        }
        return null;
    }
}

