/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy;

import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.fenixedu.academic.domain.candidacy.IngressionType$callable$createIngressionType;
import org.fenixedu.academic.domain.candidacy.IngressionType_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class IngressionType
extends IngressionType_Base {
    public static final Advice advice$createIngressionType = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    private IngressionType() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public static IngressionType createIngressionType(String string, LocalizedString localizedString) {
        return (IngressionType)((Object)advice$createIngressionType.perform((Callable)new IngressionType$callable$createIngressionType(string, localizedString)));
    }

    static /* synthetic */ IngressionType advised$createIngressionType(String code, LocalizedString description) {
        IngressionType ingressionType = new IngressionType();
        ingressionType.setCode(code);
        ingressionType.setDescription(description);
        return ingressionType;
    }

    public boolean hasEntryPhase() {
        return this.getHasEntryPhase();
    }

    public String getLocalizedName() {
        return this.getLocalizedName(Locale.getDefault());
    }

    public String getLocalizedName(Locale locale) {
        return this.getCode() + " - " + this.getDescription().getContent(locale);
    }

    public static Optional<IngressionType> findIngressionTypeByCode(String name) {
        Predicate<IngressionType> matchesName = ingressionType -> name.equals(ingressionType.getCode());
        return Bennu.getInstance().getIngressionTypesSet().stream().filter(matchesName).findAny();
    }

    public static Optional<IngressionType> findByPredicate(Predicate<IngressionType> predicate) {
        return Bennu.getInstance().getIngressionTypesSet().stream().filter(predicate).findAny();
    }

    private void checkUniqueWithPredicate(Predicate<IngressionType> predicate) {
        Optional<IngressionType> findAny = Bennu.getInstance().getIngressionTypesSet().stream().filter(predicate.and(ingressionType -> ingressionType != this)).findAny();
        if (findAny.isPresent()) {
            throw new DomainException("label.error.ingressionTypePredicateIsNotUnique", new String[0]);
        }
    }

    @Deprecated
    public boolean isExternalDegreeChange() {
        return this.getIsExternalDegreeChange();
    }

    @Deprecated
    public boolean isInternalDegreeChange() {
        return this.getIsInternalDegreeChange();
    }

    @Deprecated
    public boolean isTransfer() {
        return this.getIsTransfer();
    }

    @Deprecated
    public boolean isMiddleAndSuperiorCourses() {
        return this.getIsMiddleAndSuperiorCourses();
    }

    @Deprecated
    public boolean isOver23() {
        return this.getIsOver23();
    }

    @Deprecated
    public boolean isInternal2ndCycleAccess() {
        return this.getIsInternal2ndCycleAccess();
    }

    @Deprecated
    public boolean isIsolatedCurricularUnits() {
        return this.getIsIsolatedCurricularUnits();
    }

    @Deprecated
    public boolean isInternal3rdCycleAccess() {
        return this.getIsInternal3rdCycleAccess();
    }

    @Deprecated
    public boolean isDirectAccessFrom1stCycle() {
        return this.getIsDirectAccessFrom1stCycle();
    }

    @Deprecated
    public boolean isHandicappedContingent() {
        return this.getIsHandicappedContingent();
    }

    @Deprecated
    public boolean isFirstCycleAttribution() {
        return this.getIsFirstCycleAttribution();
    }

    @Deprecated
    public boolean isReIngression() {
        return this.getIsReIngression();
    }

    @Deprecated
    protected void setIsExternalDegreeChange(boolean isExternalDegreeChange) {
        if (isExternalDegreeChange) {
            this.checkUniqueWithPredicate(IngressionType::isExternalDegreeChange);
        }
        super.setIsExternalDegreeChange(isExternalDegreeChange);
    }

    @Deprecated
    protected void setIsInternalDegreeChange(boolean isInternalDegreeChange) {
        if (isInternalDegreeChange) {
            this.checkUniqueWithPredicate(IngressionType::isInternalDegreeChange);
        }
        super.setIsInternalDegreeChange(isInternalDegreeChange);
    }

    @Deprecated
    protected void setIsTransfer(boolean isTransfer) {
        if (isTransfer) {
            this.checkUniqueWithPredicate(IngressionType::isTransfer);
        }
        super.setIsTransfer(isTransfer);
    }

    @Deprecated
    protected void setIsMiddleAndSuperiorCourses(boolean isMiddleAndSuperiorCourses) {
        if (isMiddleAndSuperiorCourses) {
            this.checkUniqueWithPredicate(IngressionType::isMiddleAndSuperiorCourses);
        }
        super.setIsMiddleAndSuperiorCourses(isMiddleAndSuperiorCourses);
    }

    @Deprecated
    protected void setIsOver23(boolean isOver23) {
        if (isOver23) {
            this.checkUniqueWithPredicate(IngressionType::isOver23);
        }
        super.setIsOver23(isOver23);
    }

    @Deprecated
    protected void setIsInternal2ndCycleAccess(boolean isInternal2ndCycleAccess) {
        if (isInternal2ndCycleAccess) {
            this.checkUniqueWithPredicate(IngressionType::isInternal2ndCycleAccess);
        }
        super.setIsInternal2ndCycleAccess(isInternal2ndCycleAccess);
    }

    public void setIsIsolatedCurricularUnits(boolean isIsolatedCurricularUnits) {
        if (isIsolatedCurricularUnits) {
            this.checkUniqueWithPredicate(IngressionType::isIsolatedCurricularUnits);
        }
        super.setIsIsolatedCurricularUnits(isIsolatedCurricularUnits);
    }

    @Deprecated
    protected void setIsInternal3rdCycleAccess(boolean isInternal3rdCycleAccess) {
        if (isInternal3rdCycleAccess) {
            this.checkUniqueWithPredicate(IngressionType::isInternal3rdCycleAccess);
        }
        super.setIsInternal3rdCycleAccess(isInternal3rdCycleAccess);
    }

    @Deprecated
    protected void setIsDirectAccessFrom1stCycle(boolean isDirectAccessFrom1stCycle) {
        if (isDirectAccessFrom1stCycle) {
            this.checkUniqueWithPredicate(IngressionType::isDirectAccessFrom1stCycle);
        }
        super.setIsDirectAccessFrom1stCycle(isDirectAccessFrom1stCycle);
    }

    @Deprecated
    protected void setIsHandicappedContingent(boolean isHandicappedContingent) {
        if (isHandicappedContingent) {
            this.checkUniqueWithPredicate(IngressionType::isHandicappedContingent);
        }
        super.setIsHandicappedContingent(isHandicappedContingent);
    }

    @Deprecated
    protected void setIsFirstCycleAttribution(boolean isFirstCycleAttribution) {
        if (isFirstCycleAttribution) {
            this.checkUniqueWithPredicate(IngressionType::isFirstCycleAttribution);
        }
        super.setIsFirstCycleAttribution(isFirstCycleAttribution);
    }

    @Deprecated
    protected void setIsReIngression(boolean isReIngression) {
        if (isReIngression) {
            this.checkUniqueWithPredicate(IngressionType::isReIngression);
        }
        super.setIsReIngression(isReIngression);
    }

    public void delete() {
        if (!this.getRegistrationSet().isEmpty()) {
            throw new DomainException("label.error.ingressionType.delete.hasRegistrationsAssociated", new String[0]);
        }
        if (!this.getStudentCandidacySet().isEmpty()) {
            throw new DomainException("label.error.ingressionType.delete.hasStudentCandidaciesAssociated", new String[0]);
        }
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public void editState(boolean hasEntryPhase, boolean isDirectAccessFrom1stCycle, boolean isExternalDegreeChange, boolean isFirstCycleAttribution, boolean isHandicappedContingent, boolean isInternal2ndCycleAccess, boolean isInternal3rdCycleAccess, boolean isInternalDegreeChange, boolean isIsolatedCurricularUnits, boolean isMiddleAndSuperiorCourses, boolean isOver23, boolean isReIngression, boolean isTransfer) {
        this.setHasEntryPhase(hasEntryPhase);
        this.setIsDirectAccessFrom1stCycle(isDirectAccessFrom1stCycle);
        this.setIsExternalDegreeChange(isExternalDegreeChange);
        this.setIsFirstCycleAttribution(isFirstCycleAttribution);
        this.setIsHandicappedContingent(isHandicappedContingent);
        this.setIsInternal2ndCycleAccess(isInternal2ndCycleAccess);
        this.setIsInternal3rdCycleAccess(isInternal3rdCycleAccess);
        this.setIsInternalDegreeChange(isInternalDegreeChange);
        this.setIsIsolatedCurricularUnits(isIsolatedCurricularUnits);
        this.setIsMiddleAndSuperiorCourses(isMiddleAndSuperiorCourses);
        this.setIsOver23(isOver23);
        this.setIsReIngression(isReIngression);
        this.setIsTransfer(isTransfer);
    }
}

