/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.AcademicEvent_Base;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.accounting.events.AcademicEventExemption;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;

public abstract class AcademicEvent
extends AcademicEvent_Base {
    protected void init(AdministrativeOffice administrativeOffice, EventType eventType, Person person) {
        this.init(eventType, person);
        super.setAdministrativeOffice(administrativeOffice);
    }

    public void setAdministrativeOffice(AdministrativeOffice administrativeOffice) {
        throw new DomainException("error.accounting.Event.cannot.modify.administrativeOffice", new String[0]);
    }

    public boolean isPayableOnAdministrativeOffice(AdministrativeOffice administrativeOffice) {
        return this.getAdministrativeOffice() == null || this.getAdministrativeOffice() == administrativeOffice;
    }

    protected void disconnect() {
        super.setAdministrativeOffice(null);
        super.disconnect();
    }

    public boolean hasAcademicEventExemption() {
        return this.getAcademicEventExemption() != null;
    }

    public AcademicEventExemption getAcademicEventExemption() {
        for (Exemption exemption : this.getExemptionsSet()) {
            if (!(exemption instanceof AcademicEventExemption)) continue;
            return (AcademicEventExemption)((Object)exemption);
        }
        return null;
    }

    public Unit getOwnerUnit() {
        return this.getAdministrativeOffice().getUnit();
    }
}

