/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.coordinator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.phd.ManageEnrolmentsBean;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.SearchPhdIndividualProgramProcessBean;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyReferee;
import org.fenixedu.academic.domain.phd.email.PhdProgramEmail;
import org.fenixedu.academic.domain.phd.email.PhdProgramEmailBean;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AcceptEnrolments;
import org.fenixedu.academic.domain.phd.individualProcess.activities.RejectEnrolments;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.service.services.caseHandling.ExecuteProcessActivity;
import org.fenixedu.academic.ui.struts.FenixActionForm;
import org.fenixedu.academic.ui.struts.action.coordinator.CoordinatorApplication;
import org.fenixedu.academic.ui.struts.action.phd.CommonPhdIndividualProgramProcessDA;
import org.fenixedu.academic.ui.struts.action.phd.PhdCandidacyPredicateContainer;
import org.fenixedu.academic.ui.struts.action.phd.PhdInactivePredicateContainer;
import org.fenixedu.academic.ui.struts.action.phd.PhdSeminarPredicateContainer;
import org.fenixedu.academic.ui.struts.action.phd.PhdThesisPredicateContainer;
import org.fenixedu.academic.util.predicates.PredicateContainer;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=CoordinatorApplication.CoordinatorPhdApp.class, path="phd-processes", titleKey="label.coordinator.phdProcesses", bundle="ApplicationResources")
@Mapping(path="/phdIndividualProgramProcess", module="coordinator", formBeanClass=PhdEmailProgramForm.class)
@Forwards(value={@Forward(name="manageProcesses", path="/phd/coordinator/manageProcesses.jsp"), @Forward(name="viewProcess", path="/phd/coordinator/viewProcess.jsp"), @Forward(name="viewInactiveProcesses", path="/phd/coordinator/viewInactiveProcesses.jsp"), @Forward(name="searchResults", path="/phd/coordinator/searchResults.jsp"), @Forward(name="viewAlertMessages", path="/phd/coordinator/viewAlertMessages.jsp"), @Forward(name="viewAlertMessageArchive", path="/phd/coordinator/viewAlertMessageArchive.jsp"), @Forward(name="viewAlertMessage", path="/phd/coordinator/viewAlertMessage.jsp"), @Forward(name="viewProcessAlertMessages", path="/phd/coordinator/viewProcessAlertMessages.jsp"), @Forward(name="viewProcessAlertMessageArchive", path="/phd/coordinator/viewProcessAlertMessageArchive.jsp"), @Forward(name="viewCurriculum", path="/phd/coordinator/viewCurriculum.jsp"), @Forward(name="manageEnrolments", path="/phd/coordinator/enrolments/manageEnrolments.jsp"), @Forward(name="validateEnrolments", path="/phd/coordinator/enrolments/validateEnrolments.jsp"), @Forward(name="manageGuidanceDocuments", path="/phd/coordinator/manageGuidanceDocuments.jsp"), @Forward(name="uploadGuidanceDocument", path="/phd/coordinator/uploadGuidanceDocument.jsp"), @Forward(name="managePhdEmails", path="/phd/coordinator/email/managePhdEmails.jsp"), @Forward(name="choosePhdEmailRecipients", path="/phd/coordinator/email/choosePhdEmailRecipients.jsp"), @Forward(name="prepareSendPhdEmail", path="/phd/coordinator/email/prepareSendPhdEmail.jsp"), @Forward(name="confirmSendPhdEmail", path="/phd/coordinator/email/confirmSendPhdEmail.jsp"), @Forward(name="viewPhdEmail", path="/phd/coordinator/email/viewPhdEmail.jsp"), @Forward(name="viewRefereeLetters", path="/phd/coordinator/referee/viewRefereeLetters.jsp"), @Forward(name="viewLetter", path="/phd/coordinator/referee/viewLetter.jsp")})
public class PhdIndividualProgramProcessDA
extends CommonPhdIndividualProgramProcessDA {
    private static final PredicateContainer<?>[] CANDIDACY_CATEGORY = new PredicateContainer[]{PhdCandidacyPredicateContainer.DELIVERED, PhdCandidacyPredicateContainer.PENDING, PhdCandidacyPredicateContainer.APPROVED, PhdCandidacyPredicateContainer.CONCLUDED};
    private static final PredicateContainer<?>[] SEMINAR_CATEGORY = new PredicateContainer[]{PhdSeminarPredicateContainer.SEMINAR_PROCESS_STARTED, PhdSeminarPredicateContainer.AFTER_FIRST_SEMINAR_REUNION};
    private static final PredicateContainer<?>[] THESIS_CATEGORY = new PredicateContainer[]{PhdThesisPredicateContainer.PROVISIONAL_THESIS_DELIVERED, PhdThesisPredicateContainer.DISCUSSION_SCHEDULED};

    @Override
    @EntryPoint
    public ActionForward manageProcesses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return super.manageProcesses(mapping, form, request, response);
    }

    @Override
    protected SearchPhdIndividualProgramProcessBean initializeSearchBean(HttpServletRequest request) {
        SearchPhdIndividualProgramProcessBean searchBean = new SearchPhdIndividualProgramProcessBean();
        searchBean.setPhdPrograms(this.getManagedPhdPrograms(request));
        searchBean.setFilterPhdProcesses(false);
        return searchBean;
    }

    private Set<PhdProgram> getManagedPhdPrograms(HttpServletRequest request) {
        HashSet<PhdProgram> result = new HashSet<PhdProgram>();
        ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        for (Coordinator coordinator : this.getLoggedPerson(request).getCoordinatorsSet()) {
            if (coordinator.getExecutionDegree().getDegree().getPhdProgram() == null || coordinator.getExecutionDegree().getExecutionYear() != currentExecutionYear) continue;
            result.add(coordinator.getExecutionDegree().getDegree().getPhdProgram());
        }
        return result;
    }

    @Override
    protected PhdInactivePredicateContainer getConcludedContainer() {
        return PhdInactivePredicateContainer.CONCLUDED_THIS_YEAR;
    }

    @Override
    protected List<PredicateContainer<?>> getThesisCategory() {
        return Arrays.asList(THESIS_CATEGORY);
    }

    @Override
    protected List<PredicateContainer<?>> getSeminarCategory() {
        return Arrays.asList(SEMINAR_CATEGORY);
    }

    @Override
    protected List<PredicateContainer<?>> getCandidacyCategory() {
        return Arrays.asList(CANDIDACY_CATEGORY);
    }

    public ActionForward manageEnrolments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcess process2 = this.getProcess(request);
        ManageEnrolmentsBean bean = (ManageEnrolmentsBean)this.getRenderedObject("manageEnrolmentsBean");
        if (bean == null) {
            bean = new ManageEnrolmentsBean();
            bean.setProcess(process2);
            bean.setSemester(ExecutionSemester.readActualExecutionSemester());
        }
        this.filterEnrolments(bean, process2, false);
        request.setAttribute("manageEnrolmentsBean", (Object)bean);
        return mapping.findForward("manageEnrolments");
    }

    private void filterEnrolments(ManageEnrolmentsBean bean, PhdIndividualProgramProcess process2, boolean filterByTemporary) {
        StudentCurricularPlan scp = process2.getRegistration().getLastStudentCurricularPlan();
        HashSet<Enrolment> enrolmentsPerformedByStudent = new HashSet<Enrolment>();
        HashSet<Enrolment> enrolmentsPerformedByAdminOffice = new HashSet<Enrolment>();
        for (Enrolment enrolment : scp.getEnrolmentsByExecutionPeriod(bean.getSemester())) {
            if (filterByTemporary && !enrolment.isTemporary()) continue;
            if (this.isPerformedByStudent(enrolment)) {
                enrolmentsPerformedByStudent.add(enrolment);
                continue;
            }
            enrolmentsPerformedByAdminOffice.add(enrolment);
        }
        bean.setEnrolmentsPerformedByStudent(enrolmentsPerformedByStudent);
        bean.setRemainingEnrolments(enrolmentsPerformedByAdminOffice);
    }

    private boolean isPerformedByStudent(Enrolment enrolment) {
        Person person = Person.readPersonByUsername(enrolment.getCreatedBy());
        return RoleType.STUDENT.isMember(person.getUser()) && enrolment.getStudent().equals((Object)person.getStudent());
    }

    public ActionForward prepareValidateEnrolments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcess process2 = this.getProcess(request);
        ManageEnrolmentsBean bean = (ManageEnrolmentsBean)this.getRenderedObject("manageEnrolmentsBean");
        if (bean == null) {
            bean = new ManageEnrolmentsBean();
            bean.setProcess(process2);
            this.setExecutionSemester(request, bean);
        }
        this.filterEnrolments(bean, process2, true);
        request.setAttribute("manageEnrolmentsBean", (Object)bean);
        this.setDefaultMailInformation(bean, this.getProcess(request));
        return mapping.findForward("validateEnrolments");
    }

    private void setExecutionSemester(HttpServletRequest request, ManageEnrolmentsBean bean) {
        ExecutionSemester semester = (ExecutionSemester)this.getDomainObject(request, "executionSemesterId");
        if (semester != null) {
            bean.setSemester(semester);
        } else {
            bean.setSemester(ExecutionSemester.readActualExecutionSemester());
        }
    }

    private void setDefaultMailInformation(ManageEnrolmentsBean bean, PhdIndividualProgramProcess process2) {
        bean.setMailSubject(AlertService.getSubjectPrefixed(process2, "message.phd.enrolments.validation.default.subject"));
        bean.setMailBody(AlertService.getBodyText(process2, "message.phd.enrolments.validation.default.body"));
    }

    public ActionForward acceptEnrolments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ManageEnrolmentsBean bean = (ManageEnrolmentsBean)this.getRenderedObject("manageEnrolmentsBean");
        request.setAttribute("manageEnrolmentsBean", (Object)bean);
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), AcceptEnrolments.class, (Object)bean);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            return mapping.findForward("validateEnrolments");
        }
        RenderUtils.invalidateViewState();
        return this.redirect(String.format("/phdIndividualProgramProcess.do?method=manageEnrolments&processId=%s", this.getProcess(request).getExternalId()), request);
    }

    public ActionForward rejectEnrolments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ManageEnrolmentsBean bean = (ManageEnrolmentsBean)this.getRenderedObject("manageEnrolmentsBean");
        request.setAttribute("manageEnrolmentsBean", (Object)bean);
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), RejectEnrolments.class, (Object)bean);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            return mapping.findForward("validateEnrolments");
        }
        RenderUtils.invalidateViewState();
        return this.redirect(String.format("/phdIndividualProgramProcess.do?method=manageEnrolments&processId=%s", this.getProcess(request).getExternalId()), request);
    }

    public ActionForward managePhdEmails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramEmailBean bean = new PhdProgramEmailBean();
        List<PhdProgram> coordinatedPrograms = this.getCoordinatedPhdPrograms();
        if (coordinatedPrograms.size() == 1) {
            bean.setPhdProgram(coordinatedPrograms.iterator().next());
            bean.setShowProgramsChoice(false);
        }
        request.setAttribute("phdEmailBean", (Object)bean);
        return mapping.findForward("managePhdEmails");
    }

    public ActionForward manageEmailBeanPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("phdEmailBean", this.getRenderedObject("phdEmailBean"));
        return mapping.findForward("managePhdEmails");
    }

    public ActionForward choosePhdEmailRecipients(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramEmailBean bean = (PhdProgramEmailBean)this.getRenderedObject("phdEmailBean");
        if (bean == null) {
            bean = new PhdProgramEmailBean((PhdProgram)((Object)this.getDomainObject(request, "phdProgramId")));
        } else {
            this.setSelectedIndividualProcesses((PhdEmailProgramForm)form, bean);
        }
        request.setAttribute("phdEmailBean", (Object)bean);
        request.setAttribute("candidacyCategory", this.getCandidacyCategory());
        request.setAttribute("seminarCategory", this.getSeminarCategory());
        request.setAttribute("thesisCategory", this.getThesisCategory());
        request.setAttribute("concludedThisYearContainer", (Object)this.getConcludedContainer());
        return mapping.findForward("choosePhdEmailRecipients");
    }

    public ActionForward prepareSendPhdEmail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramEmailBean bean = (PhdProgramEmailBean)this.getRenderedObject("phdEmailBean");
        List<PhdIndividualProgramProcess> selectedIndividual = this.retrieveSelectedProcesses((PhdEmailProgramForm)form);
        bean.setSelectedElements(selectedIndividual);
        request.setAttribute("phdEmailBean", (Object)bean);
        return mapping.findForward("prepareSendPhdEmail");
    }

    public ActionForward confirmSendPhdEmail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramEmailBean bean = (PhdProgramEmailBean)this.getRenderedObject("phdEmailBean");
        try {
            PhdProgramEmail.validateEmailBean(bean);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute("phdEmailBean", (Object)bean);
            return mapping.findForward("prepareSendPhdEmail");
        }
        bean.updateBean();
        request.setAttribute("phdEmailBean", this.getRenderedObject("phdEmailBean"));
        return mapping.findForward("confirmSendPhdEmail");
    }

    public ActionForward sendPhdEmail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramEmailBean bean = (PhdProgramEmailBean)this.getRenderedObject("phdEmailBean");
        PhdProgramEmail.createEmail(bean);
        RenderUtils.invalidateViewState((String)"phdEmailBean");
        request.setAttribute("phdEmailBean", (Object)new PhdProgramEmailBean());
        return mapping.findForward("managePhdEmails");
    }

    public ActionForward viewPhdEmail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramEmailBean bean = new PhdProgramEmailBean(this.getPhdEmail(request));
        request.setAttribute("phdEmailBean", (Object)bean);
        return mapping.findForward("viewPhdEmail");
    }

    private PhdProgramEmail getPhdEmail(HttpServletRequest request) {
        return (PhdProgramEmail)((Object)this.getDomainObject(request, "phdEmailId"));
    }

    private void setSelectedIndividualProcesses(PhdEmailProgramForm actionForm, PhdProgramEmailBean bean) {
        ArrayList<String> externalIdList = new ArrayList<String>();
        for (PhdIndividualProgramProcess individualProcess : bean.getSelectedElements()) {
            externalIdList.add(individualProcess.getExternalId());
        }
        actionForm.setSelectedProcesses(externalIdList.toArray(new String[0]));
    }

    private List<PhdIndividualProgramProcess> retrieveSelectedProcesses(PhdEmailProgramForm actionForm) {
        ArrayList<PhdIndividualProgramProcess> processList = new ArrayList<PhdIndividualProgramProcess>();
        if (actionForm.getSelectedProcesses() == null) {
            return processList;
        }
        for (String externalId : actionForm.getSelectedProcesses()) {
            processList.add((PhdIndividualProgramProcess)FenixFramework.getDomainObject((String)externalId));
        }
        return processList;
    }

    private List<PhdProgram> getCoordinatedPhdPrograms() {
        ArrayList<PhdProgram> programs = new ArrayList<PhdProgram>();
        for (PhdProgram program : Bennu.getInstance().getPhdProgramsSet()) {
            if (!program.isCoordinatorFor(AccessControl.getPerson(), ExecutionYear.readCurrentExecutionYear())) continue;
            programs.add(program);
        }
        return programs;
    }

    public ActionForward viewRefereeLetters(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcess process2 = this.getProcess(request);
        request.setAttribute("process", (Object)process2);
        return mapping.findForward("viewRefereeLetters");
    }

    public ActionForward viewLetter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcess process2 = this.getProcess(request);
        PhdCandidacyReferee referee = (PhdCandidacyReferee)((Object)this.getDomainObject(request, "refereeId"));
        request.setAttribute("process", (Object)process2);
        request.setAttribute("referee", (Object)referee);
        return mapping.findForward("viewLetter");
    }

    public static class PhdEmailProgramForm
    extends FenixActionForm {
        private String[] selectedProcesses;

        public String[] getSelectedProcesses() {
            return this.selectedProcesses;
        }

        public void setSelectedProcesses(String[] selectedProcesses) {
            this.selectedProcesses = selectedProcesses;
        }
    }
}

