/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.mobility.outbound;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacy;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContest;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContestGroup;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyPeriod;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyPeriodConfirmationOption;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacySubmission;
import org.fenixedu.academic.domain.util.email.EmailBean;
import org.fenixedu.academic.domain.util.email.PersonSender;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.mobility.outbound.OutboundMobilityContextBean;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.groups.UnionGroup;
import org.fenixedu.bennu.core.groups.UserGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.GenericChecksumRewriter;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminCandidaciesApp.class, path="outbound-mobility", titleKey="label.mobility.outbound", accessGroup="academic(MANAGE_MOBILITY_OUTBOUND)")
@Mapping(path="/outboundMobilityCandidacy", module="academicAdministration")
@Forwards(value={@Forward(name="prepare", path="/mobility/outbound/OutboundMobilityCandidacy.jsp"), @Forward(name="viewContest", path="/mobility/outbound/viewContest.jsp"), @Forward(name="manageCandidacies", path="/mobility/outbound/manageCandidacies.jsp"), @Forward(name="viewCandidate", path="/mobility/outbound/viewCandidate.jsp"), @Forward(name="sendEmail", path="/messaging/emails.do?method=newEmail")})
public class OutboundMobilityCandidacyDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        OutboundMobilityContextBean outboundMobilityContextBean = (OutboundMobilityContextBean)this.getRenderedObject();
        if (outboundMobilityContextBean == null) {
            outboundMobilityContextBean = new OutboundMobilityContextBean();
        }
        return this.prepare(mapping, request, outboundMobilityContextBean);
    }

    public ActionForward prepare(ActionMapping mapping, HttpServletRequest request, OutboundMobilityContextBean outboundMobilityContextBean) {
        RenderUtils.invalidateViewState();
        request.setAttribute("outboundMobilityContextBean", (Object)outboundMobilityContextBean);
        return mapping.findForward("prepare");
    }

    public ActionForward invalidadeAndPrepare(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        OutboundMobilityContextBean outboundMobilityContextBean = (OutboundMobilityContextBean)this.getRenderedObject();
        RenderUtils.invalidateViewState();
        return this.prepare(mapping, request, outboundMobilityContextBean);
    }

    public ActionForward createNewOutboundMobilityCandidacyPeriod(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        OutboundMobilityContextBean outboundMobilityContextBean = (OutboundMobilityContextBean)this.getRenderedObject();
        outboundMobilityContextBean.createNewOutboundMobilityCandidacyPeriod();
        RenderUtils.invalidateViewState();
        return this.prepare(mapping, request, outboundMobilityContextBean);
    }

    public ActionForward createNewOutboundMobilityCandidacyContest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        OutboundMobilityContextBean outboundMobilityContextBean = (OutboundMobilityContextBean)this.getRenderedObject();
        outboundMobilityContextBean.createNewOutboundMobilityCandidacyContest();
        RenderUtils.invalidateViewState();
        return this.prepare(mapping, request, outboundMobilityContextBean);
    }

    public ActionForward editCandidacyPeriod(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        OutboundMobilityCandidacyPeriod candidacyPeriod = (OutboundMobilityCandidacyPeriod)this.getRenderedObject();
        OutboundMobilityContextBean outboundMobilityContextBean = new OutboundMobilityContextBean();
        outboundMobilityContextBean.setExecutionYear((ExecutionYear)((Object)candidacyPeriod.getExecutionInterval()));
        outboundMobilityContextBean.setCandidacyPeriodsAsList(Collections.singletonList(candidacyPeriod));
        RenderUtils.invalidateViewState();
        return this.prepare(mapping, request, outboundMobilityContextBean);
    }

    public ActionForward deletePeriod(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        OutboundMobilityCandidacyPeriod candidacyPeriod = (OutboundMobilityCandidacyPeriod)this.getDomainObject(request, "candidacyPeriodOid");
        candidacyPeriod.delete();
        OutboundMobilityContextBean outboundMobilityContextBean = new OutboundMobilityContextBean();
        RenderUtils.invalidateViewState();
        return this.prepare(mapping, request, outboundMobilityContextBean);
    }

    public ActionForward addCandidateOption(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        OutboundMobilityContextBean outboundMobilityContextBean = (OutboundMobilityContextBean)this.getRenderedObject();
        outboundMobilityContextBean.addCandidateOption();
        RenderUtils.invalidateViewState();
        return this.prepare(mapping, request, outboundMobilityContextBean);
    }

    public ActionForward addDegreeToGroup(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        OutboundMobilityContextBean outboundMobilityContextBean = (OutboundMobilityContextBean)this.getRenderedObject();
        outboundMobilityContextBean.addDegreeToGroup();
        RenderUtils.invalidateViewState();
        return this.prepare(mapping, request, outboundMobilityContextBean);
    }

    public ActionForward removeDegreeFromGroup(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        OutboundMobilityContextBean outboundMobilityContextBean = (OutboundMobilityContextBean)this.getRenderedObject();
        ExecutionDegree executionDegree = (ExecutionDegree)this.getDomainObject(request, "executionDegreeOid");
        outboundMobilityContextBean.setExecutionDegree(executionDegree);
        outboundMobilityContextBean.removeDegreeFromGroup();
        RenderUtils.invalidateViewState();
        return this.prepare(mapping, request, outboundMobilityContextBean);
    }

    public ActionForward deleteContest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        OutboundMobilityContextBean outboundMobilityContextBean = (OutboundMobilityContextBean)this.getRenderedObject();
        OutboundMobilityCandidacyContest contest = (OutboundMobilityCandidacyContest)this.getDomainObject(request, "contestOid");
        if (contest != null) {
            try {
                OutboundMobilityCandidacyContestGroup mobilityGroup = contest.getOutboundMobilityCandidacyContestGroup();
                if (mobilityGroup.getOutboundMobilityCandidacyContestSet().size() == 1) {
                    outboundMobilityContextBean.getMobilityGroups().remove(mobilityGroup);
                }
                contest.delete();
            }
            catch (Exception e) {
                this.addErrorMessage(request, "errors", e.getMessage(), new Object[0]);
            }
        }
        RenderUtils.invalidateViewState();
        return this.prepare(mapping, request, outboundMobilityContextBean);
    }

    public ActionForward viewContest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        OutboundMobilityCandidacyContest contest = (OutboundMobilityCandidacyContest)this.getDomainObject(request, "contestOid");
        request.setAttribute("contest", (Object)contest);
        return mapping.findForward("viewContest");
    }

    public ActionForward viewContestForm(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        OutboundMobilityCandidacyContest contest = (OutboundMobilityCandidacyContest)this.getDomainObject(request, "contestOid");
        request.setAttribute("contest", (Object)contest);
        return new ActionForward(this.viewContestPath(mapping, request, contest), true);
    }

    private String viewContestPath(ActionMapping mapping, HttpServletRequest request, OutboundMobilityCandidacyContest contest) {
        StringBuilder path = new StringBuilder();
        path.append(mapping.getModuleConfig().getPrefix());
        path.append("/outboundMobilityCandidacy.do?method=viewContest&contestOid=");
        path.append(contest.getExternalId());
        return this.constructRedirectPath(mapping, request, path);
    }

    private String constructRedirectPath(ActionMapping mapping, HttpServletRequest request, StringBuilder path) {
        String result = GenericChecksumRewriter.injectChecksumInUrl((String)request.getContextPath(), (String)path.toString(), (HttpSession)request.getSession());
        return result.substring(mapping.getModuleConfig().getPrefix().length());
    }

    public ActionForward removeMobilityCoordinator(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        OutboundMobilityContextBean outboundMobilityContextBean = (OutboundMobilityContextBean)this.getRenderedObject();
        OutboundMobilityCandidacyContestGroup mobilityGroup = (OutboundMobilityCandidacyContestGroup)this.getDomainObject(request, "mobilityGroupOid");
        Person person = (Person)((Object)this.getDomainObject(request, "personOid"));
        mobilityGroup.removeMobilityCoordinatorService(person);
        RenderUtils.invalidateViewState();
        return this.prepare(mapping, request, outboundMobilityContextBean);
    }

    public ActionForward addMobilityCoordinator(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        OutboundMobilityContextBean outboundMobilityContextBean = (OutboundMobilityContextBean)this.getRenderedObject();
        outboundMobilityContextBean.addMobilityCoordinator();
        RenderUtils.invalidateViewState();
        return this.prepare(mapping, request, outboundMobilityContextBean);
    }

    public ActionForward manageCandidacies(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        OutboundMobilityContextBean outboundMobilityContextBean = (OutboundMobilityContextBean)this.getRenderedObject();
        if (outboundMobilityContextBean.getMobilityGroups().size() == 0) {
            return this.prepare(mapping, request, outboundMobilityContextBean);
        }
        request.setAttribute("outboundMobilityContextBean", (Object)outboundMobilityContextBean);
        return mapping.findForward("manageCandidacies");
    }

    public ActionForward editGrade(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        OutboundMobilityCandidacySubmission submission = (OutboundMobilityCandidacySubmission)this.getDomainObject(request, "candidacySubmissionOid");
        OutboundMobilityCandidacyContestGroup mobilityGroup = (OutboundMobilityCandidacyContestGroup)this.getDomainObject(request, "mobilityGroupOid");
        String grade = (String)this.getFromRequest(request, "grade");
        submission.setGrade(mobilityGroup, new BigDecimal(grade));
        return null;
    }

    public ActionForward editVacancies(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        OutboundMobilityCandidacyContest contest = (OutboundMobilityCandidacyContest)this.getDomainObject(request, "contestOid");
        String vacancies = (String)this.getFromRequest(request, "vacancies");
        contest.editVacancies(vacancies == null || vacancies.isEmpty() ? null : new Integer(vacancies));
        return null;
    }

    public ActionForward viewCandidate(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ExecutionYear executionYear;
        OutboundMobilityContextBean outboundMobilityContextBean = new OutboundMobilityContextBean();
        Person person = (Person)((Object)this.getDomainObject(request, "personOid"));
        if (person != null) {
            outboundMobilityContextBean.setPerson(person);
        }
        if ((executionYear = (ExecutionYear)this.getDomainObject(request, "executionYearOid")) != null) {
            outboundMobilityContextBean.setExecutionYear(executionYear);
        }
        RenderUtils.invalidateViewState();
        request.setAttribute("outboundMobilityContextBean", (Object)outboundMobilityContextBean);
        return mapping.findForward("viewCandidate");
    }

    public ActionForward selectCandite(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        OutboundMobilityCandidacy candidacy = (OutboundMobilityCandidacy)this.getDomainObject(request, "candidacyOid");
        candidacy.select();
        OutboundMobilityContextBean outboundMobilityContextBean = new OutboundMobilityContextBean();
        outboundMobilityContextBean.setPerson(candidacy.getOutboundMobilityCandidacySubmission().getRegistration().getPerson());
        RenderUtils.invalidateViewState();
        request.setAttribute("outboundMobilityContextBean", (Object)outboundMobilityContextBean);
        return mapping.findForward("viewCandidate");
    }

    public ActionForward unselectCandite(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        OutboundMobilityCandidacy candidacy = (OutboundMobilityCandidacy)this.getDomainObject(request, "candidacyOid");
        candidacy.unselect();
        OutboundMobilityContextBean outboundMobilityContextBean = new OutboundMobilityContextBean();
        outboundMobilityContextBean.setPerson(candidacy.getOutboundMobilityCandidacySubmission().getRegistration().getPerson());
        RenderUtils.invalidateViewState();
        request.setAttribute("outboundMobilityContextBean", (Object)outboundMobilityContextBean);
        return mapping.findForward("viewCandidate");
    }

    public ActionForward downloadCandidatesInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        OutboundMobilityCandidacyPeriod period = (OutboundMobilityCandidacyPeriod)this.getDomainObject(request, "candidacyPeriodOid");
        OutboundMobilityCandidacyContestGroup mobilityGroup = (OutboundMobilityCandidacyContestGroup)this.getDomainObject(request, "mobilityGroupOid");
        String filename = BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.mobility.candidates.information.filename", (String[])new String[0]);
        response.setHeader("Content-disposition", "attachment; filename=" + filename + ".xls");
        response.setContentType("application/vnd.ms-excel");
        ServletOutputStream outputStream = response.getOutputStream();
        Spreadsheet spreadsheet = mobilityGroup.getCandidatesInformationSpreadSheet(period);
        spreadsheet.exportToXLSSheet((OutputStream)outputStream);
        outputStream.close();
        return null;
    }

    public ActionForward downloadSelectedCandidates(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        OutboundMobilityCandidacyPeriod period = (OutboundMobilityCandidacyPeriod)this.getDomainObject(request, "candidacyPeriodOid");
        String filename = BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.mobility.outbound.period.export.selected.candiadates.filename", (String[])new String[0]);
        response.setHeader("Content-disposition", "attachment; filename=" + filename + ".xls");
        response.setContentType("application/vnd.ms-excel");
        ServletOutputStream outputStream = response.getOutputStream();
        Spreadsheet spreadsheet = period.getSelectedCandidateSpreadSheet(period);
        spreadsheet.exportToXLSSheet((OutputStream)outputStream);
        outputStream.close();
        return null;
    }

    public ActionForward uploadClassifications(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        OutboundMobilityContextBean outboundMobilityContextBean = (OutboundMobilityContextBean)this.getRenderedObject();
        try {
            outboundMobilityContextBean.uploadClassifications();
            this.addActionMessage("success", request, "message.outbound.upload.success");
        }
        catch (DomainException ex) {
            this.addActionMessage("error", request, ex.getMessage(), ex.getArgs());
        }
        RenderUtils.invalidateViewState();
        request.setAttribute("outboundMobilityContextBean", (Object)outboundMobilityContextBean);
        return mapping.findForward("manageCandidacies");
    }

    public ActionForward selectCandidates(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        OutboundMobilityCandidacyPeriod period = (OutboundMobilityCandidacyPeriod)this.getDomainObject(request, "candidacyPeriodOid");
        OutboundMobilityCandidacyContestGroup mobilityGroup = (OutboundMobilityCandidacyContestGroup)this.getDomainObject(request, "mobilityGroupOid");
        mobilityGroup.selectCandidates(period);
        OutboundMobilityContextBean outboundMobilityContextBean = new OutboundMobilityContextBean();
        outboundMobilityContextBean.setCandidacyPeriodsAsList(Collections.singletonList(period));
        outboundMobilityContextBean.setMobilityGroupsAsList(Collections.singletonList(mobilityGroup));
        request.setAttribute("outboundMobilityContextBean", (Object)outboundMobilityContextBean);
        return mapping.findForward("manageCandidacies");
    }

    public ActionForward selectCandidatesForAllGroups(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        OutboundMobilityCandidacyPeriod period = (OutboundMobilityCandidacyPeriod)this.getDomainObject(request, "candidacyPeriodOid");
        try {
            String result = period.selectCandidatesForAllGroups();
            request.setAttribute("result", (Object)result);
        }
        catch (DomainException ex) {
            String error = ex.getKey();
            request.setAttribute("error", (Object)error);
        }
        OutboundMobilityContextBean outboundMobilityContextBean = new OutboundMobilityContextBean();
        outboundMobilityContextBean.setCandidacyPeriodsAsList(Collections.singletonList(period));
        request.setAttribute("outboundMobilityContextBean", (Object)outboundMobilityContextBean);
        return mapping.findForward("prepare");
    }

    public ActionForward concludeCandidateSelection(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        OutboundMobilityCandidacyPeriod period = (OutboundMobilityCandidacyPeriod)this.getDomainObject(request, "candidacyPeriodOid");
        OutboundMobilityCandidacyContestGroup mobilityGroup = (OutboundMobilityCandidacyContestGroup)this.getDomainObject(request, "mobilityGroupOid");
        mobilityGroup.concludeCandidateSelection(period);
        OutboundMobilityContextBean outboundMobilityContextBean = new OutboundMobilityContextBean();
        outboundMobilityContextBean.setCandidacyPeriodsAsList(Collections.singletonList(period));
        outboundMobilityContextBean.setMobilityGroupsAsList(Collections.singletonList(mobilityGroup));
        request.setAttribute("outboundMobilityContextBean", (Object)outboundMobilityContextBean);
        return mapping.findForward("manageCandidacies");
    }

    public ActionForward revertConcludeCandidateSelection(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        OutboundMobilityCandidacyPeriod period = (OutboundMobilityCandidacyPeriod)this.getDomainObject(request, "candidacyPeriodOid");
        OutboundMobilityCandidacyContestGroup mobilityGroup = (OutboundMobilityCandidacyContestGroup)this.getDomainObject(request, "mobilityGroupOid");
        mobilityGroup.revertConcludeCandidateSelection(period);
        OutboundMobilityContextBean outboundMobilityContextBean = new OutboundMobilityContextBean();
        outboundMobilityContextBean.setCandidacyPeriodsAsList(Collections.singletonList(period));
        outboundMobilityContextBean.setMobilityGroupsAsList(Collections.singletonList(mobilityGroup));
        request.setAttribute("outboundMobilityContextBean", (Object)outboundMobilityContextBean);
        return mapping.findForward("manageCandidacies");
    }

    public ActionForward concludeCandidateNotification(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        OutboundMobilityCandidacyPeriod period = (OutboundMobilityCandidacyPeriod)this.getDomainObject(request, "candidacyPeriodOid");
        OutboundMobilityCandidacyContestGroup mobilityGroup = (OutboundMobilityCandidacyContestGroup)this.getDomainObject(request, "mobilityGroupOid");
        mobilityGroup.concludeCandidateNotification(period);
        OutboundMobilityContextBean outboundMobilityContextBean = new OutboundMobilityContextBean();
        outboundMobilityContextBean.setCandidacyPeriodsAsList(Collections.singletonList(period));
        outboundMobilityContextBean.setMobilityGroupsAsList(Collections.singletonList(mobilityGroup));
        request.setAttribute("outboundMobilityContextBean", (Object)outboundMobilityContextBean);
        return mapping.findForward("manageCandidacies");
    }

    public ActionForward revertConcludeCandidateNotification(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        OutboundMobilityCandidacyPeriod period = (OutboundMobilityCandidacyPeriod)this.getDomainObject(request, "candidacyPeriodOid");
        OutboundMobilityCandidacyContestGroup mobilityGroup = (OutboundMobilityCandidacyContestGroup)this.getDomainObject(request, "mobilityGroupOid");
        mobilityGroup.revertConcludeCandidateNotification(period);
        OutboundMobilityContextBean outboundMobilityContextBean = new OutboundMobilityContextBean();
        outboundMobilityContextBean.setCandidacyPeriodsAsList(Collections.singletonList(period));
        outboundMobilityContextBean.setMobilityGroupsAsList(Collections.singletonList(mobilityGroup));
        request.setAttribute("outboundMobilityContextBean", (Object)outboundMobilityContextBean);
        return mapping.findForward("manageCandidacies");
    }

    public ActionForward sendEmailToCandidates(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PersonSender sender;
        OutboundMobilityCandidacyPeriod period = (OutboundMobilityCandidacyPeriod)this.getDomainObject(request, "candidacyPeriodOid");
        OutboundMobilityCandidacyContestGroup mobilityGroup = (OutboundMobilityCandidacyContestGroup)this.getDomainObject(request, "mobilityGroupOid");
        String toGroupName = BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.send.email.to.candidates.group.to.name", (String[])new String[]{mobilityGroup.getDescription(), period.getExecutionInterval().getName()});
        Group group = UnionGroup.of(this.getCandidateGroups(mobilityGroup, period));
        Recipient recipient = Recipient.newInstance(toGroupName, group);
        EmailBean bean = new EmailBean();
        bean.setRecipients(Collections.singletonList(recipient));
        Person person = AccessControl.getPerson();
        if (person != null && (sender = person.getSender()) != null) {
            bean.setSender((Sender)((Object)sender));
        }
        request.setAttribute("emailBean", (Object)bean);
        return mapping.findForward("sendEmail");
    }

    private Set<Group> getCandidateGroups(OutboundMobilityCandidacyContestGroup mobilityGroup, OutboundMobilityCandidacyPeriod period) {
        HashSet<Group> groups = new HashSet<Group>();
        for (OutboundMobilityCandidacySubmission submission : period.getOutboundMobilityCandidacySubmissionSet()) {
            if (!submission.hasContestInGroup(mobilityGroup)) continue;
            groups.add(UserGroup.of((User[])new User[]{submission.getRegistration().getPerson().getUser()}));
        }
        return groups;
    }

    public ActionForward deleteOption(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        OutboundMobilityCandidacyPeriod period = (OutboundMobilityCandidacyPeriod)this.getDomainObject(request, "candidacyPeriodOid");
        OutboundMobilityCandidacyPeriodConfirmationOption option = (OutboundMobilityCandidacyPeriodConfirmationOption)this.getDomainObject(request, "optionOid");
        if (option != null) {
            option.delete();
        }
        OutboundMobilityContextBean outboundMobilityContextBean = new OutboundMobilityContextBean();
        outboundMobilityContextBean.setCandidacyPeriodsAsList(Collections.singletonList(period));
        return this.prepare(mapping, request, outboundMobilityContextBean);
    }
}

