/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.coordinator.xviews;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.coordinator.DegreeCoordinatorIndex;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/analytics", module="coordinator", functionality=DegreeCoordinatorIndex.class)
@Forwards(value={@Forward(name="showHome", path="/coordinator/analytics/home.jsp")})
public class ExecutionYearViewDA
extends FenixDispatchAction {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DegreeCoordinatorIndex.setCoordinatorContext(request);
        return super.execute(mapping, actionForm, request, response);
    }

    private JsonArray computeExecutionYearsForDegreeCurricularPlan(DegreeCurricularPlan degreeCurricularPlan) {
        JsonArray executionYears = new JsonArray();
        for (ExecutionYear year : Bennu.getInstance().getExecutionYearsSet()) {
            if (!year.isInclusivelyBetween(degreeCurricularPlan.getInauguralExecutionYear(), degreeCurricularPlan.getLastExecutionYear())) continue;
            executionYears.add((JsonElement)this.executionYearToJson(year));
        }
        return executionYears;
    }

    private JsonObject executionYearToJson(ExecutionYear year) {
        JsonObject executionYearJson = new JsonObject();
        executionYearJson.addProperty("id", year.getExternalId());
        executionYearJson.addProperty("name", year.getQualifiedName());
        return executionYearJson;
    }

    public ActionForward showHome(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        User userView = Authenticate.getUser();
        String degreeCurricularPlanID = request.getParameter("degreeCurricularPlanID");
        DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlanID);
        JsonArray executionYears = this.computeExecutionYearsForDegreeCurricularPlan(degreeCurricularPlan);
        request.setAttribute("executionYears", (Object)executionYears);
        String executionYearId = request.getParameter("executionYear");
        ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        if (executionYearId != null) {
            currentExecutionYear = (ExecutionYear)FenixFramework.getDomainObject((String)executionYearId);
        }
        request.setAttribute("degreeCurricularPlanID", (Object)degreeCurricularPlanID);
        request.setAttribute("currentExecutionYear", (Object)this.computeExecutionYearStatistics(degreeCurricularPlan, currentExecutionYear));
        return mapping.findForward("showHome");
    }

    private Set<Enrolment> getDegreeCurricularPlanEnrolmentsForExecutionYear(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear) {
        HashSet<Enrolment> enrolments = new HashSet<Enrolment>();
        for (StudentCurricularPlan scp : degreeCurricularPlan.getStudentCurricularPlansSet()) {
            for (Enrolment enrol2 : scp.getEnrolmentsSet()) {
                if (enrol2.getExecutionPeriod().getExecutionYear() != executionYear || enrol2.getParentCycleCurriculumGroup() == null || degreeCurricularPlan.getCycleCourseGroup(enrol2.getParentCycleCurriculumGroup().getCycleType()) == null) continue;
                enrolments.add(enrol2);
            }
        }
        return enrolments;
    }

    private JsonObject computeExecutionYearStatistics(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear) {
        JsonObject result = new JsonObject();
        result.addProperty("id", executionYear.getExternalId());
        result.addProperty("name", executionYear.getQualifiedName());
        HashMap<CurricularYear, CurricularYearGradeEntry> curricularYearGradeMap = new HashMap<CurricularYear, CurricularYearGradeEntry>();
        HashMap<CurricularCourse, CurricularCourseGradeEntry> curricularCourseGradeMap = new HashMap<CurricularCourse, CurricularCourseGradeEntry>();
        for (Enrolment enrolment : this.getDegreeCurricularPlanEnrolmentsForExecutionYear(degreeCurricularPlan, executionYear)) {
            this.updateCurricularYearGradeMapIfRelevant(curricularYearGradeMap, enrolment);
            this.updateCurricularCourseGradeMapIfRelevant(curricularCourseGradeMap, enrolment);
        }
        int degreeCurricularPlanAttending = 0;
        int degreeCurricularPlanApproved = 0;
        int degreeCurricularPlanNotEvaluated = 0;
        int degreeCurricularPlanFlunked = 0;
        JsonArray curricularYearsJsonArray = new JsonArray();
        for (Map.Entry entry : curricularYearGradeMap.entrySet()) {
            JsonObject curricularYearJsonObject = new JsonObject();
            curricularYearJsonObject.addProperty("year", (Number)((CurricularYear)entry.getKey()).getYear());
            curricularYearJsonObject.addProperty("average", (Number)((CurricularYearGradeEntry)entry.getValue()).getAverage());
            curricularYearJsonObject.addProperty("total", (Number)((CurricularYearGradeEntry)entry.getValue()).getTotal());
            int curricularYearApproved = ((CurricularYearGradeEntry)entry.getValue()).approved;
            degreeCurricularPlanApproved += curricularYearApproved;
            int curricularYearFlunked = ((CurricularYearGradeEntry)entry.getValue()).flunked;
            degreeCurricularPlanFlunked += curricularYearFlunked;
            int curricularYearNotEvaluated = ((CurricularYearGradeEntry)entry.getValue()).notEvaluated;
            degreeCurricularPlanNotEvaluated += curricularYearNotEvaluated;
            int curricularYearAttending = ((CurricularYearGradeEntry)entry.getValue()).attending;
            degreeCurricularPlanAttending += curricularYearAttending;
            curricularYearJsonObject.addProperty("approved", (Number)curricularYearApproved);
            curricularYearJsonObject.addProperty("flunked", (Number)curricularYearFlunked);
            curricularYearJsonObject.addProperty("not-evaluated", (Number)curricularYearNotEvaluated);
            curricularYearJsonObject.addProperty("attending", (Number)curricularYearAttending);
            curricularYearsJsonArray.add((JsonElement)curricularYearJsonObject);
        }
        result.addProperty("attending", (Number)degreeCurricularPlanAttending);
        result.addProperty("approved", (Number)degreeCurricularPlanApproved);
        result.addProperty("notEvaluated", (Number)degreeCurricularPlanNotEvaluated);
        result.addProperty("flunked", (Number)degreeCurricularPlanFlunked);
        result.addProperty("total", (Number)(degreeCurricularPlanAttending + degreeCurricularPlanApproved + degreeCurricularPlanNotEvaluated + degreeCurricularPlanFlunked));
        JsonArray curricularCoursesJsonArray = new JsonArray();
        int years = degreeCurricularPlan.getDurationInYears();
        for (int i = 1; i <= years; ++i) {
            JsonObject year = new JsonObject();
            year.addProperty("year", (Number)i);
            JsonArray curricularCoursesArray = new JsonArray();
            for (CurricularCourse curricularCourse : degreeCurricularPlan.getCurricularCoursesByExecutionYearAndCurricularYear(executionYear, i)) {
                if (!curricularCourseGradeMap.containsKey((Object)curricularCourse)) continue;
                CurricularCourseGradeEntry entry = (CurricularCourseGradeEntry)curricularCourseGradeMap.get((Object)curricularCourse);
                JsonObject curricularCourseJsonObject = new JsonObject();
                int curricularCourseApproved = entry.approved;
                int curricularCourseFlunked = entry.flunked;
                int curricularCourseNotEvaluated = entry.notEvaluated;
                int curricularCourseAttending = entry.attending;
                curricularCourseJsonObject.addProperty("acronym", curricularCourse.getAcronym());
                curricularCourseJsonObject.addProperty("name", curricularCourse.getName());
                curricularCourseJsonObject.addProperty("approved", (Number)curricularCourseApproved);
                curricularCourseJsonObject.addProperty("flunked", (Number)curricularCourseFlunked);
                curricularCourseJsonObject.addProperty("not-evaluated", (Number)curricularCourseNotEvaluated);
                curricularCourseJsonObject.addProperty("attending", (Number)curricularCourseAttending);
                curricularCourseJsonObject.addProperty("average", (Number)entry.getAverage());
                curricularCourseJsonObject.addProperty("total", (Number)entry.getTotal());
                JsonArray gradesArray = new JsonArray();
                for (Enrolment enrolment : entry.enrolmentList) {
                    Grade grade = enrolment.getGrade();
                    JsonObject enrolmentJson = new JsonObject();
                    if (grade != null && grade.isApproved()) {
                        enrolmentJson.addProperty("grade", (Number)grade.getIntegerValue());
                    } else if (grade.isNotEvaluated()) {
                        enrolmentJson.addProperty("grade", "NA");
                    } else if (grade.isNotApproved()) {
                        enrolmentJson.addProperty("grade", "RE");
                    }
                    gradesArray.add((JsonElement)enrolmentJson);
                }
                curricularCourseJsonObject.add("grades", (JsonElement)gradesArray);
                curricularCoursesArray.add((JsonElement)curricularCourseJsonObject);
            }
            year.add("entries", (JsonElement)curricularCoursesArray);
            curricularCoursesJsonArray.add((JsonElement)year);
        }
        result.add("curricular-years", (JsonElement)curricularYearsJsonArray);
        result.add("curricular-courses", (JsonElement)curricularCoursesJsonArray);
        return result;
    }

    private void updateCurricularYearGradeMapIfRelevant(Map<CurricularYear, CurricularYearGradeEntry> map, Enrolment enrolment) {
        CurricularYear year = CurricularYear.readByYear(enrolment.getRegistration().getCurricularYear());
        if (map.containsKey(year)) {
            map.get(year).plus(enrolment);
        } else {
            map.put(year, new CurricularYearGradeEntry(enrolment));
        }
    }

    private void updateCurricularCourseGradeMapIfRelevant(Map<CurricularCourse, CurricularCourseGradeEntry> map, Enrolment enrolment) {
        CurricularCourse curricularCourse = enrolment.getCurricularCourse();
        if (map.containsKey((Object)curricularCourse)) {
            map.get((Object)curricularCourse).plus(enrolment);
        } else {
            map.put(curricularCourse, new CurricularCourseGradeEntry(enrolment));
        }
    }

    private static class CurricularYearGradeEntry {
        BigDecimal sum = BigDecimal.ZERO;
        Integer notEvaluated = 0;
        Integer approved = 0;
        Integer flunked = 0;
        Integer attending = 0;
        Integer quantity = 0;

        public CurricularYearGradeEntry(Enrolment enrolment) {
            this.plus(enrolment);
        }

        public CurricularYearGradeEntry plus(Enrolment enrolment) {
            Grade grade = enrolment.getGrade();
            if (grade == null || grade.isEmpty()) {
                Integer n = this.attending;
                Integer n2 = this.attending = Integer.valueOf(this.attending + 1);
            } else if (grade.isApproved()) {
                Integer n = this.approved;
                Integer n3 = this.approved = Integer.valueOf(this.approved + 1);
                if (grade.getGradeScale() == GradeScale.TYPE20) {
                    this.sum = this.sum.add(grade.getNumericValue());
                    n = this.quantity;
                    n3 = this.quantity = Integer.valueOf(this.quantity + 1);
                }
            } else if (grade.isNotEvaluated()) {
                Integer n = this.notEvaluated;
                Integer n4 = this.notEvaluated = Integer.valueOf(this.notEvaluated + 1);
            } else if (grade.isNotApproved()) {
                Integer n = this.flunked;
                Integer n5 = this.flunked = Integer.valueOf(this.flunked + 1);
            }
            return this;
        }

        public BigDecimal getAverage() {
            if (this.quantity > 0) {
                return this.sum.divide(new BigDecimal(this.quantity), RoundingMode.HALF_EVEN);
            }
            return BigDecimal.ZERO;
        }

        public int getTotal() {
            return this.notEvaluated + this.approved + this.flunked + this.attending;
        }
    }

    private static class CurricularCourseGradeEntry {
        BigDecimal sum = BigDecimal.ZERO;
        Integer notEvaluated = 0;
        Integer approved = 0;
        Integer flunked = 0;
        Integer attending = 0;
        List<Enrolment> enrolmentList = new ArrayList<Enrolment>();
        Integer quantity = 0;

        public CurricularCourseGradeEntry(Enrolment enrolment) {
            this.plus(enrolment);
        }

        public CurricularCourseGradeEntry plus(Enrolment enrolment) {
            this.enrolmentList.add(enrolment);
            Grade grade = enrolment.getGrade();
            if (grade == null || grade.isEmpty()) {
                Integer n = this.attending;
                Integer n2 = this.attending = Integer.valueOf(this.attending + 1);
            } else if (grade.isApproved()) {
                Integer n = this.approved;
                Integer n3 = this.approved = Integer.valueOf(this.approved + 1);
                if (grade.getGradeScale() == GradeScale.TYPE20) {
                    this.sum = this.sum.add(grade.getNumericValue());
                    n = this.quantity;
                    n3 = this.quantity = Integer.valueOf(this.quantity + 1);
                }
            } else if (grade.isNotEvaluated()) {
                Integer n = this.notEvaluated;
                Integer n4 = this.notEvaluated = Integer.valueOf(this.notEvaluated + 1);
            } else if (grade.isNotApproved()) {
                Integer n = this.flunked;
                Integer n5 = this.flunked = Integer.valueOf(this.flunked + 1);
            }
            return this;
        }

        public BigDecimal getAverage() {
            if (this.quantity > 0) {
                return this.sum.divide(new BigDecimal(this.quantity), RoundingMode.HALF_EVEN);
            }
            return BigDecimal.ZERO;
        }

        public int getTotal() {
            return this.notEvaluated + this.approved + this.flunked + this.attending;
        }
    }
}

