/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.coordinator;

import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.ScientificCommission;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.VariantBean;
import org.fenixedu.academic.dto.administrativeOffice.ExecutionDegreeBean;
import org.fenixedu.academic.service.services.coordinator.AddScientificCommission;
import org.fenixedu.academic.service.services.coordinator.DeleteScientificCommission;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.coordinator.DegreeCoordinatorIndex;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@Mapping(module="coordinator", path="/scientificCommissionTeamDA", functionality=DegreeCoordinatorIndex.class)
@Forwards(value={@Forward(name="viewScientificCommission", path="/coordinator/scientificCommission/manageScientificCommission.jsp")})
public class ScientificCommissionTeamDA
extends FenixDispatchAction {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DegreeCoordinatorIndex.setCoordinatorContext(request);
        request.setAttribute("degreeCurricularPlan", (Object)this.getDegreeCurricularPlan(request));
        ExecutionDegree executionDegree = this.getExecutionDegree(request);
        if (executionDegree != null) {
            request.setAttribute("executionDegree", (Object)executionDegree);
            request.setAttribute("executionDegreeId", (Object)executionDegree.getExternalId());
        } else {
            request.setAttribute("executionDegreeId", (Object)"");
        }
        return super.execute(mapping, actionForm, request, response);
    }

    private DegreeCurricularPlan getDegreeCurricularPlan(HttpServletRequest request) {
        String id = request.getParameter("degreeCurricularPlanID");
        if (id == null) {
            return null;
        }
        return (DegreeCurricularPlan)FenixFramework.getDomainObject((String)id);
    }

    private ExecutionDegree getExecutionDegree(HttpServletRequest request) {
        ExecutionDegreeBean bean = (ExecutionDegreeBean)this.getRenderedObject("executionDegreeChoice");
        if (bean != null) {
            return bean.getExecutionDegree();
        }
        String id = request.getParameter("executionDegreeID");
        if (id == null) {
            return this.getDefaultExecutionDegree(request);
        }
        return (ExecutionDegree)FenixFramework.getDomainObject((String)id);
    }

    private ExecutionDegree getDefaultExecutionDegree(HttpServletRequest request) {
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        TreeSet<ExecutionDegree> executionDegrees = new TreeSet<ExecutionDegree>(ExecutionDegree.EXECUTION_DEGREE_COMPARATORY_BY_YEAR);
        executionDegrees.addAll(degreeCurricularPlan.getExecutionDegreesSet());
        return executionDegrees.isEmpty() ? null : executionDegrees.last();
    }

    public ActionForward manage(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        ExecutionDegree executionDegree = this.getExecutionDegree(request);
        ExecutionDegreeBean bean = (ExecutionDegreeBean)this.getRenderedObject("executionDegreeChoice");
        if (bean == null) {
            bean = new ExecutionDegreeBean(degreeCurricularPlan);
            bean.setExecutionDegree(executionDegree);
        }
        request.setAttribute("executionDegree", (Object)executionDegree);
        request.setAttribute("executionDegreeBean", (Object)bean);
        request.setAttribute("usernameBean", (Object)new VariantBean());
        request.setAttribute("members", (Object)(executionDegree == null ? null : executionDegree.getScientificCommissionMembersSet()));
        if (this.isResponsible(request, executionDegree)) {
            request.setAttribute("responsible", (Object)true);
        }
        if (this.hasUpdatedContactFlag(request)) {
            request.setAttribute("updateContactConfirmation", (Object)true);
        }
        return mapping.findForward("viewScientificCommission");
    }

    private boolean hasUpdatedContactFlag(HttpServletRequest request) {
        IViewState viewState = RenderUtils.getViewState((String)"membersContacts");
        if (viewState == null) {
            return false;
        }
        if (!viewState.isValid()) {
            return false;
        }
        return !viewState.skipUpdate();
    }

    private boolean isResponsible(HttpServletRequest request, ExecutionDegree executionDegree) {
        Coordinator coordinator = executionDegree.getCoordinatorByTeacher(this.getLoggedPerson(request));
        return coordinator != null && coordinator.isResponsible();
    }

    public ActionForward addMember(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        VariantBean bean = (VariantBean)this.getRenderedObject("usernameChoice");
        if (bean != null) {
            String username = bean.getString();
            Person person = Person.readPersonByUsername(username);
            if (person == null) {
                this.addActionMessage("addError", request, "error.coordinator.scientificComission.person.doesNotExist");
            } else {
                ExecutionDegree executionDegree = this.getExecutionDegree(request);
                try {
                    AddScientificCommission.runAddScientificCommission(executionDegree.getExternalId(), person);
                    RenderUtils.invalidateViewState((String)"usernameChoice");
                }
                catch (DomainException e) {
                    this.addActionMessage("addError", request, e.getKey(), e.getArgs());
                }
            }
        }
        return this.manage(mapping, actionForm, request, response);
    }

    public ActionForward removeMember(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String memberId = request.getParameter("memberID");
        if (memberId != null) {
            ExecutionDegree executionDegree = this.getExecutionDegree(request);
            for (ScientificCommission commission : executionDegree.getScientificCommissionMembersSet()) {
                if (!commission.getExternalId().equals(memberId)) continue;
                try {
                    DeleteScientificCommission.runDeleteScientificCommission(executionDegree.getExternalId(), commission);
                }
                catch (DomainException e) {
                    this.addActionMessage("addError", request, e.getKey(), e.getArgs());
                }
            }
        }
        return this.manage(mapping, actionForm, request, response);
    }
}

