/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.commons.student;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.candidacy.Candidacy;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFile;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacy;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContest;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContestGroup;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacySubmission;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;

@Mapping(path="/viewStudentApplication", module="academicAdministration", functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="view", path="/student/application/view.jsp")})
public class ViewStudentApplicationDA
extends FenixDispatchAction {
    public ActionForward view(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Candidacy application = (Candidacy)((Object)this.getDomainObject(request, "applicationOID"));
        request.setAttribute("candidacy", (Object)application);
        return mapping.findForward("view");
    }

    public ActionForward downloadDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        IndividualCandidacyDocumentFile document = (IndividualCandidacyDocumentFile)((Object)this.getDomainObject(request, "documentOID"));
        if (document != null && this.isAuthorized(document)) {
            response.setContentType(document.getContentType());
            response.addHeader("Content-Disposition", "attachment; filename=\"" + document.getFilename() + "\"");
            response.setContentLength(document.getSize().intValue());
            DataOutputStream dos = new DataOutputStream((OutputStream)response.getOutputStream());
            dos.write(document.getContent());
            dos.close();
        } else {
            response.setStatus(400);
            response.getWriter().write(HttpStatus.getStatusText((int)400));
            response.getWriter().close();
        }
        return null;
    }

    private boolean isAuthorized(IndividualCandidacyDocumentFile document) {
        Person person;
        User user = Authenticate.getUser();
        return user != null && (RoleType.MANAGER.isMember((person = user.getPerson()).getUser()) || this.isMobilityCoordinator(document, person));
    }

    private boolean isMobilityCoordinator(IndividualCandidacyDocumentFile document, Person person) {
        for (IndividualCandidacy individualCandidacy : document.getIndividualCandidacySet()) {
            Student student;
            Registration candidacyRegistration = individualCandidacy.getRegistration();
            if (candidacyRegistration == null || (student = candidacyRegistration.getStudent()) == null) continue;
            if (student.getPerson() == person) {
                return true;
            }
            for (Registration registration : student.getRegistrationsSet()) {
                for (OutboundMobilityCandidacySubmission submission : registration.getOutboundMobilityCandidacySubmissionSet()) {
                    for (OutboundMobilityCandidacy candidacy : submission.getOutboundMobilityCandidacySet()) {
                        OutboundMobilityCandidacyContest contest = candidacy.getOutboundMobilityCandidacyContest();
                        OutboundMobilityCandidacyContestGroup group = contest.getOutboundMobilityCandidacyContestGroup();
                        for (Person coordinator : group.getMobilityCoordinatorSet()) {
                            if (coordinator != person) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }
}

