/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.commons.student;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResultMessage;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.EnrollmentDomainException;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.curriculumLine.MoveCurriculumLinesBean;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.academic.service.services.student.curriculumLines.MoveCurriculumLines;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

public abstract class AbstractCurriculumLinesLocationManagementDA
extends FenixDispatchAction {
    @EntryPoint
    private ActionForward prepare(ActionMapping mapping, HttpServletRequest request, boolean isWithRules) {
        request.setAttribute("studentCurricularPlan", (Object)this.getStudentCurricularPlan(request));
        request.setAttribute("withRules", (Object)isWithRules);
        return mapping.findForward("showCurriculum");
    }

    public ActionForward prepareWithoutRules(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.prepare(mapping, request, false);
    }

    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.prepare(mapping, request, true);
    }

    public ActionForward chooseNewDestination(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        List<CurriculumLine> selectedCurriculumLines = this.getSelectedCurriculumLines(request);
        if (selectedCurriculumLines.isEmpty()) {
            this.addActionMessage(request, "label.student.moveCurriculumLines.curriculumLines.selection.required");
            return this.prepare(mapping, request, this.isWithRules(request));
        }
        boolean withRules = this.isWithRules(request);
        MoveCurriculumLinesBean bean = MoveCurriculumLinesBean.buildFrom(selectedCurriculumLines, withRules);
        bean.setStudentCurricularPlan(this.getStudentCurricularPlan(request));
        bean.withRules(withRules);
        request.setAttribute("moveCurriculumLinesBean", (Object)bean);
        return mapping.findForward("chooseNewLocation");
    }

    protected boolean isWithRules(HttpServletRequest request) {
        return Boolean.valueOf((String)this.getFromRequest(request, "withRules"));
    }

    public ActionForward moveCurriculumLines(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        MoveCurriculumLinesBean moveCurriculumLinesBean = (MoveCurriculumLinesBean)this.getRenderedObject("move-curriculum-lines-bean");
        if (!RenderUtils.getViewState((String)"move-curriculum-lines-bean-entries").isValid()) {
            request.setAttribute("moveCurriculumLinesBean", (Object)moveCurriculumLinesBean);
            return mapping.findForward("chooseNewLocation");
        }
        try {
            MoveCurriculumLines.run(moveCurriculumLinesBean);
        }
        catch (EnrollmentDomainException e) {
            this.addRuleResultMessagesToActionMessages(request, e.getFalseResult());
            request.setAttribute("moveCurriculumLinesBean", (Object)moveCurriculumLinesBean);
            return mapping.findForward("chooseNewLocation");
        }
        catch (IllegalDataAccessException e) {
            this.addActionMessage(request, "error.NotAuthorized");
            request.setAttribute("moveCurriculumLinesBean", (Object)moveCurriculumLinesBean);
            return mapping.findForward("chooseNewLocation");
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute("moveCurriculumLinesBean", (Object)moveCurriculumLinesBean);
            return mapping.findForward("chooseNewLocation");
        }
        request.setAttribute("studentCurricularPlan", (Object)moveCurriculumLinesBean.getStudentCurricularPlan());
        request.setAttribute("withRules", (Object)moveCurriculumLinesBean.isWithRules());
        return mapping.findForward("showCurriculum");
    }

    private void addRuleResultMessagesToActionMessages(HttpServletRequest request, RuleResult ... falseRuleResults) {
        for (RuleResult ruleResult : falseRuleResults) {
            for (RuleResultMessage message : ruleResult.getMessages()) {
                if (message.isToTranslate()) {
                    this.addActionMessage(request, message.getMessage(), message.getArgs());
                    continue;
                }
                this.addActionMessageLiteral(request, message.getMessage());
            }
        }
    }

    private List<CurriculumLine> getSelectedCurriculumLines(HttpServletRequest request) {
        String[] selectedCurriculumLineIds = request.getParameterValues("selectedCurriculumLineIds");
        if (selectedCurriculumLineIds == null) {
            return Collections.emptyList();
        }
        ArrayList<CurriculumLine> result = new ArrayList<CurriculumLine>();
        for (String curriculumLineIdString : selectedCurriculumLineIds) {
            result.add((CurriculumLine)FenixFramework.getDomainObject((String)curriculumLineIdString));
        }
        return result;
    }

    protected StudentCurricularPlan getStudentCurricularPlan(HttpServletRequest request) {
        return (StudentCurricularPlan)((Object)this.getDomainObject(request, "scpID"));
    }
}

