/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.alumni;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Job;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.alumni.AlumniJobBean;
import org.fenixedu.academic.service.services.alumni.CreateProfessionalInformation;
import org.fenixedu.academic.service.services.alumni.DeleteProfessionalInformation;
import org.fenixedu.academic.service.services.alumni.EditProfessionalInformation;
import org.fenixedu.academic.ui.struts.action.alumni.AlumniApplication;
import org.fenixedu.academic.ui.struts.action.alumni.AlumniEntityManagementDA;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=AlumniApplication.AlumniProfessionalInfoApp.class, path="professional-information", titleKey="link.professional.information")
@Mapping(module="alumni", path="/professionalInformation", scope="request", parameter="method")
@Forwards(value={@Forward(name="innerProfessionalInformation", path="/alumni/viewAlumniProfessionalInformation.jsp"), @Forward(name="manageProfessionalInformation", path="/alumni/alumniManageProfessionalInformation.jsp")})
public class AlumniProfessionalInformationDA
extends AlumniEntityManagementDA {
    @EntryPoint
    public ActionForward innerProfessionalInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("alumni", (Object)this.getAlumniFromLoggedPerson(request));
        return mapping.findForward("innerProfessionalInformation");
    }

    public ActionForward updateIsEmployedPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RenderUtils.invalidateViewState((String)"alumniEmployment");
        return this.innerProfessionalInformation(mapping, actionForm, request, response);
    }

    public ActionForward prepareProfessionalInformationCreation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("jobCreateBean", (Object)new AlumniJobBean(this.getAlumniFromLoggedPerson(request)));
        return mapping.findForward("manageProfessionalInformation");
    }

    public ActionForward createBusinessAreaPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AlumniJobBean viewStateBean = (AlumniJobBean)this.getObjectFromViewState("jobCreateBean");
        viewStateBean.updateSchema();
        RenderUtils.invalidateViewState((String)"jobCreateBean");
        request.setAttribute("jobCreateBean", (Object)viewStateBean);
        return mapping.findForward("manageProfessionalInformation");
    }

    public ActionForward updateBusinessAreaPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AlumniJobBean viewStateBean = (AlumniJobBean)this.getObjectFromViewState("jobUpdateBean");
        viewStateBean.updateSchema();
        RenderUtils.invalidateViewState((String)"jobUpdateBean");
        request.setAttribute("jobUpdateBean", (Object)viewStateBean);
        return mapping.findForward("manageProfessionalInformation");
    }

    public ActionForward createProfessionalInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            CreateProfessionalInformation.run((AlumniJobBean)this.getRenderedObject());
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage());
            request.setAttribute("jobCreateBean", this.getObjectFromViewState("jobCreateBean"));
            return mapping.findForward("manageProfessionalInformation");
        }
        return this.innerProfessionalInformation(mapping, actionForm, request, response);
    }

    public ActionForward viewProfessionalInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("jobView", (Object)this.getJob(request));
        return this.innerProfessionalInformation(mapping, actionForm, request, response);
    }

    public ActionForward prepareUpdateProfessionalInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("jobUpdateBean", (Object)new AlumniJobBean(this.getAlumniFromLoggedPerson(request), this.getJob(request)));
        return mapping.findForward("manageProfessionalInformation");
    }

    public ActionForward updateProfessionalInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            EditProfessionalInformation.run((AlumniJobBean)this.getRenderedObject());
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage());
            request.setAttribute("jobUpdateBean", this.getObjectFromViewState("jobUpdateBean"));
            return mapping.findForward("manageProfessionalInformation");
        }
        return this.innerProfessionalInformation(mapping, actionForm, request, response);
    }

    public ActionForward updateProfessionalInformationError(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("jobUpdateBean", this.getObjectFromViewState("jobUpdateBean"));
        return mapping.findForward("manageProfessionalInformation");
    }

    public ActionForward deleteProfessionalInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.getFromRequest(request, "cancel") == null) {
            DeleteProfessionalInformation.run(this.getJob(request));
        }
        return this.innerProfessionalInformation(mapping, actionForm, request, response);
    }

    protected Job getJob(HttpServletRequest request) {
        return (Job)((Object)this.getDomainObject(request, "jobId"));
    }
}

