/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.studentEnrolment.bolonha;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleLevel;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.academic.dto.student.enrollment.bolonha.BolonhaStudentEnrollmentBean;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.ui.struts.action.commons.student.enrollment.bolonha.AbstractBolonhaStudentEnrollmentDA;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.joda.time.LocalDate;

@Mapping(path="/bolonhaStudentEnrollment", module="academicAdministration", formBean="bolonhaStudentEnrollmentForm", functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="showStudentEnrollmentMenu", path="/academicAdministration/studentEnrolments.do?method=prepareFromStudentEnrollmentWithRules")})
public class AcademicAdminOfficeBolonhaStudentEnrollmentDA
extends AbstractBolonhaStudentEnrollmentDA {
    @Override
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.prepareShowDegreeModulesToEnrol(mapping, form, request, response, this.getStudentCurricularPlan(request), this.getExecutionPeriod(request));
    }

    @Override
    protected ActionForward prepareShowDegreeModulesToEnrol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester) {
        request.setAttribute("action", (Object)this.getAction());
        this.addDebtsWarningMessages(studentCurricularPlan.getRegistration().getStudent(), executionSemester, request);
        return super.prepareShowDegreeModulesToEnrol(mapping, form, request, response, studentCurricularPlan, executionSemester);
    }

    protected void addDebtsWarningMessages(Student student, ExecutionSemester executionSemester, HttpServletRequest request) {
        if (TreasuryBridgeAPIFactory.implementation().isAcademicalActsBlocked(student.getPerson(), new LocalDate())) {
            this.addActionMessage("warning", request, "label.student.events.in.debt.unpayed.warning");
        }
    }

    protected StudentCurricularPlan getStudentCurricularPlan(HttpServletRequest request) {
        return (StudentCurricularPlan)((Object)this.getDomainObject(request, "scpID"));
    }

    protected ExecutionSemester getExecutionPeriod(HttpServletRequest request) {
        return (ExecutionSemester)this.getDomainObject(request, "executionPeriodID");
    }

    private Boolean getWithRules(ActionForm form) {
        return (Boolean)((DynaActionForm)form).get("withRules");
    }

    public ActionForward backToStudentEnrollments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        BolonhaStudentEnrollmentBean bolonhaStudentEnrollmentBean = this.getBolonhaStudentEnrollmentBeanFromViewState();
        request.setAttribute("studentCurricularPlan", (Object)bolonhaStudentEnrollmentBean.getStudentCurricularPlan());
        request.setAttribute("executionPeriod", (Object)bolonhaStudentEnrollmentBean.getExecutionPeriod());
        return mapping.findForward("showStudentEnrollmentMenu");
    }

    @Override
    protected int[] getCurricularYearForCurricularCourses() {
        return null;
    }

    @Override
    protected CurricularRuleLevel getCurricularRuleLevel(ActionForm form) {
        return this.getWithRules(form) != false ? CurricularRuleLevel.ENROLMENT_WITH_RULES : CurricularRuleLevel.ENROLMENT_NO_RULES;
    }

    @Override
    protected String getAction() {
        return "/bolonhaStudentEnrollment.do";
    }

    @Override
    public ActionForward prepareChooseCycleCourseGroupToEnrol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("withRules", (Object)request.getParameter("withRules"));
        return super.prepareChooseCycleCourseGroupToEnrol(mapping, form, request, response);
    }

    public ActionForward cancelChooseCycleCourseGroupToEnrol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.prepareShowDegreeModulesToEnrol(mapping, form, request, response, this.getStudentCurricularPlan(request), this.getExecutionPeriod(request));
    }
}

