/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.task;

import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.events.AccountingEventsManager;
import org.fenixedu.academic.task.CreateGratuityEvents$callable$generateGratuityEvent;
import org.fenixedu.academic.util.InvocationResult;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.annotation.Task;
import org.fenixedu.commons.i18n.I18N;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Task(englishTitle="CreateGratuityEvents", readOnly=true)
public class CreateGratuityEvents
extends CronTask {
    private int GratuityEvent_TOTAL_CREATED = 0;
    public static final Advice advice$generateGratuityEvent = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    private void generateGratuityEventsForAllStudents(ExecutionYear executionYear) {
        for (ExecutionDegree executionDegree : executionYear.getExecutionDegreesSet()) {
            for (StudentCurricularPlan studentCurricularPlan : executionDegree.getDegreeCurricularPlan().getStudentCurricularPlansSet()) {
                this.generateGratuityEvents(executionYear, studentCurricularPlan);
            }
        }
    }

    private void generateGratuityEvents(ExecutionYear executionYear, StudentCurricularPlan studentCurricularPlan) {
        if (!studentCurricularPlan.isBolonhaDegree() || !studentCurricularPlan.hasRegistration()) {
            return;
        }
        this.generateGratuityEvent(studentCurricularPlan, executionYear);
    }

    private void generateGratuityEvent(StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        Object object = advice$generateGratuityEvent.perform((Callable)new CreateGratuityEvents$callable$generateGratuityEvent(this, studentCurricularPlan, executionYear));
    }

    static /* synthetic */ void advised$generateGratuityEvent(CreateGratuityEvents this_, StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        try {
            AccountingEventsManager manager = new AccountingEventsManager();
            InvocationResult result = manager.createGratuityEvent(studentCurricularPlan, executionYear);
            if (result.isSuccess()) {
                ++this_.GratuityEvent_TOTAL_CREATED;
            }
        }
        catch (Exception e) {
            this_.taskLog("Exception on student curricular plan with oid : %s\n", new Object[]{studentCurricularPlan.getExternalId()});
            e.printStackTrace(this_.getTaskLogWriter());
        }
    }

    public void runTask() {
        I18N.setLocale((Locale)new Locale("PT", "pt"));
        this.generateGratuityEventsForAllStudents(ExecutionYear.readCurrentExecutionYear());
        this.taskLog("Created %s GratuityEvent events\n", new Object[]{this.GratuityEvent_TOTAL_CREATED});
    }
}

