/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.academicAdministrativeOffice;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Curriculum;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.BibliographicReferences;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ProgramCertificateRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.academic.util.HtmlToTextConverterUtil;
import org.fenixedu.academic.util.NumberToWordsConverter;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class ProgramCertificateRequestDocument
extends AdministrativeOfficeDocument {
    private static final long serialVersionUID = 12L;

    protected ProgramCertificateRequestDocument(ProgramCertificateRequest documentRequest) {
        super((IDocumentRequest)((Object)documentRequest));
    }

    protected ProgramCertificateRequest getDocumentRequest() {
        return (ProgramCertificateRequest)((Object)super.getDocumentRequest());
    }

    @Override
    protected void fillReport() {
        this.addParameter("certification", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.certification", (String[])new String[0]).toUpperCase());
        this.addParameter("certificationMessage", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.program.certificate.certification", (String[])new String[0]));
        this.setPersonFields();
        this.addParametersInformation();
        this.fillInstitutionAndStaffFields();
        this.setFooter((DocumentRequest)((Object)this.getDocumentRequest()));
        this.addParameter("enrolment", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.serviceRequests.enrolment", (String[])new String[0]));
    }

    private void addParametersInformation() {
        AdministrativeOffice administrativeOffice = this.getAdministrativeOffice();
        Person coordinator = administrativeOffice.getCoordinator().getPerson();
        Person student = this.getDocumentRequest().getPerson();
        UniversityUnit university = UniversityUnit.getInstitutionsUniversityUnit();
        String coordinatorGender = this.getCoordinatorGender(coordinator);
        String labelStudent = student.isMale() ? BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.the.student.male", (String[])new String[0]) : BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.the.student.female", (String[])new String[0]);
        String coordinatorName = coordinator.getName();
        String adminOfficeUnitName = this.getI18NText(administrativeOffice.getName()).toUpperCase();
        String universityName = this.getMLSTextContent(university.getPartyName()).toUpperCase();
        String institutionName = this.getInstitutionName().toUpperCase();
        String template = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.program.certificate.personalData.first", (String[])new String[0]);
        String firstPart = MessageFormat.format(template, coordinatorName, coordinatorGender, adminOfficeUnitName, institutionName, universityName, labelStudent);
        this.addParameter("firstPart", firstPart);
        this.addParameter("secondPart", student.getName());
        this.addParameter("thirdPart", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.with.number", (String[])new String[0]));
        this.addParameter("fourthPart", this.getStudentNumber());
        this.addParameter("fifthPart", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.of.male", (String[])new String[0]));
        this.addParameter("sixthPart", this.getDegreeDescription());
        this.addParameter("seventhPart", this.getProgramsDescription());
        this.createProgramsList(this.getLanguage());
    }

    @Override
    protected String getDegreeDescription() {
        CycleType requestedCycle = this.getDocumentRequest().getRequestedCycle();
        if (requestedCycle == null) {
            Registration registration = this.getDocumentRequest().getRegistration();
            DegreeType degreeType = registration.getDegreeType();
            CycleType cycleType = degreeType.hasExactlyOneCycleType() ? degreeType.getCycleType() : registration.getCycleType(this.getExecutionYear());
            return registration.getDegreeDescription(this.getExecutionYear(), cycleType, this.getLocale());
        }
        return this.getDocumentRequest().getRegistration().getDegreeDescription(this.getExecutionYear(), requestedCycle, this.getLocale());
    }

    public boolean isBolonha() {
        return this.getDocumentRequest().isBolonha();
    }

    @Override
    protected void setPersonFields() {
        this.addParameter("name", this.getDocumentRequest().getPerson().getName());
    }

    private String numberOfPrograms() {
        return NumberToWordsConverter.convert(this.getDocumentRequest().getEnrolmentsSet().size(), this.getLocale());
    }

    private String getProgramsDescription() {
        if (this.getDocumentRequest().getEnrolmentsSet().size() == 1) {
            return BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.program.certificate.program", (String[])new String[0]);
        }
        return MessageFormat.format(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.program.certificate.programs", (String[])new String[0]), this.numberOfPrograms());
    }

    @Override
    protected boolean showPriceFields() {
        return false;
    }

    private void createProgramsList(Locale language) {
        ArrayList<BolonhaProgramInformation> bolonha = new ArrayList<BolonhaProgramInformation>();
        ArrayList<PreBolonhaProgramInformation> preBolonha = new ArrayList<PreBolonhaProgramInformation>();
        this.addParameter("bolonhaList", bolonha);
        this.addParameter("preBolonhaList", preBolonha);
        this.addLabelsToMultiLanguage();
        for (Enrolment enrolment : this.getDocumentRequest().getEnrolmentsSet()) {
            if (enrolment.isBolonhaDegree()) {
                bolonha.add(new BolonhaProgramInformation(enrolment, language));
                continue;
            }
            preBolonha.add(new PreBolonhaProgramInformation(enrolment));
        }
    }

    private String getStudentNumber() {
        String agreementInformation;
        Registration registration = this.getDocumentRequest().getRegistration();
        if (registration.getRegistrationProtocol().isMilitaryAgreement() && !StringUtils.isEmpty((String)(agreementInformation = registration.getAgreementInformation()))) {
            return registration.getRegistrationProtocol().getCode() + " " + agreementInformation;
        }
        return registration.getStudent().getNumber().toString();
    }

    private void addLabelsToMultiLanguage() {
        this.addParameter("enrolment", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.serviceRequests.enrolment", (String[])new String[0]));
        this.addParameter("degreeLabel", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.degree", (String[])new String[0]));
        this.addParameter("degreeCurricularPlanLabel", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.degreeCurricularPlan", (String[])new String[0]));
        this.addParameter("weightLabel", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.set.evaluation.enrolment.weight", (String[])new String[0]));
        this.addParameter("contexts", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.contexts", (String[])new String[0]));
        this.addParameter("prerequisites", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.prerequisites", (String[])new String[0]));
        this.addParameter("objectives", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.objectives", (String[])new String[0]));
        this.addParameter("program", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.program", (String[])new String[0]));
        this.addParameter("evaluationMethod", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.evaluationMethod", (String[])new String[0]));
        this.addParameter("bibliography", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.bibliography", (String[])new String[0]));
        this.addParameter("averageGrade", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.average.grade", (String[])new String[0]));
        this.addParameter("generalObjectives", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.generalObjectives", (String[])new String[0]));
        this.addParameter("operationalObjectives", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.operationalObjectives", (String[])new String[0]));
    }

    public static class BibliographicInformation {
        private final String authors;
        private final String title;
        private final String reference;
        private final String year;

        public BibliographicInformation(String authors, String title, String reference, String year) {
            this.authors = authors;
            this.title = title;
            this.reference = reference;
            this.year = year;
        }

        public String getAuthors() {
            return this.authors;
        }

        public String getTitle() {
            return this.title;
        }

        public String getReference() {
            return this.reference;
        }

        public String getYear() {
            return this.year;
        }
    }

    public static class ContextInformation {
        private final String name;
        private final String period;

        public ContextInformation(Context context, Locale language, Locale locale) {
            this.name = context.getParentCourseGroup().getOneFullNameI18N(language);
            this.period = context.getCurricularPeriod().getFullLabel(locale);
        }

        public String getName() {
            return this.name;
        }

        public String getPeriod() {
            return this.period;
        }
    }

    public class PreBolonhaProgramInformation
    extends ProgramInformation {
        private String program;
        private String generalObjectives;
        private String operationalObjectives;

        public PreBolonhaProgramInformation(Enrolment enrolment) {
            super(enrolment);
            Curriculum curriculum = enrolment.getCurricularCourse().findLatestCurriculum();
            if (curriculum != null) {
                this.program = HtmlToTextConverterUtil.convertToText(ProgramCertificateRequestDocument.this.getMLSTextContent(curriculum.getProgramI18N()));
                this.generalObjectives = HtmlToTextConverterUtil.convertToText(ProgramCertificateRequestDocument.this.getMLSTextContent(curriculum.getGeneralObjectivesI18N()));
                this.operationalObjectives = HtmlToTextConverterUtil.convertToText(ProgramCertificateRequestDocument.this.getMLSTextContent(curriculum.getOperacionalObjectivesI18N()));
            } else {
                this.operationalObjectives = "";
                this.generalObjectives = "";
                this.program = "";
            }
        }

        public String getProgram() {
            return this.program;
        }

        public String getGeneralObjectives() {
            return this.generalObjectives;
        }

        public String getOperationalObjectives() {
            return this.operationalObjectives;
        }
    }

    public class BolonhaProgramInformation
    extends ProgramInformation {
        private final String program;
        private final String weigth;
        private final String prerequisites;
        private final String objectives;
        private final String evaluationMethod;
        private final List<BibliographicInformation> bibliographics;

        public BolonhaProgramInformation(Enrolment enrolment, Locale language) {
            super(enrolment);
            ExecutionSemester executionSemester = enrolment.getExecutionPeriod();
            CurricularCourse curricularCourse = enrolment.getCurricularCourse();
            this.program = HtmlToTextConverterUtil.convertToText(ProgramCertificateRequestDocument.this.getMLSTextContent(curricularCourse.getProgramI18N(executionSemester)));
            this.weigth = curricularCourse.getWeight(executionSemester).toString();
            this.prerequisites = ProgramCertificateRequestDocument.this.getMLSTextContent(curricularCourse.getPrerequisitesI18N());
            this.objectives = HtmlToTextConverterUtil.convertToText(ProgramCertificateRequestDocument.this.getMLSTextContent(curricularCourse.getObjectivesI18N(executionSemester)));
            this.evaluationMethod = HtmlToTextConverterUtil.convertToText(ProgramCertificateRequestDocument.this.getMLSTextContent(curricularCourse.getEvaluationMethodI18N(executionSemester)));
            this.bibliographics = this.buildBibliographicInformation(curricularCourse, executionSemester);
        }

        private List<BibliographicInformation> buildBibliographicInformation(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
            ArrayList<BibliographicInformation> result = new ArrayList<BibliographicInformation>();
            if (curricularCourse.getCompetenceCourse() != null) {
                for (BibliographicReferences.BibliographicReference reference : curricularCourse.getCompetenceCourse().getAllBibliographicReferences(executionSemester)) {
                    result.add(new BibliographicInformation(reference.getAuthors(), reference.getTitle(), reference.getReference(), reference.getYear()));
                }
            }
            return result;
        }

        public String getProgram() {
            return this.program;
        }

        public String getWeigth() {
            return this.weigth;
        }

        public String getPrerequisites() {
            return this.prerequisites;
        }

        public String getObjectives() {
            return this.objectives;
        }

        public String getEvaluationMethod() {
            return this.evaluationMethod;
        }

        public List<BibliographicInformation> getBibliographics() {
            return this.bibliographics;
        }
    }

    public abstract class ProgramInformation
    implements Serializable {
        private final String degree;
        private final String degreeCurricularPlan;
        private final String curricularCourse;
        private final List<ContextInformation> contexts;

        public ProgramInformation(Enrolment enrolment) {
            this.degree = ProgramCertificateRequestDocument.this.getMLSTextContent(enrolment.getCurricularCourse().getDegree().getNameI18N(enrolment.getExecutionYear()));
            this.degreeCurricularPlan = enrolment.getCurricularCourse().getDegreeCurricularPlan().getName();
            this.curricularCourse = this.buildCurricularCourseName(enrolment.getCurricularCourse());
            this.contexts = this.buildContextsInformation(enrolment.getCurricularCourse());
        }

        private List<ContextInformation> buildContextsInformation(CurricularCourse curricularCourse) {
            ArrayList<ContextInformation> result = new ArrayList<ContextInformation>();
            for (Context context : curricularCourse.getParentContextsSet()) {
                result.add(new ContextInformation(context, ProgramCertificateRequestDocument.this.getLanguage(), ProgramCertificateRequestDocument.this.getLocale()));
            }
            return result;
        }

        private String buildCurricularCourseName(CurricularCourse curricularCourse) {
            return ProgramCertificateRequestDocument.this.getMLSTextContent(curricularCourse.getNameI18N()) + (StringUtils.isEmpty((String)curricularCourse.getAcronym()) ? "" : " (" + curricularCourse.getAcronym() + ")");
        }

        public String getDegree() {
            return this.degree;
        }

        public String getDegreeCurricularPlan() {
            return this.degreeCurricularPlan;
        }

        public String getCurricularCourse() {
            return this.curricularCourse;
        }

        public List<ContextInformation> getContexts() {
            return this.contexts;
        }
    }
}

