/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import pt.ist.fenixframework.DomainObject;

public class PageContainerBean
implements Serializable {
    private transient List<DomainObject> objects;
    private List<DomainObject> pageObjects;
    private DomainObject selected;
    private Integer numberOfPages;
    private Integer page = 1;

    public List<DomainObject> getObjects() {
        return this.objects;
    }

    public void setObjects(List<DomainObject> objects) {
        this.objects = objects;
        this.setPageObjects(null);
    }

    protected List<DomainObject> getPageObjects() {
        return this.pageObjects;
    }

    protected void setPageObjects(List<DomainObject> pageObjects) {
        this.pageObjects = pageObjects;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public DomainObject getSelected() {
        return this.selected;
    }

    public void setSelected(DomainObject selected) {
        this.selected = selected;
    }

    public List<DomainObject> getPageByPageSize(int pageSize) {
        List<DomainObject> pageObjects = this.getPageObjects();
        if (pageObjects != null) {
            return pageObjects;
        }
        List<DomainObject> objects = this.getObjects();
        if (objects != null && !objects.isEmpty()) {
            this.validatePageNumber(pageSize);
            int from = (this.getPage() - 1) * pageSize;
            int to = this.getObjects().size() > this.getPage() * pageSize ? this.getPage() * pageSize : objects.size();
            ArrayList<DomainObject> subList = new ArrayList<DomainObject>(objects.subList(from, to));
            this.setPageObjects(subList);
            return subList;
        }
        return Collections.emptyList();
    }

    private void validatePageNumber(int pageSize) {
        if (this.getPage() < 1) {
            this.setPage(1);
        } else {
            Integer numberOfPages = this.getNumberOfPages(pageSize);
            if (this.getPage() > numberOfPages) {
                this.setPage(numberOfPages);
            }
        }
    }

    public int getNumberOfPages(int pageSize) {
        if (this.getObjects() != null) {
            this.numberOfPages = (int)Math.ceil((double)this.getObjects().size() / (double)pageSize);
        }
        return this.numberOfPages;
    }

    public boolean hasNextPage(int pageSize) {
        return this.getPage() < this.getNumberOfPages(pageSize);
    }

    public boolean hasPreviousPage(int pageSize) {
        return this.getPage() > 1;
    }

    public List<DomainObject> getAllObjects() {
        if (this.getPageObjects() != null) {
            return this.getPageObjects();
        }
        if (this.getObjects() != null) {
            this.setPageObjects(this.getObjects());
            return this.getObjects();
        }
        return Collections.emptyList();
    }

    public void setPageJump(Integer pageJump) {
        this.setPage(pageJump);
    }

    public Integer getPageJump() {
        return null;
    }
}

