/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.Calendar;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.LessonInstance;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.dto.InfoRoomOccupation;
import org.fenixedu.academic.dto.InfoShift;
import org.fenixedu.academic.dto.InfoShowOccupation;
import org.fenixedu.academic.util.DiaSemana;
import org.fenixedu.academic.util.HourMinuteSecond;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.Weeks;
import org.joda.time.YearMonthDay;

public class InfoLessonInstanceAggregation
extends InfoShowOccupation {
    private static final long serialVersionUID = 1L;
    private final Shift shift;
    private final int weekDay;
    private final HourMinuteSecond begin;
    private final HourMinuteSecond end;
    private final Space allocatableSpace;
    private final SortedSet<LocalDate> dates = new TreeSet<LocalDate>();

    public InfoLessonInstanceAggregation(Shift shift, int weekDay, HourMinuteSecond begin, HourMinuteSecond end, Space allocatableSpace) {
        this.shift = shift;
        this.weekDay = weekDay;
        this.begin = begin;
        this.end = end;
        this.allocatableSpace = allocatableSpace;
    }

    public InfoLessonInstanceAggregation(Shift shift, LessonInstance instance) {
        this.shift = shift;
        this.weekDay = instance.getBeginDateTime().getDayOfWeek();
        this.begin = instance.getStartTime();
        this.end = instance.getEndTime();
        this.allocatableSpace = instance.getRoom();
    }

    public InfoLessonInstanceAggregation(Shift shift, Lesson lesson, YearMonthDay yearMonthDay) {
        this.shift = shift;
        this.weekDay = yearMonthDay.toDateMidnight().getDayOfWeek();
        this.begin = lesson.getBeginHourMinuteSecond();
        this.end = lesson.getEndHourMinuteSecond();
        this.allocatableSpace = lesson.getSala();
    }

    private void register(YearMonthDay yearMonthDay) {
        this.dates.add(new LocalDate(yearMonthDay.getYear(), yearMonthDay.getMonthOfYear(), yearMonthDay.getDayOfMonth()));
    }

    @Override
    public InfoShift getInfoShift() {
        return new InfoShift(this.shift);
    }

    @Override
    public ShiftType getTipo() {
        return null;
    }

    @Override
    public InfoRoomOccupation getInfoRoomOccupation() {
        throw new Error("Not implemented.");
    }

    @Override
    public DiaSemana getDiaSemana() {
        return DiaSemana.fromJodaWeekDay(this.weekDay);
    }

    @Override
    public Calendar getInicio() {
        throw new Error("Not implemented.");
    }

    @Override
    public Calendar getFim() {
        throw new Error("Not implemented.");
    }

    @Override
    public int getLastHourOfDay() {
        int hourOfDay = this.end.getHour();
        return this.end.getMinuteOfHour() > 0 ? hourOfDay + 1 : hourOfDay;
    }

    @Override
    public int getFirstHourOfDay() {
        return this.begin.getHour();
    }

    @Override
    public HourMinuteSecond getBeginHourMinuteSecond() {
        return this.begin;
    }

    @Override
    public HourMinuteSecond getEndHourMinuteSecond() {
        return this.end;
    }

    @Override
    public Space getAllocatableSpace() {
        return this.allocatableSpace;
    }

    public Shift getShift() {
        return this.shift;
    }

    public SortedSet<LocalDate> getDates() {
        return this.dates;
    }

    public SortedSet<Integer> getWeeks() {
        ExecutionCourse executionCourse = this.shift.getExecutionCourse();
        YearMonthDay firstPossibleLessonDay = executionCourse.getMaxLessonsPeriod().getLeft();
        YearMonthDay lastPossibleLessonDay = executionCourse.getMaxLessonsPeriod().getRight();
        return this.getWeeks(new Interval((ReadableInstant)firstPossibleLessonDay.toDateTimeAtMidnight(), (ReadableInstant)lastPossibleLessonDay.toDateTimeAtMidnight().plusDays(1)));
    }

    public SortedSet<Integer> getWeeks(Interval lessonInterval) {
        TreeSet<Integer> weeks = new TreeSet<Integer>();
        LocalDate firstPossibleLessonDay = lessonInterval.getStart().toLocalDate();
        for (LocalDate localDate : this.dates) {
            Integer week = Weeks.weeksBetween((ReadablePartial)firstPossibleLessonDay, (ReadablePartial)localDate).getWeeks() + 1;
            weeks.add(week);
        }
        return weeks;
    }

    public boolean availableInAllWeeks() {
        return false;
    }

    public static Collection<InfoLessonInstanceAggregation> getAggregations(Shift shift) {
        TreeMap<String, InfoLessonInstanceAggregation> result = new TreeMap<String, InfoLessonInstanceAggregation>();
        for (Lesson lesson : shift.getAssociatedLessonsSet()) {
            InfoLessonInstanceAggregation aggregation;
            String key;
            for (LessonInstance instance : lesson.getLessonInstancesSet()) {
                key = InfoLessonInstanceAggregation.key(instance);
                if (!result.containsKey(key)) {
                    result.put(key, new InfoLessonInstanceAggregation(shift, instance));
                }
                aggregation = (InfoLessonInstanceAggregation)result.get(key);
                aggregation.register(instance.getDay());
            }
            for (YearMonthDay yearMonthDay : lesson.getAllLessonDatesWithoutInstanceDates()) {
                key = InfoLessonInstanceAggregation.key(lesson, yearMonthDay);
                if (!result.containsKey(key)) {
                    result.put(key, new InfoLessonInstanceAggregation(shift, lesson, yearMonthDay));
                }
                aggregation = (InfoLessonInstanceAggregation)result.get(key);
                aggregation.register(yearMonthDay);
            }
        }
        return result.values();
    }

    private static String key(Lesson lesson, YearMonthDay yearMonthDay) {
        StringBuilder key = new StringBuilder();
        key.append(yearMonthDay.toDateMidnight().getDayOfWeek());
        key.append('_');
        key.append(lesson.getBeginHourMinuteSecond().toString("HH:mm"));
        key.append('_');
        key.append(lesson.getEndHourMinuteSecond().toString("HH:mm"));
        key.append('_');
        key.append(lesson.getSala() == null ? "" : lesson.getSala().getExternalId());
        return key.toString();
    }

    private static String key(LessonInstance instance) {
        StringBuilder key = new StringBuilder();
        key.append(instance.getBeginDateTime().getDayOfWeek());
        key.append('_');
        key.append(instance.getStartTime().toString("HH:mm"));
        key.append('_');
        key.append(instance.getEndTime().toString("HH:mm"));
        key.append('_');
        key.append(instance.getRoom() == null ? "" : instance.getRoom().getExternalId());
        return key.toString();
    }

    @Override
    public String getExternalId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.shift.getExternalId()).append(this.weekDay).append(this.begin.toString("HH:mm:ss")).append(this.end.toString("HH:mm:ss"));
        if (this.allocatableSpace != null) {
            sb.append(this.allocatableSpace.getExternalId());
        }
        return sb.toString();
    }

    public String prettyPrintWeeks() {
        return InfoLessonInstanceAggregation.prettyPrintWeeks(this.getWeeks());
    }

    public static String prettyPrintWeeks(SortedSet<Integer> weeks) {
        StringBuilder builder = new StringBuilder();
        Integer[] weeksA = weeks.toArray(new Integer[0]);
        for (int i = 0; i < weeksA.length; ++i) {
            if (i == 0) {
                builder.append(weeksA[i]);
                continue;
            }
            if (i == weeksA.length - 1 || weeksA[i] + 1 != weeksA[i + 1]) {
                String seperator = weeksA[i - 1] + 1 == weeksA[i] ? " - " : ", ";
                builder.append(seperator);
                builder.append(weeksA[i]);
                continue;
            }
            if (weeksA[i - 1] + 1 == weeksA[i]) continue;
            builder.append(", ");
            builder.append(weeksA[i]);
        }
        return builder.toString();
    }
}

