/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.space;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.CourseLoad;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.FrequencyType;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.LessonInstance;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.space.LessonInstanceSpaceOccupation_Base;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.SpacePredicates;
import org.fenixedu.academic.util.DiaSemana;
import org.fenixedu.academic.util.HourMinuteSecond;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.TimeOfDay;
import org.joda.time.YearMonthDay;

public class LessonInstanceSpaceOccupation
extends LessonInstanceSpaceOccupation_Base {
    public LessonInstanceSpaceOccupation(Space allocatableSpace) {
        this.setResource(allocatableSpace);
    }

    public void edit(LessonInstance lessonInstance) {
        AccessControl.check(this, SpacePredicates.checkPermissionsToManageLessonInstanceSpaceOccupationsWithTeacherCheck);
        if (this.getLessonInstancesSet().contains((Object)lessonInstance)) {
            this.removeLessonInstances(lessonInstance);
        }
        Space space = this.getSpace();
        if (!space.isFree((List)Lists.newArrayList((Object[])new Interval[]{new Interval((ReadableInstant)lessonInstance.getBeginDateTime(), (ReadableInstant)lessonInstance.getEndDateTime())}))) {
            throw new DomainException("error.LessonInstanceSpaceOccupation.room.is.not.free", space.getName(), lessonInstance.getDay().toString("dd-MM-yy"));
        }
        this.addLessonInstances(lessonInstance);
    }

    public void delete() {
        AccessControl.check(this, SpacePredicates.checkPermissionsToManageLessonInstanceSpaceOccupations);
        if (this.getDeletionBlockers().isEmpty()) {
            super.delete();
        }
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getLessonInstancesSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.cannotDeleteLessonInstanceSpaceOccupation", (String[])new String[0]));
        }
    }

    protected boolean intersects(YearMonthDay startDate, YearMonthDay endDate) {
        return true;
    }

    public List<Interval> getEventSpaceOccupationIntervals(YearMonthDay startDateToSearch, YearMonthDay endDateToSearch) {
        ArrayList<Interval> result = new ArrayList<Interval>();
        Set lessonInstances = this.getLessonInstancesSet();
        DateTime startDateTime = startDateToSearch != null ? startDateToSearch.toDateTimeAtMidnight() : null;
        DateTime endDateTime = endDateToSearch != null ? endDateToSearch.toDateTime(new TimeOfDay(23, 59, 59)) : null;
        for (LessonInstance lessonInstance : lessonInstances) {
            if (startDateTime != null && (lessonInstance.getEndDateTime().isBefore((ReadableInstant)startDateTime) || lessonInstance.getBeginDateTime().isAfter((ReadableInstant)endDateTime))) continue;
            result.add(new Interval((ReadableInstant)lessonInstance.getBeginDateTime(), (ReadableInstant)lessonInstance.getEndDateTime()));
        }
        return result;
    }

    public YearMonthDay getBeginDate() {
        return null;
    }

    public YearMonthDay getEndDate() {
        return null;
    }

    public HourMinuteSecond getStartTimeDateHourMinuteSecond() {
        return null;
    }

    public HourMinuteSecond getEndTimeDateHourMinuteSecond() {
        return null;
    }

    public FrequencyType getFrequency() {
        return null;
    }

    public DiaSemana getDayOfWeek() {
        return null;
    }

    public Boolean getDailyFrequencyMarkSaturday() {
        return null;
    }

    public Boolean getDailyFrequencyMarkSunday() {
        return null;
    }

    public Group getAccessGroup() {
        return this.getSpace().getOccupationsGroupWithChainOfResponsability();
    }

    public boolean isOccupiedByExecutionCourse(ExecutionCourse executionCourse, DateTime start, DateTime end) {
        for (LessonInstance lessonInstance : this.getLessonInstancesSet()) {
            Lesson lesson = lessonInstance.getLesson();
            if (lesson.getExecutionCourse() != executionCourse || !start.isBefore((ReadableInstant)lessonInstance.getEndDateTime()) || !end.isAfter((ReadableInstant)lessonInstance.getBeginDateTime())) continue;
            return true;
        }
        return false;
    }

    public String getPresentationString() {
        if (!this.getLessonInstancesSet().isEmpty()) {
            return ((LessonInstance)((Object)this.getLessonInstancesSet().iterator().next())).getLesson().getShift().getExecutionCourse().getSigla();
        }
        return ((Object)((Object)this)).getClass().getName();
    }

    protected boolean overlaps(Interval interval) {
        for (LessonInstance instance : this.getLessonInstancesSet()) {
            Interval lessonInterval = instance.getInterval();
            if (!interval.overlaps((ReadableInterval)lessonInterval)) continue;
            return true;
        }
        return false;
    }

    public String getUrl() {
        LessonInstance lis = (LessonInstance)((Object)this.getLessonInstancesSet().iterator().next());
        if (lis == null) {
            return "";
        }
        Lesson li = lis.getLesson();
        return li.getShift().getExecutionCourse().getSiteUrl();
    }

    public String getInfo() {
        Lesson theLesson = ((LessonInstance)((Object)this.getLessonInstancesSet().iterator().next())).getLesson();
        String asd = ((CourseLoad)((Object)theLesson.getShift().getCourseLoadsSet().iterator().next())).getType().getFullNameTipoAula();
        for (YearMonthDay ymd : theLesson.getAllLessonDates()) {
            asd = asd + "\n" + ymd.toString();
        }
        return asd;
    }
}

