/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis.activities;

import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.alert.PhdReporterReviewAlert;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.ThesisJuryElement;
import org.fenixedu.academic.domain.phd.thesis.activities.PhdThesisActivity;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class RemindJuryReviewToReporters
extends PhdThesisActivity {
    @Override
    protected void activityPreConditions(PhdThesisProcess process2, User userView) {
        if (process2.getActiveState() != PhdThesisProcessStateType.WAITING_FOR_JURY_REPORTER_FEEDBACK) {
            throw new PreConditionNotValidException();
        }
        if (!process2.isAllowedToManageProcess(userView)) {
            throw new PreConditionNotValidException();
        }
    }

    @Override
    protected PhdThesisProcess executeActivity(PhdThesisProcess process2, User userView, Object object) {
        PhdThesisProcessBean bean = (PhdThesisProcessBean)object;
        if (bean.isToNotify()) {
            this.remindReporters(process2);
        }
        return process2;
    }

    private void remindReporters(PhdThesisProcess process2) {
        for (ThesisJuryElement juryElement : process2.getThesisJuryElementsSet()) {
            if (!juryElement.getReporter().booleanValue() || juryElement.isDocumentValidated()) continue;
            PhdParticipant participant = juryElement.getParticipant();
            this.sendReminderToReporter(process2.getIndividualProgramProcess(), participant);
        }
    }

    private void sendReminderToReporter(PhdIndividualProgramProcess process2, PhdParticipant participant) {
        AlertService.AlertMessage subject = AlertService.AlertMessage.create(AlertService.AlertMessage.get("message.phd.remind.jury.reviews.subject", process2.getPhdProgram().getName()), new Object[0]).isKey(false).withPrefix(false);
        String partialBody = null;
        partialBody = !this.hasExceededLimitForReview(process2.getThesisProcess()) ? AlertService.AlertMessage.get("message.phd.remind.jury.reviews.body", process2.getPerson().getName(), process2.getProcessNumber(), this.daysLeftUntilDeadline(process2.getThesisProcess())) : AlertService.AlertMessage.get("message.phd.remind.jury.reviews.body.late", process2.getPerson().getName(), process2.getProcessNumber());
        AlertService.AlertMessage body = AlertService.AlertMessage.create(partialBody + "\n\n" + RemindJuryReviewToReporters.getAccessInformation(process2, participant, "message.phd.request.jury.reviews.coordinator.access", "message.phd.request.jury.reviews.teacher.access"), new Object[0]).isKey(false).withPrefix(false);
        AlertService.alertParticipants(process2, subject, body, participant);
    }

    private boolean hasExceededLimitForReview(PhdThesisProcess process2) {
        return !new LocalDate().isBefore((ReadablePartial)process2.getWhenJuryValidated().plusDays(PhdReporterReviewAlert.getReporterReviewDeadlineDays()));
    }

    private int daysLeftUntilDeadline(PhdThesisProcess process2) {
        return Days.daysBetween((ReadablePartial)new LocalDate(), (ReadablePartial)process2.getWhenJuryValidated().plusDays(PhdReporterReviewAlert.getReporterReviewDeadlineDays())).getDays();
    }
}

