/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.candidacy;

import java.util.Collections;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Entry;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.paymentCodes.AccountingEventPaymentCode;
import org.fenixedu.academic.domain.accounting.paymentCodes.IndividualCandidacyPaymentCode;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyEvent_Base;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcess;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.dto.accounting.SibsTransactionDetailDTO;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.YearMonthDay;

public class PhdProgramCandidacyEvent
extends PhdProgramCandidacyEvent_Base {
    protected PhdProgramCandidacyEvent() {
    }

    public PhdProgramCandidacyEvent(AdministrativeOffice administrativeOffice, Person person, PhdProgramCandidacyProcess candidacyProcess) {
        this();
        this.init(administrativeOffice, person, candidacyProcess);
    }

    public PhdProgramCandidacyEvent(Person person, PhdProgramCandidacyProcess process2) {
        this(process2.getIndividualProgramProcess().getAdministrativeOffice(), person, process2);
        if (process2.isPublicCandidacy()) {
            this.attachAvailablePaymentCode();
        }
    }

    protected void attachAvailablePaymentCode() {
        YearMonthDay candidacyDate = this.getCandidacyProcess().getCandidacyDate().toDateMidnight().toYearMonthDay();
        IndividualCandidacyPaymentCode paymentCode = IndividualCandidacyPaymentCode.getAvailablePaymentCodeAndUse(PaymentCodeType.PHD_PROGRAM_CANDIDACY_PROCESS, candidacyDate, (Event)((Object)this), this.getPerson());
        if (paymentCode == null) {
            throw new DomainException("error.IndividualCandidacyEvent.invalid.payment.code", new String[0]);
        }
    }

    private void init(AdministrativeOffice administrativeOffice, Person person, PhdProgramCandidacyProcess candidacyProcess) {
        super.init(administrativeOffice, EventType.CANDIDACY_ENROLMENT, person);
        String[] args = new String[]{};
        if (candidacyProcess == null) {
            throw new DomainException("error.phd.candidacy.PhdProgramCandidacyEvent.candidacyProcess.cannot.be.null", args);
        }
        super.setCandidacyProcess(candidacyProcess);
    }

    public void setCandidacyProcess(PhdProgramCandidacyProcess candidacyProcess) {
        throw new DomainException("error.phd.candidacy.PhdProgramCandidacyEvent.cannot.modify.candidacyProcess", new String[0]);
    }

    public LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(entryType.name(), "resources.EnumerationResources").appendLabel(" (").appendLabel(this.getPhdProgram().getPresentationName()).appendLabel(" - ").appendLabel(this.getExecutionYear().getYear()).appendLabel(")");
        return labelFormatter;
    }

    public LabelFormatter getDescription() {
        return new LabelFormatter().appendLabel(AlertService.getMessageFromResource("label.phd.candidacy")).appendLabel(": ").appendLabel(this.getPhdProgram().getPresentationName()).appendLabel(" - ").appendLabel(this.getExecutionYear().getYear());
    }

    private ExecutionYear getExecutionYear() {
        return this.getCandidacyProcess().getIndividualProgramProcess().getExecutionYear();
    }

    protected PhdProgram getPhdProgram() {
        return this.getCandidacyProcess().getIndividualProgramProcess().getPhdProgram();
    }

    protected void disconnect() {
        this.setCandidacyProcess(null);
        super.disconnect();
    }

    public IndividualCandidacyPaymentCode getAssociatedPaymentCode() {
        if (super.getAllPaymentCodes().isEmpty()) {
            return null;
        }
        return (IndividualCandidacyPaymentCode)((Object)super.getAllPaymentCodes().iterator().next());
    }

    public PhdIndividualProgramProcess getPhdIndividualProgramProcess() {
        return this.getCandidacyProcess().getIndividualProgramProcess();
    }

    protected Set<Entry> internalProcess(User responsibleUser, AccountingEventPaymentCode paymentCode, Money amountToPay, SibsTransactionDetailDTO transactionDetail) {
        return this.internalProcess(responsibleUser, Collections.singletonList(new EntryDTO(this.getEntryType(), (Event)((Object)this), amountToPay)), transactionDetail);
    }

    protected EntryType getEntryType() {
        return EntryType.CANDIDACY_ENROLMENT_FEE;
    }
}

