/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.alert;

import java.util.Collections;
import java.util.Set;
import org.fenixedu.academic.FenixEduAcademicConfiguration;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.alert.PublicPhdMissingCandidacyAlert_Base;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramPublicCandidacyHashCode;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;

public class PublicPhdMissingCandidacyAlert
extends PublicPhdMissingCandidacyAlert_Base {
    private static final int INTERVAL = 15;

    private PublicPhdMissingCandidacyAlert() {
    }

    public PublicPhdMissingCandidacyAlert(PhdProgramPublicCandidacyHashCode candidacyHashCode) {
        this();
        String[] args = new String[]{};
        if (candidacyHashCode == null) {
            throw new DomainException("error.PublicPhdMissingCandidacyAlert.invalid.candidacy.hash.code", args);
        }
        this.init(this.generateSubject(candidacyHashCode), this.generateBody(candidacyHashCode));
        this.setCandidacyHashCode(candidacyHashCode);
    }

    private MultiLanguageString generateSubject(PhdProgramPublicCandidacyHashCode candidacyHashCode) {
        return new MultiLanguageString().with(MultiLanguageString.en, BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.email.subject.missing.candidacy", (String[])new String[0]));
    }

    private MultiLanguageString generateBody(PhdProgramPublicCandidacyHashCode hashCode) {
        String submissionAccessURL = FenixEduAcademicConfiguration.getConfiguration().getPhdPublicCandidacySubmissionLink();
        String body = String.format(BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.email.body.missing.candidacy", (String[])new String[0]), submissionAccessURL, hashCode.getValue());
        return new MultiLanguageString().with(MultiLanguageString.en, body);
    }

    protected boolean isToFire() {
        int days = Days.daysBetween((ReadableInstant)this.calculateStartDate().toDateMidnight(), (ReadableInstant)new LocalDate().toDateMidnight()).getDays();
        return days >= 15;
    }

    private LocalDate calculateStartDate() {
        return this.getFireDate() != null ? this.getFireDate().toLocalDate() : this.getCandidacyHashCode().getWhenCreated().toLocalDate();
    }

    protected boolean isToDiscard() {
        return this.getCandidacyHashCode().hasCandidacyProcess() || this.candidacyPeriodIsOver();
    }

    private boolean candidacyPeriodIsOver() {
        return new DateTime().isAfter((ReadableInstant)this.getCandidacyHashCode().getPhdProgramCandidacyProcess().getPublicPhdCandidacyPeriod().getEnd());
    }

    protected void generateMessage() {
        new Message((Sender)((Object)this.getSender()), null, Collections.emptyList(), this.buildMailSubject(), this.buildMailBody(), this.getEmail());
    }

    private Set<String> getEmail() {
        return Collections.singleton(this.getCandidacyHashCode().getEmail());
    }

    public String getDescription() {
        return BundleUtil.getString((String)"resources.PhdResources", (String)String.format("message.phd.missing.candidacy.alert", 15), (String[])new String[0]);
    }

    public boolean isToSendMail() {
        return true;
    }

    public boolean isSystemAlert() {
        return true;
    }

    protected void disconnect() {
        this.setCandidacyHashCode(null);
        super.disconnect();
    }
}

