/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdProgramInformation$callable$createInformation;
import org.fenixedu.academic.domain.phd.PhdProgramInformation$callable$edit;
import org.fenixedu.academic.domain.phd.PhdProgramInformationBean;
import org.fenixedu.academic.domain.phd.PhdProgramInformation_Base;
import org.fenixedu.academic.domain.phd.exceptions.PhdDomainOperationException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PhdProgramInformation
extends PhdProgramInformation_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createInformation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected PhdProgramInformation() {
    }

    protected PhdProgramInformation(PhdProgramInformationBean bean) {
        this.init(bean);
    }

    protected void init(PhdProgramInformationBean bean) {
        this.checkParameters(bean);
        this.setBeginDate(bean.getBeginDate());
        this.setMinThesisEctsCredits(bean.getMinThesisEctsCredits());
        this.setMaxThesisEctsCredits(bean.getMaxThesisEctsCredits());
        this.setMinStudyPlanEctsCredits(bean.getMinStudyPlanEctsCredits());
        this.setMaxStudyPlanEctsCredits(bean.getMaxStudyPlanEctsCredits());
        this.setNumberOfYears(bean.getNumberOfYears());
        this.setNumberOfSemesters(bean.getNumberOfSemesters());
        this.setPhdProgram(bean.getPhdProgram());
    }

    protected void checkParameters(PhdProgramInformationBean bean) {
        if (bean.getBeginDate() == null) {
            throw new DomainException("error.phd.PhdProgramInformation.beginDate.required", new String[0]);
        }
        if (bean.getMinThesisEctsCredits() == null) {
            throw new DomainException("error.phd.PhdProgramInformation.MinThesisEctsCredits.required", new String[0]);
        }
        if (bean.getMaxThesisEctsCredits() == null) {
            throw new DomainException("error.phd.PhdProgramInformation.maxThesisEctsCredits.required", new String[0]);
        }
        if (bean.getMinStudyPlanEctsCredits() == null) {
            throw new DomainException("error.phd.PhdProgramInformation.minStudyPlanEctsCredits.required", new String[0]);
        }
        if (bean.getMaxStudyPlanEctsCredits() == null) {
            throw new DomainException("error.phd.PhdProgramInformation.maxStudyPlanEctsCredits.required", new String[0]);
        }
        if (bean.getNumberOfYears() == null) {
            throw new DomainException("error.phd.PhdProgramInformation.numberOfYears", new String[0]);
        }
        if (bean.getNumberOfSemesters() == null) {
            throw new DomainException("error.phd.PhdProgramInformation.numberOfSemesters", new String[0]);
        }
        if (this.hasSomePhdProgramInformationBeanWithSameBeginDate(bean)) {
            throw new PhdDomainOperationException("error.phd.PhdProgramInformation.other.information.with.same.beginDate", new String[0]);
        }
    }

    private boolean hasSomePhdProgramInformationBeanWithSameBeginDate(PhdProgramInformationBean bean) {
        for (PhdProgramInformation information : bean.getPhdProgram().getPhdProgramInformationsSet()) {
            if (this == information || !information.getBeginDate().equals((Object)bean.getBeginDate())) continue;
            return true;
        }
        return false;
    }

    public void edit(PhdProgramInformationBean phdProgramInformationBean) {
        Object object = advice$edit.perform((Callable)new PhdProgramInformation$callable$edit(this, phdProgramInformationBean));
    }

    static /* synthetic */ void advised$edit(PhdProgramInformation this_, PhdProgramInformationBean bean) {
        this_.checkParameters(bean);
        this_.setBeginDate(bean.getBeginDate());
        this_.setMinThesisEctsCredits(bean.getMinThesisEctsCredits());
        this_.setMaxThesisEctsCredits(bean.getMaxThesisEctsCredits());
        this_.setMinStudyPlanEctsCredits(bean.getMinStudyPlanEctsCredits());
        this_.setMaxStudyPlanEctsCredits(bean.getMaxStudyPlanEctsCredits());
        this_.setNumberOfYears(bean.getNumberOfYears());
        this_.setNumberOfSemesters(bean.getNumberOfSemesters());
    }

    public static PhdProgramInformation createInformation(PhdProgramInformationBean phdProgramInformationBean) {
        return (PhdProgramInformation)((Object)advice$createInformation.perform((Callable)new PhdProgramInformation$callable$createInformation(phdProgramInformationBean)));
    }

    static /* synthetic */ PhdProgramInformation advised$createInformation(PhdProgramInformationBean bean) {
        return new PhdProgramInformation(bean);
    }
}

