/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;

public class PhdProgramDocumentUploadBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private PhdIndividualProgramDocumentType type;
    private transient InputStream file;
    private byte[] fileContent;
    private String filename;
    private String remarks;
    private PhdIndividualProgramProcess individualProgramProcess;
    private boolean required = false;

    public PhdProgramDocumentUploadBean() {
    }

    public PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType type) {
        this.setType(type);
    }

    public byte[] getFileContent() {
        return this.fileContent;
    }

    public PhdIndividualProgramDocumentType getType() {
        return this.type;
    }

    public void setType(PhdIndividualProgramDocumentType type) {
        this.type = type;
    }

    public InputStream getFile() {
        return this.file;
    }

    public void setFile(InputStream file) {
        this.file = file;
        if (file != null) {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            try {
                ByteStreams.copy((InputStream)this.file, (OutputStream)result);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.fileContent = result.toByteArray();
        } else {
            this.fileContent = null;
        }
    }

    public void removeFile() {
        this.setFile(null);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean hasAnyInformation() {
        return this.type != null && !StringUtils.isEmpty((String)this.filename) && this.fileContent != null;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public PhdIndividualProgramProcess getIndividualProgramProcess() {
        return this.individualProgramProcess;
    }

    public void setIndividualProgramProcess(PhdIndividualProgramProcess individualProgramProcess) {
        this.individualProgramProcess = individualProgramProcess;
    }

    public boolean isRequired() {
        return this.required;
    }

    public PhdProgramDocumentUploadBean required() {
        this.required = !this.required;
        return this;
    }
}

