/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.mobility.outbound;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacy;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContest;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContestGroup;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyPeriod;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyPeriodConfirmationOption;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacySubmission$callable$apply;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacySubmission$callable$getOutboundMobilityCandidacySubmission;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacySubmission$callable$removeOption;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacySubmission$callable$selectOption;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacySubmission$callable$setGrade;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacySubmissionGrade;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacySubmission_Base;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class OutboundMobilityCandidacySubmission
extends OutboundMobilityCandidacySubmission_Base
implements Comparable<OutboundMobilityCandidacySubmission> {
    private static final BigDecimal AVG_FACTOR;
    private static final BigDecimal ECTS_FACTOR;
    private static final BigDecimal PENDING_ECTS_FACTOR;
    public static final Advice advice$apply;
    public static final Advice advice$getOutboundMobilityCandidacySubmission;
    public static final Advice advice$setGrade;
    public static final Advice advice$selectOption;
    public static final Advice advice$removeOption;

    public OutboundMobilityCandidacySubmission(OutboundMobilityCandidacyPeriod candidacyPeriod, Registration registration) {
        this.setRootDomainObject(Bennu.getInstance());
        this.setOutboundMobilityCandidacyPeriod(candidacyPeriod);
        this.setRegistration(registration);
    }

    public String getStatusString() {
        return "TODO";
    }

    public static void apply(OutboundMobilityCandidacyContest contest, Registration registration) {
        OutboundMobilityCandidacySubmission submission = OutboundMobilityCandidacySubmission.getOutboundMobilityCandidacySubmission(contest, registration);
        submission.apply(contest);
    }

    public void apply(OutboundMobilityCandidacyContest outboundMobilityCandidacyContest) {
        Object object = advice$apply.perform((Callable)new OutboundMobilityCandidacySubmission$callable$apply(this, outboundMobilityCandidacyContest));
    }

    static /* synthetic */ void advised$apply(OutboundMobilityCandidacySubmission this_, OutboundMobilityCandidacyContest contest) {
        for (OutboundMobilityCandidacy candidacy : this_.getOutboundMobilityCandidacySet()) {
            if (candidacy.getOutboundMobilityCandidacyContest() != contest) continue;
            return;
        }
        new OutboundMobilityCandidacy(contest, this_);
        OutboundMobilityCandidacyContestGroup mobilityGroup = contest.getOutboundMobilityCandidacyContestGroup();
        this_.setGrade(mobilityGroup, null);
    }

    private static OutboundMobilityCandidacySubmission getOutboundMobilityCandidacySubmission(OutboundMobilityCandidacyContest outboundMobilityCandidacyContest, Registration registration) {
        return (OutboundMobilityCandidacySubmission)advice$getOutboundMobilityCandidacySubmission.perform((Callable)new OutboundMobilityCandidacySubmission$callable$getOutboundMobilityCandidacySubmission(outboundMobilityCandidacyContest, registration));
    }

    static /* synthetic */ OutboundMobilityCandidacySubmission advised$getOutboundMobilityCandidacySubmission(OutboundMobilityCandidacyContest contest, Registration registration) {
        OutboundMobilityCandidacyPeriod candidacyPeriod = contest.getOutboundMobilityCandidacyPeriod();
        for (OutboundMobilityCandidacySubmission submission : registration.getOutboundMobilityCandidacySubmissionSet()) {
            if (submission.getOutboundMobilityCandidacyPeriod() != candidacyPeriod) continue;
            return submission;
        }
        return new OutboundMobilityCandidacySubmission(candidacyPeriod, registration);
    }

    public void delete() {
        for (OutboundMobilityCandidacySubmissionGrade grade : this.getOutboundMobilityCandidacySubmissionGradeSet()) {
            grade.delete();
        }
        this.setOutboundMobilityCandidacyPeriod(null);
        this.setRegistration(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public SortedSet<OutboundMobilityCandidacy> getSortedOutboundMobilityCandidacySet() {
        return new TreeSet<OutboundMobilityCandidacy>(this.getOutboundMobilityCandidacySet());
    }

    @Override
    public int compareTo(OutboundMobilityCandidacySubmission o) {
        int r = Registration.COMPARATOR_BY_NUMBER_AND_ID.compare((Object)this.getRegistration(), (Object)o.getRegistration());
        return r == 0 ? this.getExternalId().compareTo(o.getExternalId()) : r;
    }

    public SortedSet<OutboundMobilityCandidacyContestGroup> getOutboundMobilityCandidacyContestGroupSet() {
        TreeSet<OutboundMobilityCandidacyContestGroup> result = new TreeSet<OutboundMobilityCandidacyContestGroup>();
        for (OutboundMobilityCandidacy candidacy : this.getOutboundMobilityCandidacySet()) {
            OutboundMobilityCandidacyContest contest = candidacy.getOutboundMobilityCandidacyContest();
            result.add(contest.getOutboundMobilityCandidacyContestGroup());
        }
        return result;
    }

    public BigDecimal getGrade(OutboundMobilityCandidacyContestGroup mobilityGroup) {
        for (OutboundMobilityCandidacySubmissionGrade submissionGrade : this.getOutboundMobilityCandidacySubmissionGradeSet()) {
            if (submissionGrade.getOutboundMobilityCandidacyContestGroup() != mobilityGroup) continue;
            return submissionGrade.getGrade();
        }
        return null;
    }

    public BigDecimal getGradeForSerialization(OutboundMobilityCandidacyContestGroup mobilityGroup) {
        for (OutboundMobilityCandidacySubmissionGrade submissionGrade : this.getOutboundMobilityCandidacySubmissionGradeSet()) {
            if (submissionGrade.getOutboundMobilityCandidacyContestGroup() != mobilityGroup) continue;
            return submissionGrade.getGradeForSerialization();
        }
        return null;
    }

    public void setGrade(OutboundMobilityCandidacyContestGroup outboundMobilityCandidacyContestGroup, BigDecimal bigDecimal) {
        Object object = advice$setGrade.perform((Callable)new OutboundMobilityCandidacySubmission$callable$setGrade(this, outboundMobilityCandidacyContestGroup, bigDecimal));
    }

    static /* synthetic */ void advised$setGrade(OutboundMobilityCandidacySubmission this_, OutboundMobilityCandidacyContestGroup mobilityGroup, BigDecimal grade) {
        Calculator calculator = new Calculator(this_.getRegistration().getStudent(), grade);
        this_.setGrade(mobilityGroup, calculator.grade, calculator.gradeForSerialization);
    }

    private void setGrade(OutboundMobilityCandidacyContestGroup mobilityGroup, BigDecimal grade, BigDecimal gradeForSerialization) {
        for (OutboundMobilityCandidacySubmissionGrade submissionGrade : this.getOutboundMobilityCandidacySubmissionGradeSet()) {
            if (submissionGrade.getOutboundMobilityCandidacyContestGroup() != mobilityGroup) continue;
            submissionGrade.edit(grade, gradeForSerialization);
            return;
        }
        new OutboundMobilityCandidacySubmissionGrade(this, mobilityGroup, grade, gradeForSerialization);
    }

    public boolean hasConfirmedPlacement() {
        Boolean cp = this.getConfirmedPlacement();
        return cp != null && cp != false;
    }

    public void select() {
        if (this.getSelectedCandidacy() == null) {
            for (OutboundMobilityCandidacy candidacy : this.getSortedOutboundMobilityCandidacySet()) {
                if (!candidacy.getOutboundMobilityCandidacyContest().hasVacancy()) continue;
                candidacy.select();
                return;
            }
        }
    }

    public boolean hasContestInGroup(OutboundMobilityCandidacyContestGroup mobilityGroup) {
        for (OutboundMobilityCandidacy candidacy : this.getOutboundMobilityCandidacySet()) {
            OutboundMobilityCandidacyContest contest = candidacy.getOutboundMobilityCandidacyContest();
            if (contest.getOutboundMobilityCandidacyContestGroup() != mobilityGroup) continue;
            return true;
        }
        return false;
    }

    public void selectOption(OutboundMobilityCandidacyPeriodConfirmationOption outboundMobilityCandidacyPeriodConfirmationOption) {
        Object object = advice$selectOption.perform((Callable)new OutboundMobilityCandidacySubmission$callable$selectOption(this, outboundMobilityCandidacyPeriodConfirmationOption));
    }

    static /* synthetic */ void advised$selectOption(OutboundMobilityCandidacySubmission this_, OutboundMobilityCandidacyPeriodConfirmationOption option) {
        this_.setConfirmationOption(option);
        this_.setConfirmedPlacement(Boolean.TRUE);
    }

    public void removeOption(OutboundMobilityCandidacyPeriodConfirmationOption outboundMobilityCandidacyPeriodConfirmationOption) {
        Object object = advice$removeOption.perform((Callable)new OutboundMobilityCandidacySubmission$callable$removeOption(this, outboundMobilityCandidacyPeriodConfirmationOption));
    }

    static /* synthetic */ void advised$removeOption(OutboundMobilityCandidacySubmission this_, OutboundMobilityCandidacyPeriodConfirmationOption option) {
        if (this_.getConfirmationOption() == option) {
            this_.setConfirmationOption(null);
            this_.setConfirmedPlacement(Boolean.FALSE);
        }
    }

    static {
        advice$apply = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$getOutboundMobilityCandidacySubmission = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$setGrade = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$selectOption = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$removeOption = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        AVG_FACTOR = new BigDecimal(1000000000000L);
        ECTS_FACTOR = new BigDecimal(100000000L);
        PENDING_ECTS_FACTOR = new BigDecimal(10000L);
    }

    public static class Calculator {
        public BigDecimal possibleECTS = BigDecimal.ZERO;
        public BigDecimal enrolledECTS = BigDecimal.ZERO;
        public BigDecimal completedECTS = BigDecimal.ZERO;
        public BigDecimal completedECTSCycle1 = BigDecimal.ZERO;
        public BigDecimal completedECTSCycle2 = BigDecimal.ZERO;
        public BigDecimal factoredGradeSum = BigDecimal.ZERO;
        public BigDecimal factoredGradeSumCycle1 = BigDecimal.ZERO;
        public BigDecimal factoredGradeSumCycle2 = BigDecimal.ZERO;
        public BigDecimal factoredECTS = BigDecimal.ZERO;
        public BigDecimal factoredECTSCycle1 = BigDecimal.ZERO;
        public BigDecimal factoredECTSCycle2 = BigDecimal.ZERO;
        public BigDecimal grade;
        public BigDecimal gradeForSerialization;

        public Calculator(Student student) {
            this(student, null);
        }

        private Calculator(Student student, BigDecimal grade) {
            for (Registration registration : student.getRegistrationsSet()) {
                if (registration.getDegree() != null && registration.getDegree().getEctsCredits() != null) {
                    this.possibleECTS = this.possibleECTS.add(new BigDecimal(registration.getDegree().getEctsCredits()));
                }
                for (StudentCurricularPlan studentCurricularPlan : registration.getStudentCurricularPlansSet()) {
                    this.calculateGrade(null, (CurriculumModule)((Object)studentCurricularPlan.getRoot()));
                }
            }
            if (this.completedECTSCycle1.doubleValue() >= 120.0) {
                BigDecimal d;
                BigDecimal gradeForElimination;
                BigDecimal bigDecimal = gradeForElimination = this.factoredECTS.doubleValue() > 0.0 ? this.factoredGradeSum.divide(this.factoredECTS, 2, RoundingMode.HALF_EVEN) : BigDecimal.ZERO;
                if (gradeForElimination.doubleValue() >= 12.5 && (d = this.factoredECTSCycle1.add(this.factoredECTSCycle2)).doubleValue() > 0.0) {
                    this.grade = grade != null ? grade : this.factoredGradeSumCycle1.add(this.factoredGradeSumCycle2).divide(d, 2, RoundingMode.HALF_EVEN).multiply(new BigDecimal(5));
                    this.gradeForSerialization = this.grade.multiply(AVG_FACTOR).add(this.completedECTS.multiply(ECTS_FACTOR)).add(new BigDecimal(9999).subtract(this.possibleECTS).add(this.completedECTS).multiply(PENDING_ECTS_FACTOR)).add(this.completedECTS.divide(this.enrolledECTS, 4, RoundingMode.HALF_EVEN).multiply(new BigDecimal(10000)));
                    return;
                }
            }
            if (grade != null) {
                this.grade = grade;
                this.gradeForSerialization = this.grade.multiply(AVG_FACTOR).add(this.completedECTS.multiply(ECTS_FACTOR)).add(new BigDecimal(9999).subtract(this.possibleECTS).add(this.completedECTS).multiply(PENDING_ECTS_FACTOR));
            } else {
                this.grade = BigDecimal.ZERO;
                this.gradeForSerialization = BigDecimal.ZERO;
            }
        }

        private void calculateGrade(CycleType cycleType, CurriculumModule module) {
            block5: {
                block4: {
                    BigDecimal value;
                    BigDecimal weigth;
                    block6: {
                        if (!module.isLeaf()) break block4;
                        if (!module.isEnrolment()) break block5;
                        Enrolment enrolment = (Enrolment)((Object)module);
                        weigth = enrolment.getWeigthForCurriculum();
                        this.enrolledECTS = this.enrolledECTS.add(weigth);
                        if (!enrolment.isApproved()) break block5;
                        this.completedECTS = this.completedECTS.add(weigth);
                        if (cycleType == CycleType.FIRST_CYCLE) {
                            this.completedECTSCycle1 = this.completedECTSCycle1.add(weigth);
                        } else if (cycleType == CycleType.SECOND_CYCLE) {
                            this.completedECTSCycle2 = this.completedECTSCycle2.add(weigth);
                        }
                        Grade grade = enrolment.getGrade();
                        if (!grade.isNumeric()) break block5;
                        value = grade.getNumericValue();
                        this.factoredECTS = this.factoredECTS.add(weigth);
                        this.factoredGradeSum = this.factoredGradeSum.add(value.multiply(weigth));
                        if (cycleType != CycleType.FIRST_CYCLE) break block6;
                        this.factoredECTSCycle1 = this.factoredECTSCycle1.add(weigth);
                        this.factoredGradeSumCycle1 = this.factoredGradeSumCycle1.add(value.multiply(weigth));
                        break block5;
                    }
                    if (cycleType != CycleType.SECOND_CYCLE) break block5;
                    this.factoredECTSCycle2 = this.factoredECTSCycle2.add(weigth);
                    this.factoredGradeSumCycle2 = this.factoredGradeSumCycle2.add(value.multiply(weigth));
                    break block5;
                }
                CurriculumGroup group = (CurriculumGroup)((Object)module);
                CycleType cycleForChild = group.isCycleCurriculumGroup() ? ((CycleCurriculumGroup)((Object)group)).getCycleType() : cycleType;
                for (CurriculumModule child : group.getCurriculumModulesSet()) {
                    this.calculateGrade(cycleForChild, child);
                }
            }
        }

        public BigDecimal getCompletedEctsFirstAndSecondCycle() {
            return this.completedECTSCycle1.add(this.completedECTSCycle2);
        }

        public BigDecimal getEctsAverage() {
            BigDecimal d = this.factoredECTS;
            return d.doubleValue() > 0.0 ? this.factoredGradeSum.divide(d, 2, RoundingMode.HALF_EVEN) : BigDecimal.ZERO;
        }

        public BigDecimal getPendingEcts() {
            BigDecimal result = this.possibleECTS.subtract(this.completedECTS);
            return result.signum() == 1 ? result : BigDecimal.ZERO;
        }

        public BigDecimal getEctsEverateFirstAndSecondCycle() {
            BigDecimal d = this.factoredECTSCycle1.add(this.factoredECTSCycle2);
            return d.doubleValue() > 0.0 ? this.factoredGradeSumCycle1.add(this.factoredGradeSumCycle2).divide(d, 2, RoundingMode.HALF_EVEN) : BigDecimal.ZERO;
        }
    }
}

