/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.caseHandling;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.caseHandling.ProcessLog;
import org.fenixedu.academic.domain.caseHandling.Process_Base;
import org.fenixedu.academic.domain.caseHandling.StartActivity;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.dml.DomainClass;

public abstract class Process
extends Process_Base
implements Comparable<Process> {
    private static final Logger logger = LoggerFactory.getLogger(Process.class);
    private static Map<String, Activity<? extends Process>> startActivities;
    private static final Object lock;

    private static void load() {
        startActivities = new HashMap<String, Activity<? extends Process>>();
        Collection domainClasses = FenixFramework.getDomainModel().getDomainClasses();
        for (DomainClass domainClass : domainClasses) {
            try {
                Activity<? extends Process> activity;
                Class<?> clazz = Class.forName(domainClass.getFullName());
                if (!Process.class.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers()) || (activity = Process.getStartActivity(clazz)) == null) continue;
                startActivities.put(domainClass.getFullName(), activity);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static Activity<? extends Process> getStartActivity(Class<? extends Process> process2) throws InstantiationException, IllegalAccessException {
        for (Class<?> clazz : process2.getDeclaredClasses()) {
            if (!Activity.class.isAssignableFrom(clazz) || !clazz.isAnnotationPresent(StartActivity.class)) continue;
            return (Activity)clazz.newInstance();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Activity<?> getStartActivity(String processName) {
        Object object = lock;
        synchronized (object) {
            if (startActivities == null) {
                Process.load();
            }
        }
        Activity<? extends Process> activity = startActivities.get(processName);
        if (activity == null) {
            throw new RuntimeException("can't find process " + processName);
        }
        return activity;
    }

    public static <T extends Process> T createNewProcess(User userView, Class<? extends Process> processClass, Object object) {
        try {
            return Process.getStartActivity(processClass).execute(null, userView, object);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Process> T createNewProcess(User userView, String processName, Object object) {
        return Process.getStartActivity(processName).execute(null, userView, object);
    }

    public abstract List<Activity> getActivities();

    public Process() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public final Process executeActivity(User userView, String activityId, Object object) {
        Activity activity = this.getActivity(activityId);
        return activity.execute(this, userView, object);
    }

    private Activity getActivity(String activityId) {
        for (Activity activity : this.getActivities()) {
            if (!activity.getId().equals(activityId)) continue;
            return activity;
        }
        return null;
    }

    public Activity getActivity(Class<? extends Activity> clazz) {
        return this.getActivity(clazz.getSimpleName());
    }

    @Override
    public int compareTo(Process process2) {
        return this.getExternalId().compareTo(process2.getExternalId());
    }

    public List<Activity> getAllowedActivities(User userView) {
        ArrayList<Activity> result = new ArrayList<Activity>();
        for (Activity activity : this.getActivities()) {
            try {
                activity.checkPreConditions(this, userView);
                result.add(activity);
            }
            catch (PreConditionNotValidException preConditionNotValidException) {}
        }
        return result;
    }

    public ProcessLog getLastProcessLog() {
        return Collections.max(this.getProcessLogsSet(), ProcessLog.COMPARATOR_BY_WHEN);
    }

    public DateTime getWhenCreated() {
        return Collections.min(this.getProcessLogsSet(), ProcessLog.COMPARATOR_BY_WHEN).getWhenDateTime();
    }

    public DateTime getWhenUpdated() {
        return Collections.max(this.getProcessLogsSet(), ProcessLog.COMPARATOR_BY_WHEN).getWhenDateTime();
    }

    public String getCreatedBy() {
        return Collections.min(this.getProcessLogsSet(), ProcessLog.COMPARATOR_BY_WHEN).getUserName();
    }

    public String getUpdatedBy() {
        return Collections.max(this.getProcessLogsSet(), ProcessLog.COMPARATOR_BY_WHEN).getUserName();
    }

    protected DateTime getLastExecutionDateOf(Class<? extends Activity> clazz) {
        SortedSet<ProcessLog> logs = this.getSortedProcessLogs(clazz);
        return logs.isEmpty() ? null : logs.last().getWhenDateTime();
    }

    protected SortedSet<ProcessLog> getSortedProcessLogs(Class<? extends Activity> clazz) {
        TreeSet<ProcessLog> logs = new TreeSet<ProcessLog>(ProcessLog.COMPARATOR_BY_WHEN);
        for (ProcessLog log : this.getProcessLogsSet()) {
            if (!log.isFor(clazz)) continue;
            logs.add(log);
        }
        return logs;
    }

    public abstract boolean canExecuteActivity(User var1);

    public abstract String getDisplayName();

    static {
        lock = new Object();
    }
}

