/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.over23;

import java.util.Comparator;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23IndividualCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23IndividualCandidacyDegreeEntry_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;

public class Over23IndividualCandidacyDegreeEntry
extends Over23IndividualCandidacyDegreeEntry_Base {
    static Comparator<Over23IndividualCandidacyDegreeEntry> COMPARATOR_BY_ORDER = new Comparator<Over23IndividualCandidacyDegreeEntry>(){

        @Override
        public int compare(Over23IndividualCandidacyDegreeEntry o1, Over23IndividualCandidacyDegreeEntry o2) {
            return o1.getDegreeOrder().compareTo(o2.getDegreeOrder());
        }
    };

    private Over23IndividualCandidacyDegreeEntry() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    Over23IndividualCandidacyDegreeEntry(Over23IndividualCandidacy candidacy, Degree degree, int order) {
        this();
        this.checkParameters(candidacy, degree);
        this.checkOrder(candidacy, degree, order);
        super.setOver23IndividualCandidacy(candidacy);
        super.setDegree(degree);
        super.setDegreeOrder(Integer.valueOf(order));
    }

    private void checkParameters(Over23IndividualCandidacy candidacy, Degree degree) {
        if (candidacy == null) {
            throw new DomainException("error.Over23IndividualCandidacyDegreeEntry.invalid.candidacy", new String[0]);
        }
        if (degree == null) {
            throw new DomainException("error.Over23IndividualCandidacyDegreeEntry.invalid.degree", new String[0]);
        }
    }

    private void checkOrder(Over23IndividualCandidacy candidacy, Degree degree, int order) {
        for (Over23IndividualCandidacyDegreeEntry entry : candidacy.getOver23IndividualCandidacyDegreeEntriesSet()) {
            if (!entry.isFor(degree) || !entry.hasDegreeOrder(order)) continue;
            throw new DomainException("error.Over23IndividualCandidacyDegreeEntry.found.duplicated.order", new String[0]);
        }
    }

    public boolean isFor(Degree degree) {
        return this.getDegree().equals(degree);
    }

    public boolean hasDegreeOrder(int order) {
        return this.getDegreeOrder() == order;
    }

    void delete() {
        this.setDegree(null);
        this.setOver23IndividualCandidacy(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }
}

