/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events;

import org.fenixedu.academic.domain.accounting.events.PenaltyExemption;
import org.fenixedu.academic.domain.accounting.events.PenaltyExemptionJustification;
import org.fenixedu.academic.domain.accounting.events.PenaltyExemptionJustificationType;
import org.fenixedu.academic.domain.accounting.events.penaltyExemptionJustifications.PenaltyExemptionJustificationByDispatch;
import org.joda.time.YearMonthDay;

public class PenaltyExemptionJustificationFactory {
    public static PenaltyExemptionJustification create(PenaltyExemption penaltyExemption, PenaltyExemptionJustificationType justificationType, String reason, YearMonthDay dispatchDate) {
        switch (justificationType) {
            case SOCIAL_SHARE_GRANT_OWNER: 
            case ENROLMENT_AFTER_EQUIVALENCE: 
            case SEPARATION_CYCLES_AUTHORIZATION: {
                return new PenaltyExemptionJustification(penaltyExemption, justificationType, reason);
            }
            case DIRECTIVE_COUNCIL_AUTHORIZATION: 
            case NUCLEUS_COORDINATOR_AUTHORIZATION: {
                return new PenaltyExemptionJustificationByDispatch(penaltyExemption, justificationType, reason, dispatchDate);
            }
        }
        throw new RuntimeException("Unknown justification type");
    }
}

