/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.candidacy.Candidacy;
import org.fenixedu.academic.domain.candidacy.CandidacySituationType;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.GroupStrategy;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

@GroupOperator(value="candidate")
public class CandidateGroup
extends GroupStrategy {
    public String getPresentationName() {
        return BundleUtil.getString((String)"resources.GroupNameResources", (String)"label.name.CandidateGroup", (String[])new String[0]);
    }

    public Set<User> getMembers() {
        return Bennu.getInstance().getCandidaciesSet().stream().filter(candidacy -> {
            CandidacySituationType situation = candidacy.getActiveCandidacySituationType();
            return situation != null && situation.isActive() && !situation.equals((Object)CandidacySituationType.REGISTERED);
        }).map(candidacy -> candidacy.getPerson().getUser()).collect(Collectors.toSet());
    }

    public Set<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public boolean isMember(User user) {
        return user != null && user.getPerson() != null && this.hasActiveCandidacies(user.getPerson());
    }

    private boolean hasActiveCandidacies(Person person) {
        for (Candidacy candidacy : person.getCandidaciesSet()) {
            CandidacySituationType situation = candidacy.getActiveCandidacySituationType();
            if (situation == null || !situation.isActive() || situation.equals((Object)CandidacySituationType.REGISTERED) || situation.equals((Object)CandidacySituationType.ADMITTED)) continue;
            return true;
        }
        return false;
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }
}

