/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.PersonInformationLog;
import org.fenixedu.academic.domain.PhotoState;
import org.fenixedu.academic.domain.PhotoType;
import org.fenixedu.academic.domain.Photograph$callable$cancelSubmission;
import org.fenixedu.academic.domain.Photograph_Base;
import org.fenixedu.academic.domain.photograph.AspectRatio;
import org.fenixedu.academic.domain.photograph.Picture;
import org.fenixedu.academic.domain.photograph.PictureMode;
import org.fenixedu.academic.domain.photograph.PictureOriginal;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.ReplyTo;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.domain.util.email.SystemSender;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.util.ContentType;
import org.fenixedu.bennu.core.domain.Avatar;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.UserGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.imgscalr.Scalr;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Photograph
extends Photograph_Base
implements Comparable<Photograph> {
    private static final String REJECTION_MAIL_SUBJECT_KEY = "photo.email.subject.rejection";
    private static final String REJECTION_MAIL_BODY_KEY = "photo.email.body.rejection";
    public static final Advice advice$cancelSubmission = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    private Photograph() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setSubmission(new DateTime());
    }

    public Photograph(PhotoType photoType, ContentType contentType, byte[] original) {
        this();
        this.setPhotoType(photoType);
        new PictureOriginal(this, original, contentType);
    }

    public Person getPerson() {
        if (super.getPerson() != null) {
            return super.getPerson();
        }
        if (this.getNext() != null) {
            return this.getNext().getPerson();
        }
        return null;
    }

    public void setPhotoType(PhotoType photoType) {
        super.setPhotoType(photoType);
        if (photoType == PhotoType.INSTITUTIONAL) {
            this.setState(PhotoState.APPROVED);
        } else if (photoType == PhotoType.USER) {
            this.setState(PhotoState.PENDING);
        } else {
            this.setState(PhotoState.PENDING);
        }
    }

    public void setState(PhotoState state) {
        if (this.getState() != state) {
            Person person;
            super.setState(state);
            this.setStateChange(new DateTime());
            if (state == PhotoState.PENDING) {
                this.setPendingHolder(Bennu.getInstance());
            } else {
                this.setPendingHolder(null);
            }
            if (state == PhotoState.REJECTED) {
                this.logState("log.personInformation.photo.rejected");
                person = AccessControl.getPerson();
                if (person != null) {
                    this.setRejector(person);
                }
                SystemSender systemSender = this.getRootDomainObject().getSystemSender();
                new Message((Sender)((Object)systemSender), (Collection<? extends ReplyTo>)systemSender.getConcreteReplyTos(), new Recipient(UserGroup.of((User[])new User[]{this.getPerson().getUser()})).asCollection(), BundleUtil.getString((String)"resources.PersonalInformationResources", (String)REJECTION_MAIL_SUBJECT_KEY, (String[])new String[0]), BundleUtil.getString((String)"resources.PersonalInformationResources", (String)REJECTION_MAIL_BODY_KEY, (String[])new String[0]), "");
            }
            if (state == PhotoState.APPROVED) {
                person = AccessControl.getPerson();
                if (person != null) {
                    this.setApprover(person);
                }
                if (this.getPhotoType() != PhotoType.INSTITUTIONAL) {
                    this.logState("log.personInformation.photo.approved");
                }
            }
        }
    }

    public void setPrevious(Photograph previous) {
        if (previous.getState() == PhotoState.PENDING) {
            previous.setState(PhotoState.USER_REJECTED);
        }
        super.setPrevious(previous);
    }

    public void cancelSubmission() {
        Object object = advice$cancelSubmission.perform((Callable)new Photograph$callable$cancelSubmission(this));
    }

    static /* synthetic */ void advised$cancelSubmission(Photograph this_) {
        if (this_.getState() == PhotoState.PENDING) {
            this_.setState(PhotoState.USER_REJECTED);
            this_.logState("log.personInformation.photo.canceled");
        }
    }

    public void delete() {
        Photograph next;
        this.setRootDomainObject(null);
        if (this.getPendingHolder() != null) {
            this.setPendingHolder(null);
        }
        this.setPerson(null);
        Photograph prev = this.getPrevious();
        if (prev != null) {
            this.setPrevious(null);
            prev.delete();
        }
        if ((next = this.getNext()) != null) {
            this.setNext(null);
        }
        super.deleteDomainObject();
    }

    public byte[] getDefaultAvatar() {
        return this.getCustomAvatar(1, 1, 100, 100, PictureMode.FIT);
    }

    private BufferedImage read(PictureOriginal original) {
        BufferedImage image = Picture.readImage(original.getPictureData());
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        result.createGraphics().drawImage(image, 0, 0, Color.WHITE, null);
        return result;
    }

    public byte[] getCustomAvatar(int xRatio, int yRatio, int width, int height, PictureMode pictureMode) {
        PictureOriginal original = this.getOriginal();
        BufferedImage image = original.getPictureFileFormat() == ContentType.JPG ? Picture.readImage(original.getPictureData()) : this.read(original);
        return Photograph.processImage(image, xRatio, yRatio, width, height, pictureMode);
    }

    public byte[] getCustomAvatar(AspectRatio aspectRatio, int width, int height, PictureMode pictureMode) {
        return this.getCustomAvatar(aspectRatio.getXRatio(), aspectRatio.getYRatio(), width, height, pictureMode);
    }

    public byte[] getCustomAvatar(int width, int height, PictureMode pictureMode) {
        return this.getCustomAvatar(width, height, width, height, pictureMode);
    }

    @Override
    public int compareTo(Photograph photo) {
        return this.getSubmission().compareTo((ReadableInstant)photo.getSubmission());
    }

    public void logCreate(Person person) {
        if (this.getState() == PhotoState.PENDING) {
            this.logState("log.personInformation.photo.created");
        } else if (this.getState() == PhotoState.APPROVED) {
            if (this.getPhotoType() == PhotoType.INSTITUTIONAL) {
                this.logState("log.personInformation.photo.created.noValidation");
            } else {
                this.logState("log.personInformation.photo.approved");
            }
        }
    }

    private void logState(String keyLabel) {
        String personViewed = PersonInformationLog.getPersonNameForLogDescription(this.getPerson());
        PersonInformationLog.createLog(this.getPerson(), "resources.MessagingResources", keyLabel, personViewed);
    }

    public byte[] exportAsJPEG(byte[] photo, Color color) {
        BufferedImage image = Picture.readImage(photo);
        BufferedImage jpeg = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        jpeg.createGraphics().drawImage(image, 0, 0, color, null);
        return Picture.writeImage(jpeg, ContentType.JPG);
    }

    public byte[] exportAsJPEG(byte[] photo) {
        return this.exportAsJPEG(photo, Color.WHITE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] mysteryManPhoto(int xRatio, int yRatio, int width, int height, PictureMode pictureMode) {
        try (InputStream mm = Photograph.class.getClassLoader().getResourceAsStream("META-INF/resources/img/mysteryman.png");){
            byte[] byArray = Avatar.process((InputStream)mm, (String)"image/png", (int)width);
            return byArray;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static byte[] processImage(BufferedImage image, int xRatio, int yRatio, int width, int height, PictureMode pictureMode) {
        BufferedImage transformed;
        switch (pictureMode) {
            case FIT: {
                transformed = Picture.transformFit(image, xRatio, yRatio);
                break;
            }
            case ZOOM: {
                transformed = Picture.transformZoom(image, xRatio, yRatio);
                break;
            }
            default: {
                transformed = Picture.transformFit(image, xRatio, yRatio);
            }
        }
        BufferedImage scaled = Scalr.resize((BufferedImage)transformed, (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]);
        return Picture.writeImage(scaled, ContentType.PNG);
    }
}

