/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.NonAffiliatedTeacher$callable$associateToInstitutionAndExecutionCourse;
import org.fenixedu.academic.domain.NonAffiliatedTeacher$callable$removeExecutionCourse;
import org.fenixedu.academic.domain.NonAffiliatedTeacher_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class NonAffiliatedTeacher
extends NonAffiliatedTeacher_Base {
    public static final Advice advice$associateToInstitutionAndExecutionCourse = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$removeExecutionCourse = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public NonAffiliatedTeacher() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public NonAffiliatedTeacher(String name, Unit institution) {
        this();
        this.setName(name);
        this.setInstitutionUnit(institution);
    }

    public static Set<NonAffiliatedTeacher> findNonAffiliatedTeacherByName(String name) {
        Pattern pattern = Pattern.compile(name.toLowerCase());
        HashSet<NonAffiliatedTeacher> nonAffiliatedTeachers = new HashSet<NonAffiliatedTeacher>();
        for (NonAffiliatedTeacher nonAffiliatedTeacher : Bennu.getInstance().getNonAffiliatedTeachersSet()) {
            Matcher matcher = pattern.matcher(nonAffiliatedTeacher.getName().toLowerCase());
            if (!matcher.find()) continue;
            nonAffiliatedTeachers.add(nonAffiliatedTeacher);
        }
        return nonAffiliatedTeachers;
    }

    public static void associateToInstitutionAndExecutionCourse(String string, Unit unit, ExecutionCourse executionCourse) {
        Object object = advice$associateToInstitutionAndExecutionCourse.perform((Callable)new NonAffiliatedTeacher$callable$associateToInstitutionAndExecutionCourse(string, unit, executionCourse));
    }

    static /* synthetic */ void advised$associateToInstitutionAndExecutionCourse(String nonAffiliatedTeacherName, Unit institution, ExecutionCourse executionCourse) {
        NonAffiliatedTeacher nonAffiliatedTeacher = institution.findNonAffiliatedTeacherByName(nonAffiliatedTeacherName);
        if (nonAffiliatedTeacher == null) {
            nonAffiliatedTeacher = new NonAffiliatedTeacher(nonAffiliatedTeacherName, institution);
        }
        if (nonAffiliatedTeacher.getExecutionCoursesSet().contains((Object)executionCourse)) {
            throw new DomainException("error.invalid.executionCourse", new String[0]);
        }
        nonAffiliatedTeacher.addExecutionCourses(executionCourse);
    }

    public void removeExecutionCourse(ExecutionCourse executionCourse) {
        Object object = advice$removeExecutionCourse.perform((Callable)new NonAffiliatedTeacher$callable$removeExecutionCourse(this, executionCourse));
    }

    static /* synthetic */ void advised$removeExecutionCourse(NonAffiliatedTeacher this_, ExecutionCourse executionCourse) {
        this_.getExecutionCoursesSet().remove((Object)executionCourse);
    }

    public void delete() {
        this.setRootDomainObject(null);
        this.setInstitutionUnit(null);
        this.getExecutionCoursesSet().clear();
        super.deleteDomainObject();
    }
}

