/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.candidacy;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgramCandidacyProcessState;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;
import org.fenixedu.academic.domain.phd.PhdProgramProcessDocument;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcess;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcessStateBean;
import org.fenixedu.academic.domain.phd.candidacy.activities.DeleteCandidacyReview;
import org.fenixedu.academic.domain.phd.candidacy.activities.RejectCandidacyProcess;
import org.fenixedu.academic.domain.phd.candidacy.activities.RequestRatifyCandidacy;
import org.fenixedu.academic.domain.phd.candidacy.activities.UploadCandidacyReview;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackRequestProcess;
import org.fenixedu.academic.service.services.caseHandling.ExecuteProcessActivity;
import org.fenixedu.academic.ui.struts.action.phd.PhdDocumentsZip;
import org.fenixedu.academic.ui.struts.action.phd.PhdProcessDA;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public abstract class CommonPhdCandidacyDA
extends PhdProcessDA {
    protected PhdProgramCandidacyProcess getProcess(HttpServletRequest request) {
        return (PhdProgramCandidacyProcess)((Object)super.getProcess(request));
    }

    public ActionForward viewIndividualProgramProcess(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return this.viewIndividualProgramProcess(request, this.getProcess(request));
    }

    protected ActionForward viewIndividualProgramProcess(HttpServletRequest request, PhdProgramCandidacyProcess process2) {
        return this.redirect(String.format("/phdIndividualProgramProcess.do?method=viewProcess&processId=%s", process2.getIndividualProgramProcess().getExternalId()), request);
    }

    public ActionForward manageCandidacyDocuments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("manageCandidacyDocuments");
    }

    public ActionForward manageCandidacyReview(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramDocumentUploadBean bean = new PhdProgramDocumentUploadBean();
        bean.setType(PhdIndividualProgramDocumentType.CANDIDACY_REVIEW);
        PhdProgramCandidacyProcessStateBean stateBean = new PhdProgramCandidacyProcessStateBean(this.getProcess(request).getIndividualProgramProcess());
        stateBean.setState(PhdProgramCandidacyProcessState.WAITING_FOR_SCIENTIFIC_COUNCIL_RATIFICATION);
        request.setAttribute("documentToUpload", (Object)bean);
        request.setAttribute("stateBean", (Object)stateBean);
        return mapping.findForward("manageCandidacyReview");
    }

    public ActionForward manageCandidacyReviewPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramDocumentUploadBean bean = new PhdProgramDocumentUploadBean();
        bean.setType(PhdIndividualProgramDocumentType.CANDIDACY_REVIEW);
        request.setAttribute("documentToUpload", (Object)bean);
        request.setAttribute("stateBean", this.getRenderedObject("stateBean"));
        RenderUtils.invalidateViewState();
        return mapping.findForward("manageCandidacyReview");
    }

    public ActionForward uploadCandidacyReviewInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("documentToUpload", this.getRenderedObject("documentToUpload"));
        request.setAttribute("stateBean", this.getRenderedObject("stateBean"));
        RenderUtils.invalidateViewState();
        return mapping.findForward("manageCandidacyReview");
    }

    public ActionForward uploadCandidacyReview(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramDocumentUploadBean bean = (PhdProgramDocumentUploadBean)this.getRenderedObject("documentToUpload");
        if (!bean.hasAnyInformation()) {
            return this.uploadCandidacyReviewInvalid(mapping, actionForm, request, response);
        }
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), UploadCandidacyReview.class, Collections.singletonList(bean));
            this.addSuccessMessage(request, "message.document.uploaded.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            bean.setFile(null);
            return this.uploadCandidacyReviewInvalid(mapping, actionForm, request, response);
        }
        RenderUtils.invalidateViewState();
        return this.manageCandidacyReview(mapping, actionForm, request, response);
    }

    public ActionForward prepareRejectCandidacyProcess(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessStateBean stateBean = new PhdProgramCandidacyProcessStateBean(this.getProcess(request).getIndividualProgramProcess());
        request.setAttribute("stateBean", (Object)stateBean);
        return mapping.findForward("rejectCandidacyProcess");
    }

    public ActionForward prepareRejectCandidacyProcessPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessStateBean bean = (PhdProgramCandidacyProcessStateBean)this.getRenderedObject("stateBean");
        request.setAttribute("stateBean", (Object)bean);
        return mapping.findForward("rejectCandidacyProcess");
    }

    public ActionForward rejectCandidacyProcess(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            PhdProgramCandidacyProcessStateBean bean = (PhdProgramCandidacyProcessStateBean)this.getRenderedObject("stateBean");
            bean.setState(PhdProgramCandidacyProcessState.REJECTED);
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), RejectCandidacyProcess.class, (Object)bean);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.rejectCandidacyProcessInvalid(mapping, actionForm, request, response);
        }
        return this.viewIndividualProgramProcess(request, this.getProcess(request));
    }

    public ActionForward rejectCandidacyProcessInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessStateBean bean = (PhdProgramCandidacyProcessStateBean)this.getRenderedObject("stateBean");
        request.setAttribute("stateBean", (Object)bean);
        return mapping.findForward("rejectCandidacyProcess");
    }

    public ActionForward requestRatifyCandidacy(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            PhdProgramCandidacyProcess process2 = this.getProcess(request);
            ExecuteProcessActivity.run((Process)((Object)process2), RequestRatifyCandidacy.class, this.getRenderedObject("stateBean"));
            return this.viewIndividualProgramProcess(request, process2);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.uploadCandidacyReviewInvalid(mapping, actionForm, request, response);
        }
    }

    public ActionForward deleteCandidacyReview(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), DeleteCandidacyReview.class, (Object)this.getDocument(request));
            this.addSuccessMessage(request, "message.document.deleted.successfuly", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
        }
        return this.manageCandidacyReview(mapping, actionForm, request, response);
    }

    protected PhdProgramProcessDocument getDocument(HttpServletRequest request) {
        return (PhdProgramProcessDocument)((Object)this.getDomainObject(request, "documentId"));
    }

    public ActionForward downloadCandidacyDocuments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.writeFile(response, this.getCandidacyDocumentsFilename(request), PhdDocumentsZip.ZIP_MIME_TYPE, this.createZip(request));
        return null;
    }

    private String getCandidacyDocumentsFilename(HttpServletRequest request) {
        PhdIndividualProgramProcess process2 = this.getProcess(request).getIndividualProgramProcess();
        return String.format("%s-%s.zip", process2.getProcessNumber().replace("/", "-"), this.getMessageFromResource("label.phd.manageCandidacyDocuments", new String[0]).replace(" ", "_"));
    }

    public ActionForward prepareUploadCandidacyFeedback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Person person = this.getLoggedPerson(request);
        PhdCandidacyFeedbackRequestProcess feedbackRequest = this.getProcess(request).getFeedbackRequest();
        PhdProgramDocumentUploadBean bean = new PhdProgramDocumentUploadBean();
        bean.setType(PhdIndividualProgramDocumentType.CANDIDACY_FEEDBACK_DOCUMENT);
        request.setAttribute("documentBean", (Object)bean);
        request.setAttribute("canUploadDocuments", (Object)feedbackRequest.canUploadDocuments());
        request.setAttribute("sharedDocuments", feedbackRequest.getSharedDocumentsContent());
        request.setAttribute("lastFeedbackDocument", (Object)feedbackRequest.getElement(person).getLastFeedbackDocument());
        return mapping.findForward("uploadCandidacyFeedback");
    }

    public ActionForward prepareUploadCandidacyFeedbackInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Person person = this.getLoggedPerson(request);
        PhdCandidacyFeedbackRequestProcess feedbackRequest = this.getProcess(request).getFeedbackRequest();
        request.setAttribute("documentBean", this.getRenderedObject("documentBean"));
        request.setAttribute("canUploadDocuments", (Object)feedbackRequest.canUploadDocuments());
        request.setAttribute("sharedDocuments", feedbackRequest.getSharedDocumentsContent());
        request.setAttribute("lastFeedbackDocument", (Object)feedbackRequest.getElement(person).getLastFeedbackDocument());
        return mapping.findForward("uploadCandidacyFeedback");
    }

    public ActionForward uploadCandidacyFeedback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request).getFeedbackRequest()), PhdCandidacyFeedbackRequestProcess.UploadCandidacyFeedback.class, this.getRenderedObject("documentBean"));
            this.addSuccessMessage(request, "message.phd.candidacy.feedback.document.uploaded.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            return this.prepareUploadCandidacyFeedbackInvalid(mapping, actionForm, request, response);
        }
        return this.viewIndividualProgramProcess(request, this.getProcess(request));
    }

    public ActionForward candidacyFeedbackDocumentsDownload(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        Set<PhdProgramProcessDocument> documents = process2.getFeedbackRequest().getSharedDocumentsContent();
        if (!documents.isEmpty()) {
            this.writeFile(response, this.getZipDocumentsFilename(process2.getIndividualProgramProcess()), PhdDocumentsZip.ZIP_MIME_TYPE, this.createZip(documents));
            return null;
        }
        return this.prepareUploadCandidacyFeedbackInvalid(mapping, actionForm, request, response);
    }
}

