/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd;

import java.util.function.Predicate;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessStateType;
import org.fenixedu.academic.util.predicates.InlinePredicate;
import org.fenixedu.academic.util.predicates.OrPredicate;
import org.fenixedu.academic.util.predicates.PredicateContainer;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public enum PhdThesisPredicateContainer implements PredicateContainer<PhdIndividualProgramProcess>
{
    PROVISIONAL_THESIS_DELIVERED{

        @Override
        public Predicate<PhdIndividualProgramProcess> getPredicate() {
            return new OrPredicate<PhdIndividualProgramProcess>(){
                {
                    this.add((Predicate)new PhdThesisPredicate(PhdThesisProcessStateType.NEW));
                    this.add((Predicate)new PhdThesisPredicate(PhdThesisProcessStateType.WAITING_FOR_JURY_CONSTITUTION));
                    this.add((Predicate)new PhdThesisPredicate(PhdThesisProcessStateType.JURY_WAITING_FOR_VALIDATION));
                    this.add((Predicate)new PhdThesisPredicate(PhdThesisProcessStateType.JURY_VALIDATED));
                    this.add((Predicate)new PhdThesisPredicate(PhdThesisProcessStateType.WAITING_FOR_JURY_REPORTER_FEEDBACK));
                    this.add((Predicate)new PhdThesisPredicate(PhdThesisProcessStateType.WAITING_FOR_THESIS_MEETING_SCHEDULING));
                    this.add((Predicate)new PhdThesisPredicate(PhdThesisProcessStateType.WAITING_FOR_THESIS_DISCUSSION_DATE_SCHEDULING));
                }
            };
        }
    }
    ,
    DISCUSSION_SCHEDULED{

        @Override
        public Predicate<PhdIndividualProgramProcess> getPredicate() {
            return new PhdThesisPredicate(PhdThesisProcessStateType.THESIS_DISCUSSION_DATE_SCHECULED);
        }
    };


    @Override
    public String getLocalizedName() {
        return BundleUtil.getString((String)"resources.PhdResources", (String)(PhdThesisPredicateContainer.class.getName() + "." + this.name()), (String[])new String[0]);
    }

    private static class PhdThesisPredicate
    extends InlinePredicate<PhdIndividualProgramProcess, PhdThesisProcessStateType> {
        public PhdThesisPredicate(PhdThesisProcessStateType thesisState) {
            super(thesisState);
        }

        @Override
        public boolean test(PhdIndividualProgramProcess process2) {
            return this.checkState(process2) && this.checkValue(process2);
        }

        private boolean checkState(PhdIndividualProgramProcess process2) {
            return process2.getActiveState().isActive() && process2.getThesisProcess() != null;
        }

        private boolean checkValue(PhdIndividualProgramProcess process2) {
            return process2.getThesisProcess().getActiveState().equals(this.getValue());
        }
    }
}

