/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.manager;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurricularPlan.StudentCurricularPlanState;
import org.fenixedu.academic.dto.InfoDegreeCurricularPlan;
import org.fenixedu.academic.service.services.exceptions.ExistingServiceException;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NonExistingServiceException;
import org.fenixedu.academic.service.services.manager.CreateStudentCurricularPlan;
import org.fenixedu.academic.service.services.manager.DeleteEnrollment;
import org.fenixedu.academic.service.services.manager.DeleteStudentCurricularPlan;
import org.fenixedu.academic.service.services.manager.ReadDegreeCurricularPlansByDegreeType;
import org.fenixedu.academic.service.services.manager.ReadStudentCurricularInformation;
import org.fenixedu.academic.service.services.manager.TransferEnrollments;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.manager.ManagerApplications;
import org.fenixedu.academic.ui.struts.config.FenixErrorExceptionHandler;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.ExceptionHandling;
import org.fenixedu.bennu.struts.annotations.Exceptions;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=ManagerApplications.ManagerPeopleApp.class, path="manage-students", titleKey="link.manager.studentsManagement")
@Mapping(module="manager", path="/studentsManagement", input="/studentsManagement.do?method=show&page=0", formBean="studentCurricularPlanForm")
@Forwards(value={@Forward(name="createStudentCurricularPlan", path="/manager/createStudentCurricularPlan.jsp"), @Forward(name="transferEnrollments", path="/manager/transferEnrollments.jsp"), @Forward(name="show", path="/manager/studentCurricularPlan.jsp")})
@Exceptions(value={@ExceptionHandling(type=NonExistingServiceException.class, key="exception.student.does.not.exist", handler=FenixErrorExceptionHandler.class, scope="request"), @ExceptionHandling(type=ExistingServiceException.class, key="student.curricular.plan.already.exists", handler=FenixErrorExceptionHandler.class, scope="request"), @ExceptionHandling(type=DomainException.class, key="error.enrolmentEvaluation.cannot.be.deleted", handler=FenixErrorExceptionHandler.class, scope="request")})
public class ManageStudentCurricularPlanDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward show(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        String studentNumberString = (String)dynaActionForm.get("number");
        String degreeTypeString = (String)dynaActionForm.get("degreeType");
        if (this.isPresent(studentNumberString) && this.isPresent(degreeTypeString)) {
            DegreeType degreeType = (DegreeType)FenixFramework.getDomainObject((String)degreeTypeString);
            this.putStudentCurricularInformationInRequest(request, Integer.valueOf(studentNumberString), degreeType);
        }
        return mapping.findForward("show");
    }

    public ActionForward deleteStudentCurricularPlan(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String studentCurricularPlanIdString = request.getParameter("studentCurricularPlanId");
        DeleteStudentCurricularPlan.run(studentCurricularPlanIdString);
        return this.show(mapping, form, request, response);
    }

    public ActionForward deleteEnrollment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String enrollmentIdString = request.getParameter("enrollmentId");
        String studentNumberString = request.getParameter("studentNumber");
        String degreeTypeString = request.getParameter("degreeType");
        Integer studentNumber = Integer.valueOf(studentNumberString);
        DegreeType degreeType = (DegreeType)FenixFramework.getDomainObject((String)degreeTypeString);
        User userView = Authenticate.getUser();
        DeleteEnrollment.run(studentNumber, degreeType, enrollmentIdString);
        return this.show(mapping, form, request, response);
    }

    public ActionForward prepareCreateStudentCurricularPlan(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        String degreeTypeString = (String)dynaActionForm.get("degreeType");
        if (this.isPresent(degreeTypeString)) {
            DegreeType degreeType = (DegreeType)FenixFramework.getDomainObject((String)degreeTypeString);
            List<InfoDegreeCurricularPlan> infoDegreeCurricularPlans = ReadDegreeCurricularPlansByDegreeType.run(degreeType);
            this.putDegreeCurricularPlansInRequest(request, infoDegreeCurricularPlans);
        }
        return mapping.findForward("createStudentCurricularPlan");
    }

    public ActionForward createStudentCurricularPlan(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        String studentNumberString = (String)dynaActionForm.get("number");
        String degreeTypeString = (String)dynaActionForm.get("degreeType");
        String studentCurricularPlanStateString = (String)dynaActionForm.get("studentCurricularPlanState");
        String degreeCurricularPlanIdString = (String)dynaActionForm.get("degreeCurricularPlanId");
        String startDateString = (String)dynaActionForm.get("startDate");
        if (this.isPresent(studentNumberString) && this.isPresent(degreeTypeString) && this.isPresent(studentCurricularPlanStateString) && this.isPresent(degreeCurricularPlanIdString) && this.isPresent(startDateString)) {
            Integer studentNumber = new Integer(studentNumberString);
            DegreeType degreeType = (DegreeType)FenixFramework.getDomainObject((String)degreeTypeString);
            StudentCurricularPlanState studentCurricularPlanState = StudentCurricularPlanState.valueOf(studentCurricularPlanStateString);
            Date startDate = new SimpleDateFormat("dd/MM/yyyy").parse(startDateString);
            User userView = Authenticate.getUser();
            CreateStudentCurricularPlan.run(studentNumber, degreeType, studentCurricularPlanState, degreeCurricularPlanIdString, startDate);
        }
        return this.show(mapping, form, request, response);
    }

    public ActionForward prepareTransferEnrollments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.show(mapping, form, request, response);
        return mapping.findForward("transferEnrollments");
    }

    public ActionForward transferEnrollments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        String selectedStudentCurricularPlanIdString = (String)dynaActionForm.get("selectedStudentCurricularPlanId");
        String selectedCurriculumGroupID = (String)dynaActionForm.get("selectedCurriculumGroupID");
        String[] enrollmentStringIDsToTransfer = (String[])dynaActionForm.get("enrollmentIDsToTransfer");
        if (this.isPresent(selectedStudentCurricularPlanIdString) && enrollmentStringIDsToTransfer != null && enrollmentStringIDsToTransfer.length > 0) {
            User userView = Authenticate.getUser();
            TransferEnrollments.run(selectedStudentCurricularPlanIdString, enrollmentStringIDsToTransfer, selectedCurriculumGroupID);
        }
        return this.show(mapping, form, request, response);
    }

    protected void putStudentCurricularInformationInRequest(HttpServletRequest request, Integer studentNumber, DegreeType degreeType) throws FenixServiceException {
        User userView = Authenticate.getUser();
        List infoStudentCurricularPlans = ReadStudentCurricularInformation.run(studentNumber, degreeType);
        request.setAttribute("infoStudentCurricularPlans", (Object)infoStudentCurricularPlans);
    }

    protected boolean isPresent(String string) {
        return string != null && string.length() > 0;
    }

    protected void putDegreeCurricularPlansInRequest(HttpServletRequest request, List infoDegreeCurricularPlans) {
        ComparatorChain comparatorChain = new ComparatorChain();
        comparatorChain.addComparator((Comparator)new BeanComparator("infoDegree.nome"));
        comparatorChain.addComparator((Comparator)new BeanComparator("initialDate"));
        Collections.sort(infoDegreeCurricularPlans, comparatorChain);
        request.setAttribute("degreeCurricularPlans", (Object)infoDegreeCurricularPlans);
    }
}

