/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.student.candidacy.registrations;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.candidacy.registrations.RegisteredDegreeCandidaciesSelectionBean;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.candidacy.registrations.RegisteredDegreeCandidaciesWithApplyForResidence;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.Spreadsheet;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminListingsApp.class, path="registered-degree-candidacies", titleKey="label.registeredDegreeCandidacies.first.time.list", accessGroup="academic(MANAGE_REGISTERED_DEGREE_CANDIDACIES)")
@Mapping(path="/registeredDegreeCandidacies", module="academicAdministration")
@Forwards(value={@Forward(name="viewRegisteredDegreeCandidacies", path="/academicAdminOffice/student/candidacies/registration/viewRegisteredDegreeCandidacies.jsp")})
public class RegisteredDegreeCandidaciesDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward view(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        RegisteredDegreeCandidaciesSelectionBean registeredDegreeCandidaciesSelectionBean = this.getRegisteredDegreeCandidaciesSelectionBean();
        if (registeredDegreeCandidaciesSelectionBean == null) {
            request.setAttribute("bean", (Object)new RegisteredDegreeCandidaciesSelectionBean());
            return mapping.findForward("viewRegisteredDegreeCandidacies");
        }
        List<StudentCandidacy> studentCandidacies = registeredDegreeCandidaciesSelectionBean.search(this.getDegreesToSearch());
        request.setAttribute("studentCandidacies", studentCandidacies);
        return mapping.findForward("viewRegisteredDegreeCandidacies");
    }

    public ActionForward export(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        RegisteredDegreeCandidaciesSelectionBean registeredDegreeCandidaciesSelectionBean = this.getRegisteredDegreeCandidaciesSelectionBean();
        Spreadsheet export = registeredDegreeCandidaciesSelectionBean.export(this.getDegreesToSearch());
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=" + registeredDegreeCandidaciesSelectionBean.getFilename());
        export.exportToXLSSheet((OutputStream)response.getOutputStream());
        return null;
    }

    public ActionForward exportWithApplyForResidence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        RegisteredDegreeCandidaciesSelectionBean registeredDegreeCandidaciesSelectionBean = this.getRegisteredDegreeCandidaciesSelectionBean();
        RegisteredDegreeCandidaciesWithApplyForResidence forResidence = new RegisteredDegreeCandidaciesWithApplyForResidence(registeredDegreeCandidaciesSelectionBean);
        Spreadsheet spreadsheet = forResidence.export(this.getDegreesToSearch());
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=" + forResidence.getFilename());
        spreadsheet.exportToXLSSheet((OutputStream)response.getOutputStream());
        return null;
    }

    private RegisteredDegreeCandidaciesSelectionBean getRegisteredDegreeCandidaciesSelectionBean() {
        return (RegisteredDegreeCandidaciesSelectionBean)this.getRenderedObject("bean");
    }

    protected Set<Degree> getDegreesToSearch() {
        return AcademicAccessRule.getDegreesAccessibleToFunction(AcademicOperationType.MANAGE_REGISTERED_DEGREE_CANDIDACIES, Authenticate.getUser()).collect(Collectors.toSet());
    }
}

