/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.student;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.candidacy.IngressionInformationBean;
import org.fenixedu.academic.service.factoryExecutors.RegistrationIngressionFactorExecutor;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.FenixActionForm;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Input;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@Mapping(path="/manageIngression", module="academicAdministration", formBeanClass=FenixActionForm.class, functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="showEditIngression", path="/academicAdminOffice/manageIngression.jsp"), @Forward(name="createReingression", path="/academicAdminOffice/createReingression.jsp")})
public class ManageIngressionDA
extends FenixDispatchAction {
    private Registration getRegistration(HttpServletRequest request) {
        return (Registration)((Object)this.getDomainObject(request, "registrationId"));
    }

    private RegistrationIngressionFactorExecutor.RegistrationIngressionEditor getRegistrationIngressionEditor() {
        return (RegistrationIngressionFactorExecutor.RegistrationIngressionEditor)this.getRenderedObject();
    }

    @Input
    public ActionForward prepare(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("ingressionBean", (Object)new RegistrationIngressionFactorExecutor.RegistrationIngressionEditor(this.getRegistration(request)));
        return mapping.findForward("showEditIngression");
    }

    public ActionForward postBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        RegistrationIngressionFactorExecutor.RegistrationIngressionEditor ingressionInformationBean = this.getRegistrationIngressionEditor();
        if (!ingressionInformationBean.hasRegistrationProtocol() || ingressionInformationBean.getRegistrationProtocol().isEnrolmentByStudentAllowed()) {
            ingressionInformationBean.setAgreementInformation(null);
        }
        RenderUtils.invalidateViewState();
        request.setAttribute("ingressionBean", (Object)ingressionInformationBean);
        return mapping.findForward("showEditIngression");
    }

    public ActionForward editIngression(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeFactoryMethod();
        }
        catch (DomainException e) {
            request.setAttribute("ingressionBean", (Object)this.getRegistrationIngressionEditor());
            RenderUtils.invalidateViewState();
            this.addActionMessage(request, e.getKey());
            return mapping.findForward("showEditIngression");
        }
        this.addActionMessage(request, "message.registration.ingression.and.agreement.edit.success");
        request.setAttribute("registrationId", (Object)this.getRegistrationIngressionEditor().getRegistration().getExternalId());
        return this.prepare(mapping, actionForm, request, response);
    }

    public ActionForward prepareCreateReingression(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Registration registration = (Registration)((Object)this.getDomainObject(request, "registrationId"));
        IngressionInformationBean bean = new IngressionInformationBean(registration);
        request.setAttribute("bean", (Object)bean);
        request.setAttribute("registration", (Object)registration);
        return mapping.findForward("createReingression");
    }

    public ActionForward createReingressionInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Registration registration = (Registration)((Object)this.getDomainObject(request, "registrationId"));
        IngressionInformationBean ingressionInformationBean = (IngressionInformationBean)this.getRenderedObject("bean");
        request.setAttribute("bean", (Object)ingressionInformationBean);
        request.setAttribute("registration", (Object)registration);
        return mapping.findForward("createReingression");
    }

    public ActionForward createReingression(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Registration registration = (Registration)((Object)this.getDomainObject(request, "registrationId"));
            IngressionInformationBean bean = (IngressionInformationBean)this.getRenderedObject("bean");
            registration.createReingression(bean.getExecutionYear(), bean.getReingressionDate());
            this.addActionMessage("success", request, "message.registration.reingression.mark.success");
            RenderUtils.invalidateViewState();
            return this.prepare(mapping, form, request, response);
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getKey(), e.getArgs());
            return this.createReingressionInvalid(mapping, form, request, response);
        }
    }

    public ActionForward deleteReingression(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Registration registration = (Registration)((Object)this.getDomainObject(request, "registrationId"));
            ExecutionYear executionYear = (ExecutionYear)this.getDomainObject(request, "executionYearId");
            registration.deleteReingression(executionYear);
            this.addActionMessage("success", request, "message.registration.reingression.delete.success");
            RenderUtils.invalidateViewState();
            return this.prepare(mapping, form, request, response);
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getKey());
            return this.prepare(mapping, form, request, response);
        }
    }
}

