/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.components.degreeStructure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.predicate.AcademicPredicates;
import org.fenixedu.academic.ui.faces.components.degreeStructure.UICourseGroup;
import org.fenixedu.academic.ui.faces.components.degreeStructure.UICurricularCourse;
import org.fenixedu.academic.util.CurricularRuleLabelFormatter;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public class UIDegreeModule
extends UIInput {
    public static final String COMPONENT_TYPE = "org.fenixedu.academic.ui.faces.components.degreeStructure.UIDegreeModule";
    public static final String COMPONENT_FAMILY = "org.fenixedu.academic.ui.faces.components.degreeStructure.UIDegreeModule";
    protected DegreeModule degreeModule;
    protected Context previousContext;
    protected ExecutionYear executionYear;
    protected ExecutionSemester lastExecutionPeriod;
    protected Boolean toEdit;
    protected Boolean showRules = Boolean.FALSE;
    protected int depth;
    protected String tabs;
    protected String module;
    protected String currentPage;
    protected Boolean expandable;
    protected FacesContext facesContext;
    protected ResponseWriter writer;
    protected static final int BASE_DEPTH = 1;
    private static final String CODE_NAME_SEPARATOR = " - ";

    public UIDegreeModule() {
        this.setRendererType(null);
    }

    public UIDegreeModule(DegreeModule degreeModule, Context previousContext, Boolean toEdit, Boolean showRules, int depth, String tabs, ExecutionYear executionYear, String module, String currentPage, Boolean expandable) {
        this();
        this.degreeModule = degreeModule;
        this.previousContext = previousContext;
        this.toEdit = toEdit;
        this.showRules = showRules;
        this.depth = depth;
        this.tabs = tabs;
        this.executionYear = executionYear;
        if (this.executionYear == null) {
            this.executionYear = ExecutionYear.readLastExecutionYear();
        }
        this.lastExecutionPeriod = this.executionYear.getLastExecutionPeriod();
        this.module = module;
        this.currentPage = currentPage;
        this.expandable = expandable;
    }

    public String getFamily() {
        return "org.fenixedu.academic.ui.faces.components.degreeStructure.UIDegreeModule";
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        this.setFromAttributes();
        if (this.degreeModule.isLeaf()) {
            new UICurricularCourse(this.degreeModule, null, this.toEdit, this.showRules, this.depth, this.tabs, this.executionYear, this.module, null, false).encodeBegin(facesContext);
        } else if (!this.degreeModule.isLeaf()) {
            new UICourseGroup(this.degreeModule, null, this.toEdit, this.showRules, this.depth, this.tabs, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, this.module, this.currentPage, this.expandable).encodeBegin(facesContext);
        }
    }

    private void setFromAttributes() {
        if (this.degreeModule == null) {
            this.degreeModule = (DegreeModule)((Object)this.getAttributes().get("degreeModule"));
        }
        if (this.toEdit == null) {
            this.toEdit = (Boolean)this.getAttributes().get("toEdit");
        }
        if (this.tabs == null) {
            this.depth = 1;
            this.tabs = "";
        }
    }

    protected void appendCodeAndName() throws IOException {
        String code = this.degreeModule.getCode();
        if (code != null) {
            this.writer.append((CharSequence)code).append(CODE_NAME_SEPARATOR);
        }
        this.writer.append((CharSequence)this.degreeModule.getNameI18N(this.lastExecutionPeriod).getContent());
    }

    protected void encodeLink(String page, String aditionalParameters, boolean blank, String ... bundleKeys) throws IOException {
        this.writer.startElement("a", (UIComponent)this);
        this.encodeLinkHref(page, aditionalParameters, blank);
        for (String bundleKey : bundleKeys) {
            this.writer.write(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)bundleKey, (String[])new String[0]));
        }
        this.writer.endElement("a");
    }

    protected void encodeLinkHref(String page, String aditionalParameters, boolean blank) throws IOException {
        Map requestParameterMap = this.facesContext.getExternalContext().getRequestParameterMap();
        StringBuilder href = new StringBuilder();
        href.append(page).append("?");
        if (requestParameterMap.get("degreeID") != null) {
            href.append("degreeID=").append((String)requestParameterMap.get("degreeID")).append("&");
        }
        Object dcpId = null;
        if (requestParameterMap.get("degreeCurricularPlanID") != null) {
            dcpId = requestParameterMap.get("degreeCurricularPlanID");
        } else if (requestParameterMap.get("dcpId") != null) {
            dcpId = requestParameterMap.get("dcpId");
        }
        href.append("degreeCurricularPlanID=").append((Object)dcpId);
        if (this.executionYear != null) {
            href.append("&executionYearID=").append(this.executionYear.getExternalId());
        } else if (requestParameterMap.get("executionPeriodOID") != null) {
            href.append("&executionPeriodOID=").append((String)requestParameterMap.get("executionPeriodOID"));
        }
        if (aditionalParameters != null) {
            href.append(aditionalParameters);
        }
        href.append("&organizeBy=").append((String)requestParameterMap.get("organizeBy"));
        href.append("&showRules=").append((String)requestParameterMap.get("showRules"));
        href.append("&hideCourses=").append((String)requestParameterMap.get("hideCourses"));
        href.append("&action=").append((String)requestParameterMap.get("action"));
        this.writer.writeAttribute("href", (Object)href.toString(), null);
        if (blank) {
            this.writer.writeAttribute("target", (Object)"_blank", null);
        }
    }

    protected void encodeCurricularRules() throws IOException {
        ArrayList<CurricularRule> curricularRulesToEncode = new ArrayList<CurricularRule>();
        for (CurricularRule curricularRule : this.degreeModule.getVisibleCurricularRules(this.executionYear)) {
            if (!curricularRule.appliesToContext(this.previousContext)) continue;
            curricularRulesToEncode.add(curricularRule);
        }
        if (!curricularRulesToEncode.isEmpty()) {
            this.writer.startElement("tr", (UIComponent)this);
            this.writer.startElement("td", (UIComponent)this);
            this.writer.writeAttribute("colspan", (Object)(this.toEdit != false ? "6" : "5"), null);
            this.writer.writeAttribute("style", (Object)"padding:0; margin: 0;", null);
            this.writer.startElement("table", (UIComponent)this);
            this.writer.writeAttribute("class", (Object)"smalltxt noborder", null);
            this.writer.writeAttribute("style", (Object)"width: 100%;", null);
            for (CurricularRule curricularRule : curricularRulesToEncode) {
                this.writer.startElement("tr", (UIComponent)this);
                this.encodeCurricularRule(curricularRule);
                if (this.toEdit.booleanValue() && this.loggedPersonCanManageDegreeCurricularPlans().booleanValue()) {
                    this.encodeCurricularRuleOptions(curricularRule);
                }
                this.writer.endElement("tr");
            }
            this.writer.endElement("table");
            this.writer.endElement("td");
            this.writer.endElement("tr");
        }
    }

    private void encodeCurricularRule(CurricularRule curricularRule) throws IOException {
        this.writer.startElement("td", (UIComponent)this);
        if (!this.toEdit.booleanValue()) {
            this.writer.writeAttribute("colspan", (Object)"2", null);
        }
        this.writer.writeAttribute("style", (Object)"color: #888;", null);
        this.writer.append((CharSequence)CurricularRuleLabelFormatter.getLabel(curricularRule, I18N.getLocale()));
        this.writer.endElement("td");
    }

    private void encodeCurricularRuleOptions(CurricularRule curricularRule) throws IOException {
        this.writer.startElement("td", (UIComponent)this);
        this.writer.writeAttribute("class", (Object)"aright", null);
        if (this.loggedPersonCanManageDegreeCurricularPlans().booleanValue()) {
            if (this.executionYear != null) {
                this.encodeLink(this.module + "/curricularRules/editCurricularRule.faces", "&curricularRuleID=" + curricularRule.getExternalId(), false, "edit");
                this.writer.append((CharSequence)", ");
            }
            this.encodeLink(this.module + "/curricularRules/deleteCurricularRule.faces", "&curricularRuleID=" + curricularRule.getExternalId(), false, "delete");
        }
        this.writer.endElement("td");
    }

    protected Boolean loggedPersonCanManageDegreeCurricularPlans() {
        return AcademicPredicates.MANAGE_DEGREE_CURRICULAR_PLANS.evaluate(this.degreeModule.getDegree());
    }
}

