/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.bolonhaManager.curricularPlans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.faces.model.SelectItem;
import org.fenixedu.academic.domain.degreeStructure.BranchType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.academic.service.services.bolonhaManager.CreateBranchCourseGroup;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.faces.bean.bolonhaManager.curricularPlans.CourseGroupManagementBackingBean;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public class BranchCourseGroupManagementBackingBean
extends CourseGroupManagementBackingBean {
    private String branchTypeName;
    private List<SelectItem> branchTypes = null;

    public String getBranchTypeName() {
        return this.branchTypeName != null ? this.branchTypeName : BranchType.MAJOR.getName();
    }

    public void setBranchTypeName(String branchTypeName) {
        this.branchTypeName = branchTypeName;
    }

    public BranchType getBranchType() {
        return BranchType.valueOf(this.getBranchTypeName());
    }

    public List<SelectItem> getBranchTypes() {
        return this.branchTypes == null ? (this.branchTypes = this.readBranchTypes()) : this.branchTypes;
    }

    private List<SelectItem> readBranchTypes() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        ArrayList<BranchType> entries = new ArrayList<BranchType>(Arrays.asList(BranchType.values()));
        for (BranchType entry : entries) {
            result.add(new SelectItem((Object)entry.name(), entry.getDescription(I18N.getLocale())));
        }
        return result;
    }

    public String createBranchCourseGroup() {
        try {
            CreateBranchCourseGroup.run(this.getDegreeCurricularPlanID(), this.getParentCourseGroupID(), this.getName(), this.getNameEn(), this.getBranchType(), this.getBeginExecutionPeriodID(), this.getFinalEndExecutionPeriodID());
            this.addInfoMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"branchCourseGroupCreated", (String[])new String[0]));
            return "editCurricularPlanStructure";
        }
        catch (IllegalDataAccessException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.notAuthorized", (String[])new String[0]));
            return "editCurricularPlanStructure";
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])new String[0]));
        }
        return "";
    }
}

