/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.manager;

import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.studentCurricularPlan.StudentCurricularPlanState;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NonExistingServiceException;
import org.fenixedu.academic.service.services.manager.CreateStudentCurricularPlan$callable$run;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreateStudentCurricularPlan {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static void run(Integer n, DegreeType degreeType, StudentCurricularPlanState studentCurricularPlanState, String string, Date date) throws FenixServiceException {
        Object object = advice$run.perform((Callable)new CreateStudentCurricularPlan$callable$run(n, degreeType, studentCurricularPlanState, string, date));
    }

    static /* synthetic */ void advised$run(Integer studentNumber, DegreeType degreeType, StudentCurricularPlanState studentCurricularPlanState, String degreeCurricularPlanId, Date startDate) throws FenixServiceException {
        AccessControl.check(RolePredicates.MANAGER_OR_OPERATOR_PREDICATE);
        Registration registration = Registration.readStudentByNumberAndDegreeType(studentNumber, degreeType);
        if (registration == null) {
            throw new NonExistingServiceException("exception.student.does.not.exist");
        }
        DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlanId);
        if (degreeCurricularPlan == null) {
            throw new NonExistingServiceException("exception.degree.curricular.plan.does.not.exist");
        }
        StudentCurricularPlan.createWithEmptyStructure(registration, degreeCurricularPlan, YearMonthDay.fromDateFields((Date)startDate));
    }
}

