/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.alumni;

import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.organizationalStructure.AcademicalInstitutionType;
import org.fenixedu.academic.domain.organizationalStructure.AcademicalInstitutionUnit;
import org.fenixedu.academic.domain.organizationalStructure.CountryUnit;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.dto.alumni.formation.AlumniFormation;
import org.fenixedu.academic.util.MultiLanguageString;
import org.joda.time.YearMonthDay;

public class FormationManagement {
    protected AcademicalInstitutionUnit getFormationInstitution(AlumniFormation formation) {
        Object institutionUnit = formation.getInstitution();
        if (institutionUnit == null && formation.getInstitutionType() != null && (formation.getInstitutionType().equals((Object)AcademicalInstitutionType.FOREIGN_INSTITUTION) || formation.getInstitutionType().equals((Object)AcademicalInstitutionType.OTHER_INSTITUTION)) && !StringUtils.isEmpty((String)formation.getForeignUnit())) {
            institutionUnit = UniversityUnit.createNewUniversityUnit(new MultiLanguageString(formation.getForeignUnit()), null, null, null, new YearMonthDay(), null, this.getParentUnit(formation), null, null, false, null);
            institutionUnit.setInstitutionType(formation.getInstitutionType());
        }
        return institutionUnit;
    }

    protected Unit getParentUnit(AlumniFormation formation) {
        if (formation.isNationalInstitution() || formation.getCountryUnit() == null) {
            return CountryUnit.getDefault();
        }
        return formation.getCountryUnit();
    }
}

