/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.thesis;

import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.report.thesis.ThesisDocument;
import org.joda.time.DateTime;

public class ThesisJuryReportDocument
extends ThesisDocument {
    private static final long serialVersionUID = 1L;

    public ThesisJuryReportDocument(Thesis thesis) {
        super(thesis);
    }

    @Override
    public void fillGeneric() {
        String discussed;
        Thesis thesis = this.getThesis();
        if (thesis.getDiscussed() != null) {
            DateTime discussedTime = thesis.getDiscussed();
            discussed = discussedTime.getDayOfMonth() + " / " + discussedTime.getMonthOfYear() + " / " + discussedTime.getYear();
        } else {
            discussed = "";
        }
        this.addParameter("date", discussed);
        this.addParameter("grade", this.neverNull(this.getThesis().getMark()));
    }

    @Override
    public String getReportFileName() {
        return "acta-juri-tese-" + this.getThesis().getStudent().getNumber();
    }

    @Override
    protected String neverNull(String value) {
        return value == null ? "" : value;
    }

    protected String neverNull(Integer value) {
        return value == null ? "" : value.toString();
    }
}

