/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.predicate;

import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.accessControl.AcademicAuthorizationGroup;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.predicate.AccessControlPredicate;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;

public class ContextPredicates {
    public static final AccessControlPredicate<Context> curricularPlanMemberWritePredicate = new AccessControlPredicate<Context>(){

        @Override
        public boolean evaluate(Context context) {
            User user = Authenticate.getUser();
            if (RoleType.SCIENTIFIC_COUNCIL.isMember(user)) {
                return true;
            }
            DegreeCurricularPlan parentDegreeCurricularPlan = context.getParentCourseGroup().getParentDegreeCurricularPlan();
            if (!parentDegreeCurricularPlan.isBolonhaDegree()) {
                return true;
            }
            if (AcademicAuthorizationGroup.get(AcademicOperationType.MANAGE_DEGREE_CURRICULAR_PLANS).isMember(user) || RoleType.MANAGER.isMember(user) || RoleType.OPERATOR.isMember(user)) {
                return true;
            }
            return parentDegreeCurricularPlan.getCurricularPlanMembersGroup().isMember(user);
        }
    };
}

