/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.dto.InfoEnrolment;
import org.fenixedu.academic.dto.InfoExecutionCourse;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.dto.InfoStudent;
import pt.ist.fenixframework.DomainObject;

public class InfoFrequenta
extends InfoObject {
    protected InfoStudent _aluno;
    protected InfoExecutionCourse _disciplinaExecucao;
    protected InfoEnrolment infoEnrolment;
    private EvaluationSeason evaluationSeason;

    public InfoFrequenta() {
    }

    public InfoFrequenta(InfoStudent aluno, InfoExecutionCourse disciplinaExecucao) {
        this.setAluno(aluno);
        this.setDisciplinaExecucao(disciplinaExecucao);
    }

    public InfoFrequenta(InfoStudent aluno, InfoExecutionCourse disciplinaExecucao, InfoEnrolment enrolment) {
        this.setAluno(aluno);
        this.setDisciplinaExecucao(disciplinaExecucao);
        this.setInfoEnrolment(enrolment);
    }

    public InfoStudent getAluno() {
        return this._aluno;
    }

    public void setAluno(InfoStudent aluno) {
        this._aluno = aluno;
    }

    public InfoExecutionCourse getDisciplinaExecucao() {
        return this._disciplinaExecucao;
    }

    public void setDisciplinaExecucao(InfoExecutionCourse disciplinaExecucao) {
        this._disciplinaExecucao = disciplinaExecucao;
    }

    @Override
    public boolean equals(Object obj) {
        boolean resultado = false;
        if (obj instanceof InfoFrequenta) {
            InfoFrequenta frequenta = (InfoFrequenta)obj;
            resultado = this.getAluno().equals(frequenta.getAluno()) && this.getDisciplinaExecucao().equals(frequenta.getDisciplinaExecucao());
        }
        return resultado;
    }

    public String toString() {
        String result = "[ATTEND";
        result = result + ", Registration=" + this._aluno;
        result = result + ", ExecutionCourse=" + this._disciplinaExecucao;
        result = result + ", Enrolment=" + this.infoEnrolment;
        result = result + "]";
        return result;
    }

    public InfoEnrolment getInfoEnrolment() {
        return this.infoEnrolment;
    }

    public void setInfoEnrolment(InfoEnrolment enrolment) {
        this.infoEnrolment = enrolment;
    }

    public EvaluationSeason getEvaluationSeason() {
        return this.evaluationSeason;
    }

    public void setEvaluationSeason(EvaluationSeason evaluationSeason) {
        this.evaluationSeason = evaluationSeason;
    }

    public void copyFromDomain(Attends frequenta) {
        super.copyFromDomain((DomainObject)frequenta);
        this.setAluno(InfoStudent.newInfoFromDomain(frequenta.getRegistration()));
        this.setDisciplinaExecucao(InfoExecutionCourse.newInfoFromDomain(frequenta.getExecutionCourse()));
        this.setInfoEnrolment(InfoEnrolment.newInfoFromDomain(frequenta.getEnrolment()));
    }

    public static InfoFrequenta newInfoFromDomain(Attends frequenta) {
        InfoFrequenta infoFrequenta = null;
        if (frequenta != null) {
            infoFrequenta = new InfoFrequenta();
            infoFrequenta.copyFromDomain(frequenta);
        }
        return infoFrequenta;
    }
}

