/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.time.calendarStructure;

import java.util.List;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarEntry;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarRootEntry;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicSemesterCE_Base;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicYearCE;
import org.fenixedu.academic.domain.time.chronologies.AcademicChronology;
import org.fenixedu.academic.util.MultiLanguageString;
import org.joda.time.DateTime;

public class AcademicSemesterCE
extends AcademicSemesterCE_Base {
    public AcademicSemesterCE(AcademicCalendarEntry parentEntry, MultiLanguageString title, MultiLanguageString description, DateTime begin, DateTime end, AcademicCalendarRootEntry rootEntry) {
        super.initEntry(parentEntry, title, description, begin, end, rootEntry);
        this.createNewExecutionPeriod();
    }

    private AcademicSemesterCE(AcademicCalendarEntry parentEntry, AcademicSemesterCE academicSemesterCE) {
        super.initVirtualEntry(parentEntry, (AcademicCalendarEntry)((Object)academicSemesterCE));
    }

    public void delete(AcademicCalendarRootEntry rootEntry) {
        if (!this.isVirtual()) {
            ExecutionSemester executionSemester = ExecutionSemester.getExecutionPeriod(this);
            executionSemester.delete();
        }
        super.delete(rootEntry);
    }

    protected void beforeRedefineEntry() {
        throw new DomainException("error.unsupported.operation", new String[0]);
    }

    protected void afterRedefineEntry() {
        throw new DomainException("error.unsupported.operation", new String[0]);
    }

    public boolean isOfType(AcademicPeriod period) {
        return period.equals((Object)AcademicPeriod.SEMESTER);
    }

    public boolean isAcademicSemester() {
        return true;
    }

    protected boolean isParentEntryInvalid(AcademicCalendarEntry parentEntry) {
        return !parentEntry.isAcademicYear();
    }

    protected boolean exceededNumberOfChildEntries(AcademicCalendarEntry childEntry) {
        if (childEntry.isAcademicTrimester()) {
            return this.getChildEntriesWithTemplateEntries(childEntry.getClass()).size() >= 2;
        }
        return false;
    }

    protected boolean areIntersectionsPossible(AcademicCalendarEntry entryToAdd) {
        return false;
    }

    protected boolean isPossibleToChangeTimeInterval() {
        return true;
    }

    protected AcademicCalendarEntry createVirtualEntry(AcademicCalendarEntry parentEntry) {
        return new AcademicSemesterCE(parentEntry, this);
    }

    private void createNewExecutionPeriod() {
        ExecutionYear executionYear = ExecutionYear.getExecutionYear((AcademicYearCE)((Object)this.getParentEntry()));
        new ExecutionSemester(executionYear, new AcademicInterval((AcademicCalendarEntry)((Object)this), this.getRootEntry()), this.getTitle().getContent());
    }

    public int getAcademicSemesterOfAcademicYear(AcademicChronology academicChronology) {
        AcademicYearCE academicYearCE = (AcademicYearCE)((Object)academicChronology.findSameEntry(this.getParentEntry()));
        List list = academicYearCE.getChildEntriesWithTemplateEntries(academicYearCE.getBegin(), this.getBegin().minusDays(1), ((Object)((Object)this)).getClass());
        return list.size() + 1;
    }

    protected boolean associatedWithDomainEntities() {
        return true;
    }

    public String getPresentationName() {
        return this.getParentEntry().getTitle().getContent() + " - " + this.getTitle().getContent() + " - [" + this.getType() + "]";
    }
}

