/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.email;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.email.PhdProgramEmail$callable$createEmail;
import org.fenixedu.academic.domain.phd.email.PhdProgramEmail$callable$validateEmailBean;
import org.fenixedu.academic.domain.phd.email.PhdProgramEmailBean;
import org.fenixedu.academic.domain.phd.email.PhdProgramEmail_Base;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.ReplyTo;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.domain.util.email.UnitBasedSender;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PhdProgramEmail
extends PhdProgramEmail_Base {
    public static final Advice advice$createEmail = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$validateEmailBean = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected PhdProgramEmail() {
    }

    protected PhdProgramEmail(String subject, String body, String additionalTo, String additionalBccs, Person creator, DateTime date, PhdProgram program, List<PhdIndividualProgramProcess> individualProcessList) {
        this.init(subject, body, "", additionalBccs, creator, date);
        this.setPhdProgram(program);
        for (PhdIndividualProgramProcess process2 : individualProcessList) {
            this.addPhdIndividualProgramProcesses(process2);
        }
    }

    protected Collection<? extends ReplyTo> getReplyTos() {
        return ((UnitBasedSender)((Object)this.getPhdProgram().getPhdProgramUnit().getUnitBasedSenderSet().iterator().next())).getReplyTosSet();
    }

    protected Sender getSender() {
        return (Sender)((Object)this.getPhdProgram().getPhdProgramUnit().getUnitBasedSenderSet().iterator().next());
    }

    protected Collection<Recipient> getRecipients() {
        return Collections.emptyList();
    }

    protected String getBccs() {
        StringBuilder builder = new StringBuilder();
        for (PhdIndividualProgramProcess process2 : this.getPhdIndividualProgramProcessesSet()) {
            if (process2.getPerson().getEmailForSendingEmails() == null) continue;
            builder.append(process2.getPerson().getEmailForSendingEmails()).append(",");
        }
        builder.append(this.getAdditionalBcc());
        return builder.toString();
    }

    public static PhdProgramEmail createEmail(PhdProgramEmailBean phdProgramEmailBean) {
        return (PhdProgramEmail)((Object)advice$createEmail.perform((Callable)new PhdProgramEmail$callable$createEmail(phdProgramEmailBean)));
    }

    static /* synthetic */ PhdProgramEmail advised$createEmail(PhdProgramEmailBean bean) {
        return new PhdProgramEmail(bean.getSubject(), bean.getMessage(), null, bean.getBccsWithSelectedParticipants(), bean.getCreator(), bean.getCreationDate(), bean.getPhdProgram(), bean.getSelectedElements());
    }

    public static void validateEmailBean(PhdProgramEmailBean phdProgramEmailBean) {
        Object object = advice$validateEmailBean.perform((Callable)new PhdProgramEmail$callable$validateEmailBean(phdProgramEmailBean));
    }

    static /* synthetic */ void advised$validateEmailBean(PhdProgramEmailBean bean) {
        if (bean.getSelectedElements().isEmpty() && StringUtils.isEmpty((String)bean.getBccs())) {
            throw new DomainException(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.email.validation.no.recipients", (String[])new String[0]), new String[0]);
        }
        if (StringUtils.isEmpty((String)bean.getSubject())) {
            throw new DomainException(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.email.validation.subject.empty", (String[])new String[0]), new String[0]);
        }
        if (StringUtils.isEmpty((String)bean.getMessage())) {
            throw new DomainException(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.email.validation.message.empty", (String[])new String[0]), new String[0]);
        }
    }
}

