/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.candidacy.feedbackRequest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.caseHandling.StartActivity;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.phd.InternalPhdParticipant;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.PhdParticipantBean;
import org.fenixedu.academic.domain.phd.PhdProgramCandidacyProcessState;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;
import org.fenixedu.academic.domain.phd.PhdProgramProcessDocument;
import org.fenixedu.academic.domain.phd.access.ExternalAccessPhdActivity;
import org.fenixedu.academic.domain.phd.access.PhdExternalOperationBean;
import org.fenixedu.academic.domain.phd.access.PhdProcessAccessType;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackRequestDocument;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackRequestElement;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackRequestElementBean;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackRequestProcessBean;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackRequestProcess_Base;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackState;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackStateType;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacySharedDocumentsList;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.domain.util.email.SystemSender;
import org.fenixedu.academic.util.phd.PhdProperties;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public class PhdCandidacyFeedbackRequestProcess
extends PhdCandidacyFeedbackRequestProcess_Base {
    private static List<Activity> activities = new ArrayList<Activity>();

    private PhdCandidacyFeedbackRequestProcess() {
    }

    public List<Activity> getActivities() {
        return activities;
    }

    protected PhdIndividualProgramProcess getIndividualProgramProcess() {
        return this.getCandidacyProcess().getIndividualProgramProcess();
    }

    protected Person getPerson() {
        return this.getIndividualProgramProcess().getPerson();
    }

    public boolean canExecuteActivity(User userView) {
        return true;
    }

    public boolean isAllowedToManageProcess(User userView) {
        return true;
    }

    public String getDisplayName() {
        return BundleUtil.getString((String)"resources.PhdResources", (String)((Object)((Object)this)).getClass().getSimpleName(), (String[])new String[0]);
    }

    public PhdCandidacyFeedbackStateType getActiveState() {
        return (PhdCandidacyFeedbackStateType)super.getActiveState();
    }

    protected void createState(PhdCandidacyFeedbackStateType type, Person person, String remarks, DateTime stateDate) {
        new PhdCandidacyFeedbackState(this, type, person, remarks, stateDate);
    }

    protected PhdCandidacyFeedbackRequestElement getCandidacyFeedbackRequestElement(PhdParticipant participant) {
        for (PhdCandidacyFeedbackRequestElement element : this.getElementsSet()) {
            if (element.getParticipant() != participant) continue;
            return element;
        }
        return null;
    }

    public Set<PhdIndividualProgramDocumentType> getSortedSharedDocumentTypes() {
        return this.getSharedDocuments().getSortedTypes();
    }

    public Set<PhdProgramProcessDocument> getSharedDocumentsContent() {
        HashSet<PhdProgramProcessDocument> result = new HashSet<PhdProgramProcessDocument>();
        for (PhdIndividualProgramDocumentType type : this.getSortedSharedDocumentTypes()) {
            PhdProgramProcessDocument document;
            if (!type.isVersioned() || (document = this.getCandidacyProcess().getLatestDocumentVersionFor(type)) == null) continue;
            result.add(document);
        }
        return result;
    }

    public Set<PhdProgramProcessDocument> getSubmittedCandidacyFeedbackDocuments() {
        HashSet<PhdProgramProcessDocument> result = new HashSet<PhdProgramProcessDocument>();
        for (PhdCandidacyFeedbackRequestElement element : this.getElementsSet()) {
            PhdCandidacyFeedbackRequestDocument document = element.getLastFeedbackDocument();
            if (document == null) continue;
            result.add((PhdProgramProcessDocument)((Object)document));
        }
        return result;
    }

    public boolean canUploadDocuments() {
        return true;
    }

    private void notifyCoordinationOfCandidacyFeedback(PhdCandidacyFeedbackRequestElement element) {
        AlertService.alertParticipants(this.getIndividualProgramProcess(), AlertService.AlertMessage.create("message.phd.candidacy.feedback.coordinator.notification.subject", new Object[0]), AlertService.AlertMessage.create("message.phd.candidacy.feedback.coordinator.notification.body", element.getNameWithTitle(), this.getIndividualProgramProcess().getPerson().getName()), this.getOrCreateParticipantsToNofify());
    }

    private PhdParticipant[] getOrCreateParticipantsToNofify() {
        PhdIndividualProgramProcess mainProcess = this.getIndividualProgramProcess();
        ArrayList<PhdParticipant> result = new ArrayList<PhdParticipant>();
        for (Person person : mainProcess.getCoordinatorsFor(ExecutionYear.readCurrentExecutionYear())) {
            PhdParticipant participant = mainProcess.getParticipant(person);
            if (participant == null) {
                result.add(PhdParticipant.getUpdatedOrCreate(mainProcess, new PhdParticipantBean().setInternalParticipant(person)));
                continue;
            }
            if (!participant.getCandidacyFeedbackRequestElementsSet().isEmpty()) continue;
            result.add(participant);
        }
        return result.toArray(new PhdParticipant[result.size()]);
    }

    public boolean hasElement(Person person) {
        for (PhdCandidacyFeedbackRequestElement element : this.getElementsSet()) {
            if (!element.isFor(person)) continue;
            return true;
        }
        return false;
    }

    public PhdCandidacyFeedbackRequestElement getElement(Person person) {
        for (PhdCandidacyFeedbackRequestElement element : this.getElementsSet()) {
            if (!element.isFor(person)) continue;
            return element;
        }
        return null;
    }

    @Deprecated
    public Set<PhdCandidacyFeedbackState> getStates() {
        return this.getStatesSet();
    }

    public boolean hasAnyStates() {
        return !this.getStatesSet().isEmpty();
    }

    static {
        activities.add(new EditSharedDocumentTypes());
        activities.add(new AddPhdCandidacyFeedbackRequestElements());
        activities.add(new DeleteCandidacyFeedbackRequestElement());
        activities.add(new UploadCandidacyFeedback());
        activities.add(new DownloadCandidacyFeedbackDocuments());
        activities.add(new ExternalUploadCandidacyFeedback());
    }

    public static class ExternalUploadCandidacyFeedback
    extends ExternalAccessPhdActivity<PhdCandidacyFeedbackRequestProcess> {
        @Override
        public void checkPreConditions(PhdCandidacyFeedbackRequestProcess process2, User userView) {
            if (!process2.getCandidacyProcess().isInState(PhdProgramCandidacyProcessState.PENDING_FOR_COORDINATOR_OPINION)) {
                throw new PreConditionNotValidException("error.PhdCandidacyFeedbackRequestProcess.candidacy.process.is.not.pending.for.coordinator.opinion", new String[0]);
            }
        }

        @Override
        protected PhdCandidacyFeedbackRequestProcess internalExecuteActivity(PhdCandidacyFeedbackRequestProcess process2, User userView, PhdExternalOperationBean bean) {
            if (bean.getDocumentBean().hasAnyInformation()) {
                PhdCandidacyFeedbackRequestElement element = process2.getCandidacyFeedbackRequestElement(bean.getParticipant());
                PhdProgramDocumentUploadBean documentBean = bean.getDocumentBean();
                new PhdCandidacyFeedbackRequestDocument(element, documentBean.getRemarks(), documentBean.getFileContent(), documentBean.getFilename(), null);
                process2.notifyCoordinationOfCandidacyFeedback(element);
            }
            return process2;
        }
    }

    public static class DownloadCandidacyFeedbackDocuments
    extends ExternalAccessPhdActivity<PhdCandidacyFeedbackRequestProcess> {
        @Override
        public void checkPreConditions(PhdCandidacyFeedbackRequestProcess process2, User userView) {
            if (!process2.getCandidacyProcess().isInState(PhdProgramCandidacyProcessState.PENDING_FOR_COORDINATOR_OPINION)) {
                throw new PreConditionNotValidException("error.PhdCandidacyFeedbackRequestProcess.candidacy.process.is.not.pending.for.coordinator.opinion", new String[0]);
            }
        }

        @Override
        protected PhdCandidacyFeedbackRequestProcess internalExecuteActivity(PhdCandidacyFeedbackRequestProcess process2, User userView, PhdExternalOperationBean bean) {
            return process2;
        }
    }

    public static class UploadCandidacyFeedback
    extends PhdActivity {
        @Override
        protected void activityPreConditions(PhdCandidacyFeedbackRequestProcess process2, User userView) {
            if (!process2.hasElement(userView.getPerson())) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected PhdCandidacyFeedbackRequestProcess executeActivity(PhdCandidacyFeedbackRequestProcess process2, User userView, Object object) {
            PhdProgramDocumentUploadBean bean = (PhdProgramDocumentUploadBean)object;
            if (bean.hasAnyInformation()) {
                PhdCandidacyFeedbackRequestElement element = process2.getElement(userView.getPerson());
                new PhdCandidacyFeedbackRequestDocument(element, bean.getRemarks(), bean.getFileContent(), bean.getFilename(), null);
                process2.notifyCoordinationOfCandidacyFeedback(element);
            }
            return process2;
        }
    }

    public static class DeleteCandidacyFeedbackRequestElement
    extends PhdActivity {
        @Override
        protected void activityPreConditions(PhdCandidacyFeedbackRequestProcess process2, User userView) {
            if (!process2.getIndividualProgramProcess().isCoordinatorForPhdProgram(userView.getPerson())) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected PhdCandidacyFeedbackRequestProcess executeActivity(PhdCandidacyFeedbackRequestProcess process2, User userView, Object object) {
            ((PhdCandidacyFeedbackRequestElement)((Object)object)).delete();
            return process2;
        }
    }

    public static class AddPhdCandidacyFeedbackRequestElements
    extends PhdActivity {
        @Override
        protected void activityPreConditions(PhdCandidacyFeedbackRequestProcess process2, User userView) {
            if (!process2.getIndividualProgramProcess().isCoordinatorForPhdProgram(userView.getPerson())) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected PhdCandidacyFeedbackRequestProcess executeActivity(PhdCandidacyFeedbackRequestProcess process2, User userView, Object object) {
            PhdCandidacyFeedbackRequestElementBean bean = (PhdCandidacyFeedbackRequestElementBean)object;
            if (bean.isExistingElement()) {
                if (!bean.hasAnyParticipants()) {
                    throw new DomainException("error.PhdCandidacyFeedbackRequestProcess.must.add.participants", new String[0]);
                }
                for (PhdParticipant participant : bean.getParticipants()) {
                    PhdCandidacyFeedbackRequestElement element = PhdCandidacyFeedbackRequestElement.create(process2, participant, bean);
                    this.addAccessPermissionsIfNecessary(element);
                    this.notifyElement(process2, element, bean);
                }
            } else {
                PhdCandidacyFeedbackRequestElement element = PhdCandidacyFeedbackRequestElement.create(process2, bean);
                this.addAccessPermissionsIfNecessary(element);
                this.notifyElement(process2, element, bean);
            }
            return process2;
        }

        private void addAccessPermissionsIfNecessary(PhdCandidacyFeedbackRequestElement element) {
            if (!element.getParticipant().isInternal()) {
                element.getParticipant().addAccessType(PhdProcessAccessType.CANDIDACY_FEEDBACK_DOCUMENTS_DOWNLOAD, PhdProcessAccessType.CANDIDACY_FEEDBACK_UPLOAD);
            }
        }

        private void notifyElement(PhdCandidacyFeedbackRequestProcess process2, PhdCandidacyFeedbackRequestElement element, PhdCandidacyFeedbackRequestElementBean bean) {
            String body = bean.getMailBody() + "\n\n" + this.getAccessInformation(process2.getIndividualProgramProcess(), element.getParticipant()) + "\n\n";
            this.email(element.getEmail(), bean.getMailSubject(), body);
        }

        private String getAccessInformation(PhdIndividualProgramProcess process2, PhdParticipant participant) {
            if (!participant.isInternal()) {
                return AlertService.AlertMessage.get("message.phd.external.access", PhdProperties.getPhdExternalAccessLink(), participant.getAccessHashCode(), participant.getPassword());
            }
            Person person = ((InternalPhdParticipant)((Object)participant)).getPerson();
            if (process2.isCoordinatorForPhdProgram(person)) {
                return AlertService.AlertMessage.get("message.phd.candidacy.feedback.coordinator.access", new Object[0]);
            }
            if (process2.isGuiderOrAssistentGuider(person) || RoleType.TEACHER.isMember(person.getUser())) {
                return AlertService.AlertMessage.get("message.phd.candidacy.feedback.teacher.access", new Object[0]);
            }
            throw new DomainException("error.PhdThesisProcess.unexpected.participant.type", new String[0]);
        }

        private void email(String email, String subject, String body) {
            SystemSender sender = Bennu.getInstance().getSystemSender();
            new Message((Sender)((Object)sender), sender.getConcreteReplyTos(), null, null, null, subject, body, Collections.singleton(email));
        }
    }

    public static class EditSharedDocumentTypes
    extends PhdActivity {
        @Override
        protected void activityPreConditions(PhdCandidacyFeedbackRequestProcess process2, User userView) {
            if (!process2.getIndividualProgramProcess().isCoordinatorForPhdProgram(userView.getPerson())) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected PhdCandidacyFeedbackRequestProcess executeActivity(PhdCandidacyFeedbackRequestProcess process2, User userView, Object object) {
            PhdCandidacyFeedbackRequestProcessBean bean = (PhdCandidacyFeedbackRequestProcessBean)object;
            process2.setSharedDocuments(new PhdCandidacySharedDocumentsList((Collection<PhdIndividualProgramDocumentType>)bean.getSharedDocuments()));
            return process2;
        }
    }

    @StartActivity
    public static class CreateCandidacy
    extends PhdActivity {
        @Override
        protected void processPreConditions(PhdCandidacyFeedbackRequestProcess process2, User userView) {
        }

        @Override
        protected void activityPreConditions(PhdCandidacyFeedbackRequestProcess noProcess, User userView) {
        }

        @Override
        protected PhdCandidacyFeedbackRequestProcess executeActivity(PhdCandidacyFeedbackRequestProcess noProcess, User userView, Object object) {
            PhdCandidacyFeedbackRequestProcessBean bean = (PhdCandidacyFeedbackRequestProcessBean)object;
            PhdCandidacyFeedbackRequestProcess process2 = new PhdCandidacyFeedbackRequestProcess();
            process2.setSharedDocuments(new PhdCandidacySharedDocumentsList((Collection<PhdIndividualProgramDocumentType>)bean.getSharedDocuments()));
            process2.setCandidacyProcess(bean.getCandidacyProcess());
            process2.createState(PhdCandidacyFeedbackStateType.NEW, userView.getPerson(), null, new DateTime());
            return process2;
        }
    }

    private static abstract class PhdActivity
    extends Activity<PhdCandidacyFeedbackRequestProcess> {
        private PhdActivity() {
        }

        @Override
        public final void checkPreConditions(PhdCandidacyFeedbackRequestProcess process2, User userView) {
            this.processPreConditions(process2, userView);
            this.activityPreConditions(process2, userView);
        }

        protected void processPreConditions(PhdCandidacyFeedbackRequestProcess process2, User userView) {
            if (!process2.getCandidacyProcess().isInState(PhdProgramCandidacyProcessState.PENDING_FOR_COORDINATOR_OPINION)) {
                throw new PreConditionNotValidException("error.PhdCandidacyFeedbackRequestProcess.candidacy.process.is.not.pending.for.coordinator.opinion", new String[0]);
            }
        }

        protected abstract void activityPreConditions(PhdCandidacyFeedbackRequestProcess var1, User var2);
    }
}

