/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degreeStructure;

import java.util.List;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.curricularRules.AnyCurricularCourse;
import org.fenixedu.academic.domain.curricularRules.CreditsLimit;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curriculum.CurricularCourseType;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CurricularStage;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.OptionalCurricularCourse_Base;
import org.fenixedu.academic.util.MultiLanguageString;

public class OptionalCurricularCourse
extends OptionalCurricularCourse_Base {
    protected OptionalCurricularCourse() {
    }

    public OptionalCurricularCourse(CourseGroup parentCourseGroup, String name, String nameEn, CurricularStage curricularStage, CurricularPeriod curricularPeriod, ExecutionSemester beginExecutionPeriod, ExecutionSemester endExecutionPeriod) {
        this();
        this.setName(name);
        this.setNameEn(nameEn);
        this.setCurricularStage(curricularStage);
        this.setType(CurricularCourseType.OPTIONAL_COURSE);
        new Context(parentCourseGroup, (DegreeModule)((Object)this), curricularPeriod, beginExecutionPeriod, endExecutionPeriod);
    }

    public boolean isOptionalCurricularCourse() {
        return true;
    }

    public Double getMaxEctsCredits(ExecutionSemester executionSemester) {
        CreditsLimit creditsLimitRule = this.getCreditsLimitRule(executionSemester);
        if (creditsLimitRule != null) {
            return creditsLimitRule.getMaximumCredits();
        }
        AnyCurricularCourse anyCurricularCourseRule = this.getAnyCurricularCourseRule(executionSemester);
        if (anyCurricularCourseRule != null) {
            return anyCurricularCourseRule.hasCredits() ? anyCurricularCourseRule.getCredits() : 0.0;
        }
        return 0.0;
    }

    public Double getMinEctsCredits(ExecutionSemester executionSemester) {
        CreditsLimit creditsLimitRule = this.getCreditsLimitRule(executionSemester);
        if (creditsLimitRule != null) {
            return creditsLimitRule.getMinimumCredits();
        }
        AnyCurricularCourse anyCurricularCourseRule = this.getAnyCurricularCourseRule(executionSemester);
        if (anyCurricularCourseRule != null) {
            return anyCurricularCourseRule.hasCredits() ? anyCurricularCourseRule.getCredits() : 0.0;
        }
        return 0.0;
    }

    private AnyCurricularCourse getAnyCurricularCourseRule(ExecutionSemester executionSemester) {
        List result = this.getCurricularRules(CurricularRuleType.ANY_CURRICULAR_COURSE, executionSemester);
        return result.isEmpty() ? null : (AnyCurricularCourse)((Object)result.iterator().next());
    }

    public MultiLanguageString getObjectivesI18N(ExecutionSemester period) {
        return new MultiLanguageString();
    }

    public MultiLanguageString getProgramI18N(ExecutionSemester period) {
        return new MultiLanguageString();
    }

    public MultiLanguageString getEvaluationMethodI18N(ExecutionSemester period) {
        return new MultiLanguageString();
    }
}

