/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.contacts;

import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.PersonInformationLog;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.PartyContactType;
import org.fenixedu.academic.domain.contacts.WebAddress_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class WebAddress
extends WebAddress_Base {
    public static Comparator<WebAddress> COMPARATOR_BY_URL = new Comparator<WebAddress>(){

        @Override
        public int compare(WebAddress contact, WebAddress otherContact) {
            String url = contact.getUrl();
            String otherUrl = otherContact.getUrl();
            int result = 0;
            if (url != null && otherUrl != null) {
                result = url.compareTo(otherUrl);
            } else if (url != null) {
                result = 1;
            } else if (otherUrl != null) {
                result = -1;
            }
            return result == 0 ? PartyContact.COMPARATOR_BY_TYPE.compare((PartyContact)((Object)contact), (PartyContact)((Object)otherContact)) : result;
        }
    };

    public static WebAddress createWebAddress(Party party, String url, PartyContactType type, Boolean isDefault, Boolean visibleToPublic, Boolean visibleToStudents, Boolean visibleToStaff) {
        WebAddress result = null;
        if (!StringUtils.isEmpty((String)url)) {
            result = new WebAddress(party, type, visibleToPublic, visibleToStudents, visibleToStaff, isDefault, url);
        }
        return result;
    }

    public static WebAddress createWebAddress(Party party, String url, PartyContactType type, boolean isDefault) {
        for (WebAddress webAddress : party.getWebAddresses()) {
            if (!webAddress.getUrl().equals(url)) continue;
            return webAddress;
        }
        return !StringUtils.isEmpty((String)url) ? new WebAddress(party, type, isDefault, url) : null;
    }

    protected WebAddress() {
    }

    protected WebAddress(Party party, PartyContactType type, boolean defaultContact, String url) {
        this();
        super.init(party, type, defaultContact);
        this.checkParameters(url);
        super.setUrl(url);
    }

    protected WebAddress(Party party, PartyContactType type, boolean visibleToPublic, boolean visibleToStudents, boolean visibleToStaff, boolean defaultContact, String url) {
        this();
        super.init(party, type, visibleToPublic, visibleToStudents, visibleToStaff, defaultContact);
        this.checkParameters(url);
        super.setUrl(url);
    }

    private void checkParameters(String url) {
        if (StringUtils.isEmpty((String)url)) {
            throw new DomainException("error.domain.contacts.WebAddress.invalid.url", new String[0]);
        }
    }

    public boolean isWebAddress() {
        return true;
    }

    public void edit(String url) {
        super.setUrl(url);
    }

    public boolean hasUrl() {
        return this.getUrl() != null && this.getUrl().length() > 0;
    }

    public String getPresentationValue() {
        return this.getUrl();
    }

    public boolean hasValue(String value) {
        return this.hasUrl() && this.getUrl().equals(value);
    }

    public void setValid() {
        if (this.getPrevPartyContact() != null) {
            this.getPrevPartyContact().deleteWithoutCheckRules();
        }
    }

    public void logCreate(Person person) {
        this.logCreateAux(person, "label.partyContacts.WebAddress");
    }

    public void logEdit(Person person, boolean propertiesChanged, boolean valueChanged, boolean createdNewContact, String newValue) {
        this.logEditAux(person, propertiesChanged, valueChanged, createdNewContact, newValue, "label.partyContacts.WebAddress");
    }

    public void logEditAux(Person person, boolean propertiesChanged, boolean valueChanged, boolean createdNewContact, String newValue, String typeKey) {
        String infoLabel = BundleUtil.getString((String)"resources.ApplicationResources", (String)typeKey, (String[])new String[0]);
        boolean oldValueDiffersFromNew = false;
        if (valueChanged && this.getPrevPartyContact() != null) {
            boolean bl = oldValueDiffersFromNew = this.getPrevPartyContact().getPresentationValue().compareTo(this.getPresentationValue()) != 0;
        }
        if (propertiesChanged && !valueChanged) {
            PersonInformationLog.createLog(person, "resources.MessagingResources", "log.personInformation.contact.generic.edit", infoLabel, this.getPresentationValue(), person.getUsername());
        } else if (valueChanged && oldValueDiffersFromNew) {
            PersonInformationLog.createLog(person, "resources.MessagingResources", "log.personInformation.contact.generic.edit.values", infoLabel, this.getPrevPartyContact().getPresentationValue(), this.getPresentationValue(), person.getUsername());
        }
    }

    public void logDelete(Person person) {
        this.logDeleteAux(person, "label.partyContacts.WebAddress");
    }
}

