/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.installments;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.PaymentPlan;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent;
import org.fenixedu.academic.domain.accounting.installments.InstallmentForFirstTimeStudents_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.accounting.paymentPlan.InstallmentBean;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.YearMonthDay;

public class InstallmentForFirstTimeStudents
extends InstallmentForFirstTimeStudents_Base {
    protected InstallmentForFirstTimeStudents() {
    }

    public InstallmentForFirstTimeStudents(PaymentPlan paymentPlan, Money amount, YearMonthDay startDate, YearMonthDay endDate, BigDecimal penaltyPercentage, Integer maxMonthsToApplyPenalty, Integer numberOfDaysToStartApplyingPenalty) {
        this();
        this.init(paymentPlan, amount, startDate, endDate, penaltyPercentage, maxMonthsToApplyPenalty, numberOfDaysToStartApplyingPenalty);
    }

    protected void init(PaymentPlan paymentPlan, Money amount, YearMonthDay startDate, YearMonthDay endDate, BigDecimal penaltyPercentage, Integer maxMonthsToApplyPenalty, Integer numberOfDaysToStartApplyingPenalty) {
        super.init(paymentPlan, amount, startDate, endDate, penaltyPercentage);
        this.checkParameters(maxMonthsToApplyPenalty, numberOfDaysToStartApplyingPenalty);
        super.setMaxMonthsToApplyPenalty(maxMonthsToApplyPenalty);
        super.setNumberOfDaysToStartApplyingPenalty(numberOfDaysToStartApplyingPenalty);
    }

    private void checkParameters(Integer maxMonthsToApplyPenalty, Integer numberOfDaysToStartApplyingPenalty) {
        if (maxMonthsToApplyPenalty == null) {
            throw new DomainException("error.accounting.installments.InstallmentForFirstTimeStudents.maxMonthsToApplyPenalty.cannot.be.null", new String[0]);
        }
        if (maxMonthsToApplyPenalty <= 0) {
            throw new DomainException("error.accounting.installments.InstallmentForFirstTimeStudents.maxMonthsToApplyPenalty.cannot.be.null", new String[0]);
        }
        if (numberOfDaysToStartApplyingPenalty == null) {
            throw new DomainException("error.accounting.installments.InstallmentForFirstTimeStudents.numberOfDaysToStartApplyingPenalty.cannot.be.null", new String[0]);
        }
        if (numberOfDaysToStartApplyingPenalty <= 0) {
            throw new DomainException("error.accounting.installments.InstallmentForFirstTimeStudents.numberOfDaysToStartApplyingPenalty.must.be.greater.than.zero", new String[0]);
        }
    }

    public YearMonthDay getWhenStartToApplyPenalty() {
        throw new DomainException("error.InstallmentForFirstTimeStudents.unsupported.operation", new String[0]);
    }

    protected Money calculatePenaltyAmount(Event event, DateTime when, BigDecimal discountPercentage) {
        if (when.toDateMidnight().compareTo((ReadableInstant)this.getWhenStartToApplyPenalty(event, when)) >= 0) {
            return new Money(this.calculateMonthPenalty(event, discountPercentage).multiply(new BigDecimal(this.getNumberOfMonthsToChargePenalty(event, when))));
        }
        return Money.ZERO;
    }

    private DateMidnight getWhenStartToApplyPenalty(Event event, DateTime when) {
        GratuityEvent gratuityEvent = (GratuityEvent)((Object)event);
        DateMidnight startDate = gratuityEvent.getRegistration().getStartDate().toDateMidnight();
        return startDate.plusDays(this.getNumberOfDaysToStartApplyingPenalty().intValue()).plusMonths(1).withDayOfMonth(1);
    }

    private int getNumberOfMonthsToChargePenalty(Event event, DateTime when) {
        Period period = new Period((ReadableInstant)this.getWhenStartToApplyPenalty(event, when), (ReadableInstant)when.toDateMidnight());
        int numberOfMonths = period.getYears() * 12 + (period.getMonths() + 1);
        return numberOfMonths < this.getMaxMonthsToApplyPenalty() ? numberOfMonths : this.getMaxMonthsToApplyPenalty();
    }

    public LabelFormatter getDescription() {
        return new LabelFormatter().appendLabel("resources.ApplicationResources", "label.InstallmentForFirstTimeStudents.description", this.getInstallmentOrder().toString(), this.getStartDate().toString("dd/MM/yyyy"), this.getEndDate().toString("dd/MM/yyyy"), this.getPenaltyPercentage().multiply(BigDecimal.valueOf(100L)).toString(), this.getNumberOfDaysToStartApplyingPenalty().toString());
    }

    public boolean isForFirstTimeStudents() {
        return true;
    }

    public LocalDate getEndDate(Event event) {
        GratuityEvent gratuityEvent = (GratuityEvent)((Object)event);
        LocalDate startDate = gratuityEvent.getRegistration().getStartDate().toLocalDate();
        return startDate.plusDays(this.getNumberOfDaysToStartApplyingPenalty().intValue());
    }

    public void edit(InstallmentBean bean) {
        Integer numberOfDaysToStartApplyingPenalty = bean.getNumberOfDaysToStartApplyingPenalty();
        Integer maxMonthsToApplyPenalty = bean.getMaxMonthsToApplyPenalty();
        this.checkParameters(maxMonthsToApplyPenalty, numberOfDaysToStartApplyingPenalty);
        super.setNumberOfDaysToStartApplyingPenalty(numberOfDaysToStartApplyingPenalty);
        super.edit(bean);
    }
}

