/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.accounting.EventType;

public enum PenaltyExemptionJustificationType {
    SOCIAL_SHARE_GRANT_OWNER,
    ENROLMENT_AFTER_EQUIVALENCE,
    DIRECTIVE_COUNCIL_AUTHORIZATION,
    NUCLEUS_COORDINATOR_AUTHORIZATION,
    SEPARATION_CYCLES_AUTHORIZATION;


    public String getName() {
        return this.name();
    }

    public String getQualifiedName() {
        return PenaltyExemptionJustificationType.class.getSimpleName() + "." + this.name();
    }

    public String getFullyQualifiedName() {
        return PenaltyExemptionJustificationType.class.getName() + "." + this.name();
    }

    public static List<PenaltyExemptionJustificationType> getValuesFor(EventType eventType) {
        switch (eventType) {
            case ADMINISTRATIVE_OFFICE_FEE_INSURANCE: {
                return Arrays.asList(ENROLMENT_AFTER_EQUIVALENCE, DIRECTIVE_COUNCIL_AUTHORIZATION, NUCLEUS_COORDINATOR_AUTHORIZATION);
            }
            case GRATUITY: {
                return Arrays.asList(SOCIAL_SHARE_GRANT_OWNER, ENROLMENT_AFTER_EQUIVALENCE, DIRECTIVE_COUNCIL_AUTHORIZATION, NUCLEUS_COORDINATOR_AUTHORIZATION, SEPARATION_CYCLES_AUTHORIZATION);
            }
            case IMPROVEMENT_OF_APPROVED_ENROLMENT: {
                return Arrays.asList(NUCLEUS_COORDINATOR_AUTHORIZATION);
            }
            case PHD_REGISTRATION_FEE: {
                return Arrays.asList(DIRECTIVE_COUNCIL_AUTHORIZATION, NUCLEUS_COORDINATOR_AUTHORIZATION);
            }
        }
        return Collections.EMPTY_LIST;
    }
}

