/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.Alumni;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.accessControl.FenixGroup;
import org.fenixedu.academic.domain.accessControl.PersistentAlumniGroup;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.bennu.core.annotation.GroupArgument;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

@GroupOperator(value="alumni")
public class AlumniGroup
extends FenixGroup {
    private static final long serialVersionUID = 5431112068108722868L;
    @GroupArgument(value="")
    private Degree degree;

    private AlumniGroup() {
    }

    private AlumniGroup(Degree degree) {
        this();
        this.degree = degree;
    }

    public static AlumniGroup get() {
        return new AlumniGroup();
    }

    public static AlumniGroup get(Degree degree) {
        return new AlumniGroup(degree);
    }

    @Override
    public String[] getPresentationNameKeyArgs() {
        return new String[]{this.degree == null ? "" : BundleUtil.getString((String)"resources.GroupNameResources", (String)"label.name.connector.default", (String[])new String[0]) + this.degree.getPresentationName()};
    }

    public Set<User> getMembers() {
        return this.getMembers(DateTime.now());
    }

    public Set<User> getMembers(DateTime when) {
        HashSet<User> users = new HashSet<User>();
        for (Alumni alumni : Bennu.getInstance().getAlumnisSet()) {
            User user = alumni.getStudent().getPerson().getUser();
            if (user == null || this.degree != null && !this.isMember(user, when)) continue;
            users.add(user);
        }
        return users;
    }

    public boolean isMember(User user) {
        return this.isMember(user, DateTime.now());
    }

    public boolean isMember(User user, DateTime when) {
        if (user == null || user.getPerson().getStudent() == null || user.getPerson().getStudent().getAlumni() == null) {
            return false;
        }
        if (this.degree != null) {
            for (Registration registration : user.getPerson().getStudent().getRegistrationsFor(this.degree)) {
                if (!registration.isRegistrationConclusionProcessed()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public PersistentGroup toPersistentGroup() {
        return PersistentAlumniGroup.getInstance(this.degree);
    }

    public boolean equals(Object object) {
        if (object instanceof AlumniGroup) {
            return Objects.equal((Object)this.degree, (Object)((AlumniGroup)((Object)object)).degree);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.degree});
    }
}

