/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Comparator;
import java.util.Date;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.Project;
import org.fenixedu.academic.domain.ProjectSubmissionFile;
import org.fenixedu.academic.domain.ProjectSubmission_Base;
import org.fenixedu.academic.domain.StudentGroup;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class ProjectSubmission
extends ProjectSubmission_Base {
    public static Comparator<ProjectSubmission> COMPARATOR_BY_MOST_RECENT_SUBMISSION_DATE;
    public static Comparator COMPARATOR_BY_GROUP_NUMBER;
    public static Comparator COMPARATOR_BY_GROUP_NUMBER_AND_MOST_RECENT_SUBMISSION_DATE;

    public ProjectSubmission(Project project, StudentGroup studentGroup, Attends attends, ProjectSubmissionFile projectSubmissionFile) {
        this.setRootDomainObject(Bennu.getInstance());
        this.setSubmissionDateTime(new DateTime());
        this.setStudentGroup(studentGroup);
        this.setAttends(attends);
        this.setProjectSubmissionFile(projectSubmissionFile);
        this.setProject(project);
    }

    public void delete() {
        this.getProjectSubmissionFile().delete();
        this.setAttends(null);
        this.setProject(null);
        this.setStudentGroup(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public boolean isTeacherObservationAvailable() {
        return !StringUtils.isEmpty((String)this.getTeacherObservation());
    }

    @Deprecated
    public Date getSubmission() {
        DateTime dt = this.getSubmissionDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setSubmission(Date date) {
        if (date == null) {
            this.setSubmissionDateTime(null);
        } else {
            this.setSubmissionDateTime(new DateTime(date.getTime()));
        }
    }

    static {
        ProjectSubmission.getRelationProjectSubmissionProject().addListener((RelationListener)new ProjectSubmissionProjectListener());
        COMPARATOR_BY_MOST_RECENT_SUBMISSION_DATE = new Comparator<ProjectSubmission>(){

            @Override
            public int compare(ProjectSubmission projectSubmission, ProjectSubmission otherProjectSubmission) {
                int comparationResult = projectSubmission.getSubmissionDateTime().compareTo((ReadableInstant)otherProjectSubmission.getSubmissionDateTime());
                return comparationResult == 0 ? projectSubmission.getExternalId().compareTo(otherProjectSubmission.getExternalId()) : -comparationResult;
            }
        };
        COMPARATOR_BY_GROUP_NUMBER = new BeanComparator("studentGroup.groupNumber");
        COMPARATOR_BY_GROUP_NUMBER_AND_MOST_RECENT_SUBMISSION_DATE = new ComparatorChain();
        ((ComparatorChain)COMPARATOR_BY_GROUP_NUMBER_AND_MOST_RECENT_SUBMISSION_DATE).addComparator(COMPARATOR_BY_GROUP_NUMBER);
        ((ComparatorChain)COMPARATOR_BY_GROUP_NUMBER_AND_MOST_RECENT_SUBMISSION_DATE).addComparator(COMPARATOR_BY_MOST_RECENT_SUBMISSION_DATE);
    }

    private static class ProjectSubmissionProjectListener
    extends RelationAdapter<ProjectSubmission, Project> {
        private ProjectSubmissionProjectListener() {
        }

        public void beforeAdd(ProjectSubmission projectSubmission, Project project) {
            if (project != null && projectSubmission != null) {
                if (!project.isSubmissionPeriodOpen()) {
                    throw new DomainException("error.project.submissionPeriodAlreadyExpired", new String[0]);
                }
                if (!project.canAddNewSubmissionWithoutExceedLimit(projectSubmission.getStudentGroup())) {
                    project.getOldestProjectSubmissionForStudentGroup(projectSubmission.getStudentGroup()).delete();
                }
                if (projectSubmission.getStudentGroup().getGrouping() != project.getGrouping()) {
                    throw new DomainException("error.project.studentGroupDoesNotBelongToProjectGrouping", new String[0]);
                }
            }
            super.beforeAdd((DomainObject)projectSubmission, (DomainObject)project);
        }
    }
}

