/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.candidacy.degree.ShiftDistribution;
import org.fenixedu.academic.domain.candidacy.degree.ShiftDistributionEntry;
import org.fenixedu.academic.dto.GenericPair;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.ShiftDistributionFileBean$callable$writeDistribution;
import org.fenixedu.commons.StringNormalizer;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ShiftDistributionFileBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient InputStream inputStream;
    private String filename;
    private boolean firstPhase;
    private Map<Shift, List<GenericPair<DegreeCurricularPlan, Integer>>> distribution;
    private Map<DegreeCurricularPlan, List<Integer>> abstractStudentNumbers;
    public static final Advice advice$writeDistribution = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public ShiftDistributionFileBean() {
        this.setFirstPhase(true);
    }

    protected void writeDistribution() {
        Object object = advice$writeDistribution.perform((Callable)new ShiftDistributionFileBean$callable$writeDistribution(this));
    }

    protected static /* synthetic */ void advised$writeDistribution(ShiftDistributionFileBean this_) {
        ExecutionYear executionYear = ExecutionSemester.readActualExecutionSemester().getExecutionYear();
        ShiftDistribution shiftDistribution = executionYear.getShiftDistribution() != null ? executionYear.getShiftDistribution() : executionYear.createShiftDistribution();
        for (Map.Entry<Shift, List<GenericPair<DegreeCurricularPlan, Integer>>> entry : this_.getDistribution().entrySet()) {
            for (GenericPair<DegreeCurricularPlan, Integer> pair : entry.getValue()) {
                new ShiftDistributionEntry(shiftDistribution, pair.getLeft().getExecutionDegreeByYear(executionYear), entry.getKey(), pair.getRight());
            }
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = StringNormalizer.normalize((String)filename);
    }

    public void setFirstPhase(boolean firstPhase) {
        this.firstPhase = firstPhase;
    }

    public boolean isFirstPhase() {
        return this.firstPhase;
    }

    public void setDistribution(Map<Shift, List<GenericPair<DegreeCurricularPlan, Integer>>> distribution) {
        this.distribution = distribution;
    }

    public Map<Shift, List<GenericPair<DegreeCurricularPlan, Integer>>> getDistribution() {
        return this.distribution;
    }

    public void setAbstractStudentNumbers(Map<DegreeCurricularPlan, List<Integer>> abstractStudentNumbers) {
        this.abstractStudentNumbers = abstractStudentNumbers;
    }

    public Map<DegreeCurricularPlan, List<Integer>> getAbstractStudentNumbers() {
        return this.abstractStudentNumbers;
    }

    public int getPhaseNumber() {
        if (this.isFirstPhase()) {
            return 1;
        }
        return 2;
    }
}

